// This code is LGPL, see licence.txt for details
//
#include <allegro.h>

#include "points.h"

void c_points::clear()
{
        walk_point *temp = entry,*temp2;
        while(temp) {
          temp2=temp->next;
          delete temp;
          temp=temp2;
        }
        entry=NULL;
}

void c_points::save(PACKFILE *p)
{
   walk_point *temp = entry;

   int i=0;

   while(temp) {
     temp=temp->next;
     i++;
   }
   temp=entry;

   pack_iputl(i,p);

   while(temp)
   {
     pack_iputl(temp->x,p);
     pack_iputl(temp->y,p);
     pack_iputl(temp->key,p);
     pack_iputl(temp->nextkey,p);
     temp=temp->next;
   }

}

void c_points::load(PACKFILE *p)
{
   walk_point *temp;

   int i,l;

   l = pack_igetl(p);

   for(i=0;i<l&&!pack_feof(p);i++)
   {
     temp = new walk_point;
     temp->x=pack_igetl(p);
     temp->y=pack_igetl(p);
     temp->key=pack_igetl(p);
     temp->nextkey=pack_igetl(p);

     temp->next=entry;
     entry=temp;
   }

}
walk_point * c_points::get_point(int key)
{
	if (entry==NULL) return 0;
	walk_point * temp = entry;
	do
	{
		if (temp->key==key) return temp;
		temp=temp->next;
	}
	while (temp!=NULL);
	return NULL;
}

int c_points::get_free()
{
	if (entry==NULL) return 0;
	int key=0;
	while(!is_free(key))
		key++;
	return key;
}

int c_points::is_free(int key)
{
	if (entry==NULL) return TRUE;
	if (key<0) return FALSE;
	int free=TRUE;
	walk_point * temp = entry;
	do
	{
		if (temp->key==key) free=FALSE;
		temp=temp->next;
	}
	while (temp!=NULL);
	return free;
}

void c_points::add(int x, int y, int key, int nextkey)
{
	if (!is_free(key)) return;
	walk_point * newp = new walk_point;
	newp->key=key;
	newp->next=NULL;
	newp->nextkey=nextkey;
	newp->x=x;
	newp->y=y;
	if (entry==NULL)
		entry=newp;
	else
	{
		walk_point *temp = entry;
		while (temp->next!=NULL) temp=temp->next;
		temp->next=newp;
	}
	return;
}

void c_points::draw(int mode,BITMAP * bmp,int x, int y)
{
	if (entry==NULL) return;
	walk_point * temp = entry;
	do
	{
		draw_point(temp,bmp,x,y);
		if(mode==TRUE) draw_more(temp,bmp,x,y);
		temp=temp->next;
	}
	while (temp!=NULL);	
}

void c_points::draw_point(walk_point * point,BITMAP * bmp,int x,int y)
{
	int col=makecol(255,255,255);
	putpixel(bmp,-x+point->x,-y+point->y,col);
	rect(bmp,-x+point->x-5,-y+point->y-5,-x+point->x+5,-y+point->y+5,col);
   
}


void c_points::draw_more(walk_point * point,BITMAP * bmp,int x,int y)
{
	int col=makecol(255,255,255);
	int hor,ver;
	if (point->nextkey<0) return;
	walk_point * nextp= get_point(point->nextkey);
	if (nextp==NULL) return;
	if (point->x>=nextp->x) hor=5; else hor=-5;
	if (point->y>=nextp->y) ver=5; else ver=-5;
	line(bmp,point->x-x,point->y-y,nextp->x-x+hor,nextp->y-y+ver,col);  
}

int c_points::what_point(int x, int y)
{
	if (entry==NULL) return -1;
	int key=-1;
	walk_point * temp = entry;
	do
	{
		if (x<temp->x+5 && x> temp->x-5 && y< temp->y+5 && y> temp->y-5) return temp->key;
		temp=temp->next;
	}
	while (temp!=NULL);
	return -1;
}

void c_points::move(int key, int x, int y)
{
	if (key<0) return;
	walk_point * point = get_point(key);
	if (point==NULL) return;
	point->x=x;
	point->y=y;
}


int c_points::get_next_key(int key)
{
	if (key<0) return -1;
	walk_point * point = get_point(key);
	if (point==NULL) return -1;
	return point->nextkey;
}

int c_points::change(int oldkey, int key, int nextkey)
{
	if (oldkey<0 || key<0) return -1;
	if (!is_free(key) && oldkey!=key) return -1;
	walk_point * point=get_point(oldkey);
	if (point==NULL) return -1;
	point->key=key;
	point->nextkey=nextkey;
	return 0;
}
	

int c_points::remove(int key)
{
	if (key<0) return -1;
	walk_point * point=get_point(key);
	if (point==NULL) return -1;
	walk_point * temp = entry;

	while (temp!=NULL)
	{
		if (temp->next==point) break;
		temp=temp->next;
	}

	if (temp!=NULL)
		temp->next=point->next;		
	else
		entry=point->next;
	delete point;
	return 0;
}

int c_points::getX(int key, int *x)
{
	if (key<0) return FALSE;
	walk_point * point= get_point(key);
	if (point==NULL) return FALSE;
	*x=point->x;
	return TRUE;
}

int c_points::getY(int key, int *y)
{
	if (key<0) return FALSE;
	walk_point * point= get_point(key);
	if (point==NULL) return FALSE;
	*y=point->y;
	return TRUE;
}
