// This code is LGPL, see licence.txt for details
//
#ifndef _VM_H_
#define _VM_H_

// VM.H: Header file for VM.CPP
#include <vector>
using std::vector;
#include "stack.h"    // Stack template class
#include "synttree.h"
#include "intcode.h"

// Instruction class
class Instr {
public:
   Instr ()   {opcode = OP_NOP; operand = 0;}
   Instr (Opcode _opcode)   {opcode = _opcode; operand = 0;}
   Instr (Opcode _opcode, int _operand)  {opcode = _opcode; operand = _operand;}

   Opcode    opcode;    // the opcode
   int       operand;   // string number or target instruction
   hrs_func  *call;     // function to call
};

// Some defines and constants
typedef Stack<int> VM_Stack; // <  0 : boolean
                             // >= 0 : index to string table
const int ST_TRUE  = -1,  // stack codes for TRUE/FALSE
          ST_FALSE = -2;

const int MAX_STR = 1000;  // max. num. of variables in memory (including temps)

// The virtual machine class
class VMachine  {
public:
   VMachine ();
   ~VMachine ();
   void Read ();
   void Execute ();
   void Reset ();
   void Clear();
private:
   // functions to make temp.copies of strings
   int NewTempCopy ();
   int NewTempCopy (hrs_variable *a);
   int NewTempCopy (int j);
   int NewTempCopy (char *s);
   void DelTempCopy (int i);

   Instr   *instr;  // the instructions
   int      ninstr; // num. of instr.
   hrs_variable  *str[MAX_STR];  // the variable table (NULL=entry not used)
   //vector<hrs_variable *> str;
   int total_builtin;            // the total number of builtin vars to this script.
   VM_Stack stack;  // the stack
};

#endif
