#ifndef _SYNTTREE_H_
#define _SYNTTREE_H_

// The syntax tree node types
enum NodeType  {
   // Statements
   STMT_LIST,        // list of statements [left-part, right-part] (left-part may be another list)
   EMPTY_STMT,       // empty statement []
   LABEL_STMT,       // label statement [] (link to symbol table)
   GOTO_STMT,        // goto statement [] (link to symbol table)
   EXPR_STMT,        // single expression as statement [expression]
   FUNCTION_STMT,    // function statement [arg_list]
   WHILE_STMT,       // while loop [cond, loop]
   DO_STMT,          // do while loop [cond, loop]
   IFTHEN_STMT,      // if statement [cond, if-part]
   IFTHENELSE_STMT,  // if statement with else [cond, if-part, else-part]
   ERROR_STMT,       // error statement
   
   // Expressions
   ARG_LIST,         // list of expresions for a function [left-part, right-part] (left-part may be another list)
   EQUAL_EXPR,       // equality expression [op1, op2]
   NOTEQUAL_EXPR,    // not equal expression [op1, op2]
   AND_EXPR,         // and expression [op1,op2]
   OR_EXPR,          // and expression [op1,op2]
   NOT_EXPR,         // not expression [op1]
   LT_EXPR,          // < [op1,op2]
   GT_EXPR,          // > [op1,op2]
   LTET_EXPR,        // <= [op1,op2]
   GTET_EXPR,        // >= [op1,op2]
   ASSIGN_EXPR,      // assignment expression [variable, op2]
   
   ADD_EXPR,         // add expression [op1, op2]
   SUB_EXPR,         // sub expression [op1, op2]
   MUL_EXPR,         // multiply expression [op1, op2]
   DIV_EXPR,         // divide expression [op1, op2]
   POW_EXPR,         // power expression [op1, op2]
   NEG_EXPR,         // negitive expression [op1]
   MOD_EXPR,         // moduless expression [op1, op2]
   CONCAT_EXPR,      // concatenation expression [op1, op2]
   IDENT_EXPR,       // identifier (link to symbol table)
   CONST_EXPR,       // constant (link to symbol table)
   
   INT2STR_EXPR,     // convert the integer to a string [op1]
   INT2REAL_EXPR     // convert the integer to a floating point number [op1]
};

enum DataType  {
   T_VOID,
   T_VAR,
   T_STRING,
   T_INT,
   T_FLOAT,
   T_BOOL
};

const int MXCHILD = 3;   // max. number of children a tree node can have

class SymDesc;

// The syntax tree node class
class TreeNode  {
public:
   TreeNode (NodeType _type)   {type = _type; child[0] = NULL; child[1]=NULL; child[2]=NULL; Check();}
   TreeNode (NodeType _type, TreeNode *child1)   {type = _type; child[0] = child1; child[1]=NULL; child[2]=NULL; Check();}
   TreeNode (NodeType _type, TreeNode *child1, TreeNode *child2)   {type = _type; child[0] = child1; child[1]=child2; child[2]=NULL; Check();}
   TreeNode (NodeType _type, TreeNode *child1, TreeNode *child2, TreeNode *child3)  {type = _type; child[0] = child1; child[1]=child2; child[2]=child3; Check();}
   ~TreeNode() {if(this==NULL) return; delete next;}
   void Show ()  {Show(0);}    // Show the tree contents
   void Check ();              // Check the node for semantic errors

   NodeType type;              // what type of node is it?
   hrs_func *call;             // pointer to function, if applicable
   SymDesc  *symbol;           // pointer to symbol, if applicable
   TreeNode *child[MXCHILD];   // pointers to children
   TreeNode *next;             // used to track all the nodes.
   DataType rettype;           // the 'return' type of the node
private:
   void Show (int level);
};

typedef TreeNode *SyntTree;

#endif
