
#ifndef _POINTER_HEADER_
#define _POINTER_HEADER_

struct walk_point
{
	int x,y; //coordinated ofcourse
	int key; //key
	int nextkey; //used for path, defines the next point's key
	walk_point * next; //for linked list
};


class c_points
{
private:
	walk_point * entry;
	walk_point * get_point(int key);
	void draw_point(walk_point *point,BITMAP * bmp,int x,int y);
	void draw_more(walk_point *point,BITMAP * bmp,int x,int y); //if in correct mode draw some more stuff
public:
	int active_point;
	c_points()
	{
		entry=NULL;
		active_point=-1;
	};
        void clear();
	~c_points()  {clear();}
        int get_free();				//get the first free key
	int is_free(int key);		//checks if a key is still free
	void add(int x, int y, int key, int nextkey);	//add a key
	int change(int oldkey,int key, int nextkey); //change
	void move(int key, int x, int y);
	int remove(int key);						//delete
	void draw(int mode,BITMAP * bmp,int x, int y);		//draw (only for map-editor) 0=normal 1=with numers
	int what_point(int x, int y); //for map-editor, looks up what point you're standing on with your mouse
	int get_next_key(int key);
	int getX(int key, int *x);
	int getY(int key, int *y);
	void save(PACKFILE *p);
        void load(PACKFILE *p);
};
#endif
