// This code is LGPL...
#ifndef _NPC_HEADER_
#define _NPC_HEADER_
class c_map;
struct viewport;

struct map_char // this is used to store characters and NPCs on map
                // this is also what the mapeditor uses when dealing with npcs
{
  int key;               // we have to set the key here.
  int x,y;               // location
  char *datafile_name;   // name of the datafile used
  BITMAP *pict;          // this first frame of the character
  int facing;            // what direction is the character facing at load-time?
  int walk_layer;        // what layer are they on?
  int flags;
  char *init_script;     // this script is called when the map is loaded
  char *action_script;   // this script is called when the player faces this character and pushes action
  char *logic_script;    // this script is called each logic update
  char *player_script;   // this script is called when the player get with in 'range' of this character.
  VMachine *is;
  VMachine *as;
  VMachine *ls;
  VMachine *ps;  
};
#define STEP_SIZE 0.12

#define CHAR_SHADOW		1 // draw the shadow?
#define CHAR_VISIBLE		2 // is it visible?
#define CHAR_SACTION		4 // does the character use action script?
#define CHAR_SPLAYER		8 // does the character use the player script?
#define CHAR_SINIT		16 // Init script?
#define CHAR_SLOGIC		32 // Logic script?
#define CHAR_RANDOM		64 //is the mobile randomly walking around?
#define CHAR_FOLLOW		128 //is the mobile following the path?
#define CHAR_ISPLAYER		256 // this mobile is the player character!!!!

#define CHAR_MAX_POINTS	10   // what is this for bram? //Bram: I guess it was the maximum number of walk-points???


class animation {
public:
  char *name;
  int frame_count;
  struct frame {
    int picture;
	int flip;
  } *frames;
};
class Mobile
{
//friends: 
    friend class mob_list;
  private:
    int key;              // the key of the NPC 
    int flags;		   // same as above
    int facing;	   // the direction this npc is facing
    int x,y;              // the current location
    int x2,y2;            // the next place to walk to.
    int z;                // the height of the character
    DATAFILE *char_data;  // the character datafile
    int layer;            // the layer this npc is on
    int draw_layer;       // the layer to draw the character at.
    int ax1,ax2,ay1,ay2;  // limits the area where the NPC can walk around randomly
    int dest_point;       // the next destination point (key) (-1 for none)
    int follow;           // are we following the path?
    double step;          // controls animation
    int walking;          // is the character currently animated?

    int in_trig[50];                   // stores if this Mobile is inside a
  
    int has_reflection;                // has a reflection?
    BITMAP *reflection;                // the bitmap for the reflection it is now ready to be blited
    BITMAP *rtarget;                   // the bitmap the reflection will be drawn on
    int rfx,rfy;                       // other reflection parameters
                                       
    int disabled;                      // is the mob's logic disable
    static int override;               // if true overides disable variable on all mobs.
                                       // 0 no override, 1 all mobs are disabled, 2 no mobs are disabled
    animation *directions[8];

    VMachine *as;
    VMachine *ls;
    VMachine *ps;
    VMachine *is;

    Mobile *next;                 // used for linked list
    
  public:
    Mobile(int _key,char *name,int _x,int _y,int _facing,int _layer,int _dest,int _flags);
    Mobile(map_char * templ);
    ~Mobile();                 // free memory used

    Mobile *get_next();
    void draw_reflection();   // renders any buffered reflections and frees them!!
    
    // controls hieght of the character (for stairs and slopes)
    void reset_height(); // sets the height back to 0
    void set_height(int _z,c_map *mp,class mob_list *m);

    // these commands are for scripts and the player character
    void move(int dir,int steps,c_map *mp,class mob_list *m); // move steps in direction dir returns FALSE if the character didn't move at all.
    void stop(); // stop moving..
    void center(c_map *mp,viewport *v); // makes this character in the center of v.
    void warp_to(int _x,int _y,int _layer,int _facing); // changes the characters location fast! note layer -1 makes the Mobile invisible.
    void walk_to(int pkey,int _follow,c_map *mp); // walks to point with key pkey. 
                                        // follow is the number of extra steps to take (0 means go to that point only, 1 means also go to the next one and so on, -1 means walk as far as you can)
    int get_x();  // returns the x and y
    int get_y();   
    int get_z();
    int get_draw_layer();
    int get_reflect_layer(c_map *mp);
    int get_reflect_y(c_map *mp);
    int get_reflect_z(c_map *mp);
    

    // These are general commands to plug the Mobiles into our engine
    void draw(BITMAP *bmp,c_map *mp,viewport *v); // v defines the top left of the screen
    void create_reflection(BITMAP *bmp,c_map *mp,viewport *v);
    void update(c_map *mp,class mob_list *m);     // update the logic
    void setFlag(int flag,int to);                // controls the flags
    int getFlag(int flag);
};

struct mob_tree
{
  Mobile *m;
  mob_tree *left,*right,*parent;
  int reflection; // this is a reflection
  int get_y(c_map *mp) {
    if(reflection) return m->get_reflect_y(mp);
    
    return m->get_y();
  }
  int get_z(c_map *mp) {
    if(reflection) return m->get_reflect_z(mp);
    
    return m->get_z();
  }              
  int get_draw_layer(c_map *mp) {
    if(reflection)
      return m->get_reflect_layer(mp);
    else 
      return m->get_draw_layer();
  }              
  void draw(BITMAP *bmp,c_map *mp,viewport *v)
  {
    if(reflection)
      m->create_reflection(bmp,mp,v);
    else
      m->draw(bmp,mp,v);
  }
  ~mob_tree() {if(!this) return; delete left; delete right; }
};

class mob_list
{
  private:
    Mobile *top;   // top of the list

    mob_tree *tree;  // bin tree for use in drawing them

    int needs_sort; // are the mobs sorted?
    
    void do_character_checks();
    void add_node(c_map *mp,mob_tree *tmp);
    void sort(c_map *mp);   // sorts Mobiles in (layer,y) order for drawing

  public:
    mob_list();
    ~mob_list();
    void clear(); // remove all mobs from the list
    
    void update(c_map *mp); // update the Mobile's logic
    int check_walk(c_map *mp,int key,int x,int y); // checks if mob[key] could stand okay at x,y
    void center(int key,c_map *mp,viewport *v);

    void set_npc_flag(int mob,char *flag,int value);
    void set_npc_var(int mob,char *var,int value);
    int get_npc_flag(int mob,char *flag);
    int get_npc_var(int mob,char *var);
    void disable_mobs(int ovr) {Mobile::override=ovr;}

    void draw(BITMAP *bmp,c_map *mp,viewport *v);

    void add_mob(Mobile *mob);
    void delete_mob(int key);

    Mobile *get_mob(int key);
    Mobile *get_top();
    
};
void NPC_exit();
void NPC_init();

#endif
