#ifndef _MENU_HEADER_
#define _MENU_HEADER_

#define DIAG_FRAME 0
#define DIAG_TEXT 1
#define DIAG_SLIDER 2
#define DIAG_SELECT 3
#define DIAG_PICTURE 4
struct dframe {
  struct dialog_object *child; 

  int opened; // how opened is it? (0 closed to 255 opened)
  int opened2;
  int uarrow; // should a up arrow appear?
  int darrow; // should a down arrow appear?
  

  int child_x,child_y; // where the child objects are drawn 
  int child_w,child_h; // inside
  
  int scroll_y; // used to scroll insides of object
  int scroll_y2;// used to animate the scrolling
  
  BITMAP *pict;
  int pict_type;

};

struct dtext {
  char *text;
  int drawn;      // how much of the text is currently drawn
                  // ( -1 all, 0 none to strlen(paragraph) ) 
  int lines;      // number of lines to draw (-1 all) 
  int speed;      // -1 instant (eg text instantly appears)
                  // 0 slow to 8 fast
  int progress;
  int more;       // display blinking more arrow?
};
extern int dtext_show;


struct dslider {
  int type;          // progress bar or normal slider
  int min_value;     // the smallest value
  int max_value;     // the highest value
  int current_value; // the current value
  int current_value2;// animate current value
  int c1,c2;         // for progress bars
};

struct dselect {
  int up_id,down_id;
  int left_id,right_id;
  int top_y,bottom_y;
  int blink;           // is this select blinking?
};
extern int dselect_active_id;
extern int dselect_show;


struct dpicture {
  BITMAP *pict;     // pointer to a picture to draw
  int overide;
};

struct dialog_object
{
  int real_x,real_y; // where on the screen to draw it

  int x,y;  // where on parent object is.
  int x2,y2;// used to move object
  int w,h;  // note this is the real width and hieght
  int w2,h2;// used to animate the resizing
  int type; // type of object
  int speed;// animation speed

  int id;   // id number of object
  int parent;

  static int total_objects;
  
  union DIALOG_DATA {
    dframe diag_frame;
    dtext diag_text;
    dslider diag_slider;
    dselect diag_select;
    dpicture diag_picture;
  } data;

  dialog_object *next;
};
extern dialog_object *dialogs;
extern dialog_object *dialog_list[400];// a list of pointers to dialog_objects

extern int text_speed; // the average text scroll speed (this should be a variable)

int update_objects(dialog_object *d=dialogs,int obj=-1,int boost_speed=1);
void draw_objects(BITMAP *bmp);
int create_picture(int parent,int x,int y,char *filename,int ovr);
int create_select(int parent,int x,int y,int top_y,int bottom_y);
int create_text(int parent,int x,int y,int w,int v,char *text,int more);
int create_frame(int parent,int x,int y,int w,int h);
int create_slider(int parent,int x,int y,int w,int min,int max,int p,int c1,int c2);
void destroy_dialog_object(int n);
void move_object(int obj_number,int x,int y,int speed);
void resize_object(int obj_number,int w,int h,int speed);
int get_object_width(int obj_number);
int get_object_height(int obj_number);
void open_frame(int frame_number,int speed);
void close_frame(int frame_number,int speed);
void change_text(int text_number,int v,char *text,int more);
void stop_text_scroll(int text_number);
int is_text_scrolling(int text_number);
void change_picture(int pict_number,char *filename);
void set_active_select(int select_number);
void clear_active_select();
int get_active_select();
void select_blink_on(int select_number);
void select_blink_off(int select_number);
int get_select_blink(int select_number);
int left_select(int select_number);
int right_select(int select_number);
int up_select(int select_number);
int down_select(int select_number);
void set_left_select(int select_number,int select_number2);
void set_right_select(int select_number,int select_number2);
void set_up_select(int select_number,int select_number2);
void set_down_select(int select_number,int select_number2);
int create_select_list(int parent,int x,int y,int dx,int dy,int number,int top_y,int bottom_y);
int create_select_grid(int parent,int x,int y,int dx,int dy,int x_number,int y_number,int top_y,int bottom_y);
int get_slider_value(int slider_number);
void set_slider_value(int slider_number,int value,int speed);
void change_slider_color(int slider_number,int c1,int c2);
int get_input();
void wait_for_text_scroll(int text_object);
void wait_for_animation(int text_object);
int dialog_fit(int x,int y,char * name,char *text,int speed,int position);
int question_fit(int x,int y,char *name, char *question,char *answers,int speed,int position);



#endif

