#ifndef _FUNC_H_
#define _FUNC_H_
#include "mystring.h"
extern struct hrs_func *global_hrs_funcs;

class VMachine;

enum {
  VAR_EMPTY,  // holds nothing...
  VAR_INT,
  VAR_REAL,
  VAR_STR,
};

struct hrs_variable {
  char *name;
  int type;
  int constant;
  int temp;
  union {
    int var_int;
    double var_real;
    String *var_string;
  } dat;
  hrs_variable *next;
};
struct hrs_pars {
  int n;
  hrs_variable **pars;
}; // a parameter list


struct hrs_func {
  char *name;    // name of the function
  void *func;
  int argc;
  hrs_func *prev,*next;
};

VMachine *compile_chunk(PACKFILE *p);
VMachine *compile_hrs_script(char *textbuffer,int length);
VMachine *compile_hrs_script(char *filename);
void run_hrs_script(VMachine *script);
void free_hrs_script(VMachine *script);
void run_hrs_script(char *filename);
void run_hrs_script(char *textbuffer,int length);
hrs_variable *call_hrs_func(hrs_func *func,hrs_pars *p);
hrs_func *get_hrs_func(char *name);
hrs_pars *make_par(int argc,...);
void add_hrs_func(char *name,void *func,int argc);
void clear_globals();
hrs_variable *get_global_var(char *name);
void set_global_var(char *name,hrs_variable *var);

int hrs_var_cpy(hrs_variable *a,hrs_variable *b);
int hrs_var_equal(hrs_variable *a,hrs_variable *b);
int clear_hrs_var(hrs_variable *a);
int get_int(hrs_variable *a);
float get_float(hrs_variable *a);
char *get_string(hrs_variable *a);
hrs_variable *make_void(void);
hrs_variable *make_int(int a);
hrs_variable *make_float(float x);
hrs_variable *make_string(char *a);


#endif

