/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "player.h"
#include "params.h"
#include "sounds.h"

Player::Player() : darts_(0), score_(Params::maxPoints), saved_(-1) {}
Player::~Player() {}


void Player::Reset() {
	darts_ = 0;
	score_ = Params::maxPoints;
	saved_ = -1;
}

	
void Player::Throw() {
	--darts_;
}


int Player::DartsLeft() {
	return darts_;
}


int Player::Score() {
	return score_;
}


void Player::AwardPoints(int pts, int f) {
	if (score_ - pts < 0) {
		darts_ = 0;
		Sound::Play(SMP_BUST);
		if (saved_ != -1) {
			score_ = saved_;
			saved_ = -1;
		}
	}
	else {
		if (saved_ == -1) {
			saved_ = score_;
		}
		if (score_ == Params::maxPoints) {
			if ((Params::doubleIn && f == 2) || !Params::doubleIn) {
				score_ -= pts;
			}
		}
		else {
			score_ -= pts;
		}
		if (Params::doubleOut) {
			if ((score_ == 0 && f != 2) || score_ == 1) {
				Sound::Play(SMP_BUST);
				score_ = saved_;
				darts_ = 0;
			}
		}
		if (!DartsLeft()) {
			saved_ = -1;
		}
	}
}


void Player::StartTurn() {
	darts_ = 3;
}
