/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "menu.h"

Menu::Menu() : sel(0), done(false), exit(false), x(0), y(0), w(0), h(0) {
}


Menu::~Menu() {
	item.clear();
}


void Menu::Update() {
	vector<MenuItem>::iterator i;
	for (i = item.begin(); i != item.end(); ++i) {
		i->Update();
	}
}


void Menu::Draw(BITMAP *buffer) {
	vector<MenuItem>::iterator i;
	for (i = item.begin(); i != item.end(); ++i) {
		i->Draw(buffer);
	}
}


void Menu::OnKey(int c) {
	switch (c) {
		case KEY_DOWN:
		case KEY_RIGHT:
			item[sel].Select(false);
			++sel;
			sel %= item.size();
			item[sel].Select(true);
			break;
		case KEY_UP:
		case KEY_LEFT:
			item[sel].Select(false);
			--sel;
			if (sel < 0) {
				sel += item.size();
			}
			item[sel].Select(true);
			break;
		case KEY_SPACE:
		case KEY_ENTER:
			item[sel].OnClick();
			if (item[sel].WillExit()) {
				OnExit();
				done = true;
			}
	};
}


void Menu::Add(const MenuItem &mi) {
	item.push_back(mi);
}


void Menu::OnExit() {
}


void Menu::Reset() {
	done = false;
	sel = 0;
	
	for (int i=0; i<item.size(); ++i) {
		item[i].Select(false);
	}
	item[0].Select();
}
