/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "sounds.h"

DATAFILE *Sound::data = NULL;
	
void Sound::Initialize() {
	data = load_datafile("sounds.dat");
}


void Sound::Destroy() {
	if (data) {
		unload_datafile(data);
	}
}


void Sound::Play(int i, int freq) {
	if (data) {
		if (i == SMP_WIN || i == SMP_BUST) {
			stop_sample((SAMPLE *)data[SMP_25].dat);
			stop_sample((SAMPLE *)data[SMP_50].dat);
			stop_sample((SAMPLE *)data[SMP_DOUBLE].dat);
			stop_sample((SAMPLE *)data[SMP_TRIPLE].dat);
		}
		play_sample((SAMPLE *)data[i].dat, 255, 128, freq, 0);
	}
}
