/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "menuitem.h"
#include "data.h"
#include "params.h"

//inline float Rand() { return (float)(rand()%100) / 200.0f + 0.4f; }
inline float Rand() { return (float)((rand()%100) / (10000.f/Params::fps)) + (20.0f/Params::fps); }

MenuItem::MenuItem(int x, int y, const string &text_, const vector<string> &options_, int sel_, bool exit_)
	:Object(x, y),
	text(text_),
	options(options_),
	sel(sel_),
	exit(exit_),
	selected(false),
	goingUpx(true),
	goingUpy(true),
	startx(x),
	starty(y)
{
	maxvx = Rand();
	maxvy = Rand();
	
	vx = 0.0f;
	vy = 0.0f;
}


MenuItem::~MenuItem() {
	options.clear();
}


void MenuItem::Update() {
	x += vx;
	y += vy;
	
	//float d = 0.25;
	float d = 12.0f/Params::fps;
	if (goingUpx) {
		vx += d;
		if (vx >= maxvx) {
			goingUpx = false;
			maxvx = Rand();
		}
	}
	else {
		vx -= d;
		if (vx <= (0.0f - maxvx)) {
			goingUpx = true;
			maxvx = Rand();
		}
	}

	if (goingUpy) {
		vy += d;
		if (vy >= maxvy) {
			goingUpy = false;
			maxvy = Rand();
		}
	}
	else {
		vy -= d;
		if (vy <= (0.0f - maxvy)) {
			goingUpy = true;
			maxvy = Rand();
		}
	}
	
	float tolx = 30.0f;
	float toly = 10.0f;
	//float f = 0.1f;
	float f = 5.0f/Params::fps;
	if ((x - startx) > tolx) vx = -f*tolx;
	else if ((startx - x) > tolx) vx = f*tolx;
	if ((y - starty) > toly) vy = -f*toly;
	else if ((starty - y) > toly) vy = f*toly;
}


void MenuItem::Draw(BITMAP *buffer) {
	string menuString = text;
	if (!options.empty()) {
		menuString += (" - " + options[sel]);
	}
	textout_centre(buffer, selected == 1 ? Data::font2 : Data::font1, menuString.c_str(), (int)x, (int)y, -1);
}


void MenuItem::OnClick() {
	if (!options.empty()) {
		++sel;
		sel %= options.size();
	}
}
