/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "data.h"

DATAFILE *Data::fontdata = NULL;
FONT *Data::font1 = font;
FONT *Data::font2 = font;
BITMAP *Data::cursor = mouse_sprite;


int Data::Load() {
	fontdata = load_datafile("font.dat");
	if (fontdata) {
		font1 = (FONT *)fontdata[0].dat;
		font2 = (FONT *)fontdata[1].dat;
		set_palette(*(PALETTE *)fontdata[2].dat);
	}
	text_mode(-1);
	cursor = load_bitmap("cursor.tga", NULL);
	if (!cursor) {
		cursor = mouse_sprite;
	}
	
	return 0;
}


void Data::Unload() {
	if (fontdata) {
		unload_datafile(fontdata);
		fontdata = NULL;
	}
	
	if (cursor != mouse_sprite) {
		destroy_bitmap(cursor);
		cursor = mouse_sprite;
	}
}
