/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "mainmenu.h"
#include "params.h"
#include "data.h"

const int MainMenu::NEW_GAME = 0;
const int MainMenu::GAME_TYPE = 1;
const int MainMenu::DOUBLEIN = 2;
const int MainMenu::DOUBLEOUT = 3;
const int MainMenu::DIFFICULTY = 4;
const int MainMenu::RESUME = 5;
const int MainMenu::EXIT = 6;

MainMenu::MainMenu() : Menu(), back(NULL) {
}


MainMenu::~MainMenu() {
	if (back) {
		destroy_bitmap(back);
	}
}


void MainMenu::OnExit() {
	switch (sel) {
		case EXIT:
			exit = true;
		case NEW_GAME:
			switch (item[GAME_TYPE].Selection()) {
				case 0: Params::maxPoints = 301; break;
				case 1: Params::maxPoints = 501; break;
				case 2: Params::maxPoints = 701; break;
				case 3: Params::maxPoints = 901; break;
			}
			Params::doubleIn = item[DOUBLEIN].Selection() == 1 ? 0 : 1;
			Params::doubleOut = item[DOUBLEOUT].Selection() == 1 ? 0 : 1;
			Params::difficulty = item[DIFFICULTY].Selection();
			break;
	};
}


void MainMenu::Make() {
	int x = SCREEN_W/2;
	w = 15*text_length(Data::font1, "A");
	this->x = (SCREEN_W - w)/2;
	int dy = text_height(Data::font1)-2;
	h = 7*dy + 16;
	int y = (SCREEN_H - h)/2;
	this->y = y;
	int sel = 0;
	y = y + 8 - dy;
	
	if (!back) {
		back = create_bitmap(w, h);
		clear_to_color(back, makecol(128,128,144));
	}
	
	vector<string> op1;
	MenuItem m1(x, y+=dy, "New game", op1, 0, true);
	m1.Select();

	vector<string> op2;
	op2.push_back("301");
	op2.push_back("501");
	op2.push_back("701");
	op2.push_back("901");
	switch (Params::maxPoints) {
		case 301: sel = 0; break;
		case 501: sel = 1; break;
		case 701: sel = 2; break;
		case 901: sel = 3; break;
	};
	MenuItem m2(x, y+=dy, "Game type", op2, sel);

	vector<string> op3;
	op3.push_back("yes");
	op3.push_back("no");
	MenuItem m3(x, y+=dy, "Double in", op3, Params::doubleIn == 1 ? 0 : 1);
	MenuItem m4(x, y+=dy, "Double out", op3, Params::doubleOut == 1 ? 0 : 1);

	vector<string> op4;
	op4.push_back("1");
	op4.push_back("2");
	op4.push_back("3");
	op4.push_back("4");
	op4.push_back("5");
	MenuItem m5(x, y+=dy, "Difficulty", op4, Params::difficulty);

	MenuItem m6(x, y+=dy, "Resume", op1, 0, true);
	MenuItem m7(x, y+=dy, "Exit", op1, 0, true);

	Add(m1);
	Add(m2);
	Add(m3);
	Add(m4);
	Add(m5);
	Add(m6);
	Add(m7);
}


void MainMenu::Draw(BITMAP *buffer) {
	if (back) {
		set_trans_blender(0,0,0, 128);
		draw_trans_sprite(buffer, back, x, y);
	}
	Menu::Draw(buffer);
}
