#include "global.h"
#include "maindlg.h"
using namespace MAS;
using namespace std;

static bool lockCursor = false;

MainDlg::MainDlg() : Dialog(), counter(0) {
	Add(desktop);

	set_config_file("book.cfg");
	colBack = Color(get_config_string("BOOK", "back", "212,212,212"));
	colFont = Color(get_config_string("BOOK", "text", "0,0,0"));
	colShadow = Color(get_config_string("BOOK", "texts", "-1"));
	
	fontName = new char[1024];
	ustrcpy(fontName, get_config_string("BOOK", "font", "arial.ttf"));
	fontSize = get_config_int("BOOK", "fontSize", 14);
	
	path = new char[4096];
	ustrcpy(path, get_config_string("BOOK", "lastfile", ""));
	book.LoadLinesFromFile(path);
	bookw.Shape(0, 0, SCREEN_W, SCREEN_H);
	bookw.SetBook(&book);
	bookw.SetLinesPerPage(get_config_int("BOOK", "linesPerPage", 32));
	bookw.GotoPage(get_config_int("BOOK", "lastpage", 0));
	Add(bookw);
	
	char buf[256];
	int count=0;
	while (true) {
		usprintf(buf, "BOOKMARK%d", count);
		const char *title = get_config_string(buf, "path", NULL);
		if (!title) break;
		Bookmark *bm = new Bookmark;
		bm->title = new char[ustrlen(title)+1];
		ustrcpy(bm->title, title);
		bm->page = get_config_int(buf, "page", 0);
		bookmarks.push_back(bm);
		++count;
	}
	
	sc[0].Setup(KEY_O, KB_CTRL_FLAG);
	sc[1].Setup(KEY_W, KB_CTRL_FLAG);
	sc[2].Setup(KEY_Q, KB_CTRL_FLAG);
	sc[3].Setup(KEY_P, KB_CTRL_FLAG);
	sc[4].Setup(KEY_G, KB_CTRL_FLAG);
	sc[5].Setup(KEY_F1);
	sc[6].Setup(KEY_A, KB_CTRL_FLAG);
	sc[7].Setup(KEY_PLUS_PAD);
	sc[8].Setup(KEY_MINUS_PAD);
	sc[9].Setup(KEY_B, KB_CTRL_FLAG);
	for (int i=0; i<10; i++) Add(sc[i]);

	MakeMenu();
}


MainDlg::~MainDlg() {
	set_config_file("book.cfg");
	char buf[256];

	if (colBack) {
		usprintf(buf, "%d,%d,%d", colBack.r(), colBack.g(), colBack.b());
		set_config_string("BOOK", "back", buf);
	}
	else {
		set_config_string("BOOK", "back", "-1");
	}

	if (colFont) {
		usprintf(buf, "%d,%d,%d", colFont.r(), colFont.g(), colFont.b());
		set_config_string("BOOK", "text", buf);
	}
	else {
		set_config_string("BOOK", "text", "-1");
	}

	if (colShadow) {
		usprintf(buf, "%d,%d,%d", colShadow.r(), colShadow.g(), colShadow.b());
		set_config_string("BOOK", "texts", buf);
	}
	else {
		set_config_string("BOOK", "texts", "-1");
	}
	
	set_config_string("BOOK", "lastfile", path);
	set_config_int("BOOK", "lastpage", bookw.CurrentPage());
	set_config_int("BOOK", "linesPerPage", bookw.GetLinesPerPage());
	set_config_string("BOOK", "font", fontName);
	set_config_int("BOOK", "fontSize", fontSize);

	int count = 0;
	for (count = 0; count < bookmarks.size(); count++) {
		Bookmark *bm = bookmarks[count];
		usprintf(buf, "BOOKMARK%d", count);
		set_config_string(buf, "path", bm->title);
		set_config_int(buf, "page", bm->page);
	}
	while (!bookmarks.empty()) {
		Bookmark *bm = bookmarks.back();
		delete bm;
		bookmarks.pop_back();
	}
	while (true) {
		usprintf(buf, "BOOKMARK%d", count);
		if (get_config_int(buf, "page", -2) == -2) break;
		set_config_string(buf, "path", NULL);
		set_config_int(buf, "page", -1);
		++count;
	}

	flush_config_file();
	
	delete [] path;

	Settings::showMouse = true;
}


void MainDlg::MakeMenu() {
	fileMenu.Add("&Open\tCtrl-O", FILE_OPEN);
	fileMenu.Add("&Close\tCtrl-W", FILE_CLOSE);
	fileMenu.Add();
	fileMenu.Add("E&xit\tCtrl-Q", FILE_EXIT);
	
	editMenu.Add("O&ptions\tCtrl-P", EDIT_OPTIONS);
	editMenu.Add("&Goto page\tCtrl-G", EDIT_GOTOPAGE);
	
	bookmarkMenu.Add("&Add bookmark\tCtrl-B", BOOKMARK_ADD);
	bookmarkMenu.Add("&Remove bookmark", bookmarkRemoveMenu);
	bookmarkMenu.Add();
	for (vector<Bookmark *>::iterator i = bookmarks.begin(); i != bookmarks.end(); ++i) {
		AddBookmarkMenuEntry(*i);
	}

	helpMenu.Add("&Index\tF1", HELP_INDEX);
	helpMenu.Add("&About\tCtrl-A", HELP_ABOUT);

	topMenu.Add("&File", fileMenu);
	topMenu.Add("&Edit", editMenu);
	topMenu.Add("&Bookmarks", bookmarkMenu);
	topMenu.Add("&Help", helpMenu);
	
	topMenu.Hide();
	Add(menuHotSpot);
	Add(topMenu);
}


void MainDlg::MsgTick() {
	Dialog::MsgTick();

	if (lockCursor) {
		counter = 0;
		Settings::showMouse = true;
	}
	else {
		int mx, my;
		get_mouse_mickeys(&mx, &my);
		if (mx != 0 || my != 0 || mouse_b || mouse_z) {
			counter = 0;
			Settings::showMouse = true;
		}
		else {
			++counter;
			if (counter > Settings::logicFrameRate*3 && Settings::showMouse) {
				Settings::showMouse = false;
				Redraw();
			}
		}
	}
}


void MainDlg::HandleEvent(MAS::Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	menuHotSpot.Shape(0, 0, topMenu.w(), 2);
	
	switch (msg) {
		case FILE_EXIT:			Close();			break;
		case FILE_OPEN:			OnFileOpen();		break;
		case FILE_CLOSE:		OnFileClose();		break;
		case EDIT_OPTIONS:		OnEditOptions();	break;
		case EDIT_GOTOPAGE:		OnEditGotoPage();	break;
		case BOOKMARK_ADD:		OnAddBookmark();	break;
		case HELP_INDEX:		OnHelpIndex();		break;
		case HELP_ABOUT:		OnHelpAbout();		break;

		case MSG_ACTIVATE:
			if (obj == sc[0])	OnFileOpen();		else
			if (obj == sc[1])	OnFileClose();		else
			if (obj == sc[2])	Close();			else
			if (obj == sc[3])	OnEditOptions();	else
			if (obj == sc[4])	OnEditGotoPage();	else
			if (obj == sc[5])	OnHelpIndex();		else
			if (obj == sc[6])	OnHelpAbout();		else
			if (obj == sc[7])	OnSizeUp();			else
			if (obj == sc[8])	OnSizeDown();		else
			if (obj == sc[9])	OnAddBookmark();		
			break;
		
		case MSG_GOTFOCUS:
			if (obj == bookw) {
				topMenu.Hide();
			}
			break;
		
		case MSG_GOTMOUSE:
			if (obj == menuHotSpot) {
				topMenu.Unhide();
				topMenu.ResetAnimation();
				topMenu.Animate();
			}
			break;
		
		default: {
			if (msg >= 1000 && msg < 2000) {
				OnLoadBookmark(msg - 1000);
			}
			else if (msg >= 2000) {
				OnRemoveBookmark(msg - 2000);
			}
		}
			break;
	};
}


void MainDlg::MsgInitSkin() {
	Dialog::MsgInitSkin();
	
	skin->LoadFont(fontName, Skin::nFonts, fontSize);
	bookw.SetFont(Skin::nFonts, Skin::NORMAL);
	bookw.SetFont(Skin::nFonts, Skin::FOCUS);

	bookw.SetColors(colBack, colFont, colShadow);
}


bool MainDlg::MsgClose() {
	MessageBox msg("Warning!", "Are you sure you want to quit?", NULL, NULL, "Yes", "No", NULL);
	lockCursor = true;
	if (msg.Popup(this) == 1) {
		lockCursor = false;
		return true;
	}
	else {
		GiveFocusTo(&bookw);
		lockCursor = false;
		return false;
	}
}


void MainDlg::OnFileOpen() {
	topMenu.Hide();
	
	FileSelect dlg("Open file...", path, "Text Files (*.txt)|All files (*.*)", FA_ARCH);
	lockCursor = true;
	char *file = dlg.Popup(this);
	lockCursor = false;
	if (file) {
		ustrcpy(path, file);
		book.LoadLinesFromFile(path);
		bookw.SetBook(&book);
	}
	GiveFocusTo(&bookw);
}


void MainDlg::OnFileClose() {
	book.LoadLinesFromFile(NULL);
	bookw.SetBook(&book);
	topMenu.Hide();
	GiveFocusTo(&bookw);
}


void MainDlg::OnEditOptions() {
	topMenu.Hide();
	MessageBox msg("Message", "Not yet implemented", "Edit the 'book.cfg' file manually", "to change the program settings", "OK", NULL, NULL);
	lockCursor = true;
	msg.Popup(this);
	lockCursor = false;
	GiveFocusTo(&bookw);
}


class GetNumberWindow : public Window {
	protected:
		Label nText;
		EditBox nEdit;
		Button OKButton;
		Button CancelButton;

		void UpdateSize() {
			Window::UpdateSize();
		
			int cw = clientArea->w();
			if (!(Flags() & W_MINIMIZED)) {
				int l = skin->GetFont(0).TextLength(nText.GetText());
				nText.Shape(4,	16, 	l,	16);
				nEdit.Shape(cw-60,	12,	56,	22);
				OKButton.Shape(cw/12, 44, 9*cw/24,	22);
				CancelButton.Shape(13*cw/24, 44, 9*cw/24,	22);
			}
		}

	public:
		GetNumberWindow(const char *t, const char *prompt, int def) : Window() {
			title.SetText(t);
			nText.SetText(prompt);
			char buf[24];
			usprintf(buf, "%d", def);
			nEdit.SetText(buf, 6);
			nEdit.MakeExit();
			OKButton.SetText("OK");
			OKButton.MakeExit();
			CancelButton.SetText("Cancel");
			CancelButton.MakeExit();
			
			// Add the objects to the dialog
			Add(nText);
			Add(nEdit);
			Add(OKButton);
			Add(CancelButton);
			
			int w = skin->GetFont(0).TextLength(prompt) + 70;
			clientArea->Resize(w, 72);
			Resize(w, 72);
		}
		
		// this is here because of a bug in MASkinG
		int Popup(Dialog *p) {
			Centre();
			Widget *fw = Window::Popup(p, x(), y(), &nEdit);
			if (!fw || fw == &CancelButton || fw == &iconExit) {
				return 0;
			}
			else {
				return 1;
			}
		}

		int GetNumber() {
			return nEdit.GetInt();
		}
};


void MainDlg::OnEditGotoPage() {
	topMenu.Hide();
	
	GetNumberWindow dlg("Goto page", "destination page", bookw.CurrentPage());
	lockCursor = true;
	if (dlg.Popup(this)) {
		bookw.GotoPage(dlg.GetNumber());
	}
	lockCursor = false;
	GiveFocusTo(&bookw);
}


void MainDlg::OnHelpIndex() {
	topMenu.Hide();
	MessageBox msg("Help", "Use the cursor keys, page up and page down or the mosue to navigate the book.", "Use keypad + and - to change the size of the font.", "Edit the 'book.cfg' configuration file to change program settings.", "OK", NULL, NULL);
	lockCursor = true;
	msg.Popup(this);
	lockCursor = false;
	GiveFocusTo(&bookw);
}


void MainDlg::OnHelpAbout() {
	topMenu.Hide();
	MessageBox msg("About", "Allegro Book Worm v0.91", "Copyright (c) 2004 by Miran Amon", NULL, "OK", NULL, NULL);
	lockCursor = true;
	msg.Popup(this);
	lockCursor = false;
	GiveFocusTo(&bookw);
}


void MainDlg::OnSizeUp() {
	if (fontSize < 72) {
		++fontSize;
		Font f = skin->GetFont(Skin::nFonts);
		f.SetSize(fontSize);
		bookw.Redraw();
	}
}


void MainDlg::OnSizeDown() {
	if (fontSize > 6) {
		--fontSize;
		Font f = skin->GetFont(Skin::nFonts);
		f.SetSize(fontSize);
		bookw.Redraw();
	}
}


void MainDlg::OnAddBookmark() {
	Bookmark *bm = new Bookmark;
	bm->title = new char[ustrlen(book.GetTitle())+1];
	ustrcpy(bm->title, book.GetTitle());
	bm->page = bookw.CurrentPage();
	bookmarks.push_back(bm);
	AddBookmarkMenuEntry(bm);
}


void MainDlg::AddBookmarkMenuEntry(Bookmark *bm) {
	static int menuIndex = 0;
	
	static char buf[256];
	usprintf(buf, "%s,%d", get_filename(bm->title), bm->page);
	bookmarkMenu.Add(buf, 1000+menuIndex);
	bookmarkRemoveMenu.Add(buf, 2000+menuIndex);
	bm->ID = menuIndex;
	++menuIndex;
}


void MainDlg::OnLoadBookmark(int index) {
	topMenu.Hide();

	for (vector<Bookmark *>::iterator i = bookmarks.begin(); i != bookmarks.end(); ++i) {
		Bookmark *bm = *i;
		if (bm->ID == index) {
			char *file = bm->title;
			ustrcpy(path, file);
			book.LoadLinesFromFile(path);
			bookw.SetBook(&book);
			bookw.GotoPage(bm->page);
			GiveFocusTo(&bookw);
			break;
		}
	}
}


void MainDlg::OnRemoveBookmark(int index) {
	bookmarkMenu.Remove(index+3);
	bookmarkRemoveMenu.Remove(index);
	
	for (vector<Bookmark *>::iterator i = bookmarks.begin(); i != bookmarks.end(); ++i) {
		Bookmark *bm = *i;
		if (bm->ID == index) {
			delete bm;
			bookmarks.erase(i);
			break;
		}
	}
}
