#ifndef		BOOKWIDGET_H
#define		BOOKWIDGET_H

#include <MASkinG.h>
#include "book.h"

class BookWidget : public MAS::Widget {
	private:
		Book *book;
		int linesPerPage;
		int nPages;
		int curPage;
		int xOffset;
		int yOffset;
		int pageHeight;
		int textAreaHeight;
		MAS::Color backColor;

	protected:
		void Draw(MAS::Bitmap &canvas);
		void RenderLine(MAS::Bitmap &canvas, MAS::Font &font, const char *line, int x, int y, int maxw, MAS::Color &fg, MAS::Color &bg);
		bool MsgWantfocus();
		bool MsgChar(int c);
		void MsgWheel(int d);
		void MsgLPress();
		void MsgRPress();
	
	public:
		BookWidget();
		virtual ~BookWidget();
	
		void SetBook(Book *book);
		void SetColors(MAS::Color back, MAS::Color font, MAS::Color shd);
		void GotoPage(int i);
		int CurrentPage();
		int NumberOfPages();
		void SetLinesPerPage(int v);
		int GetLinesPerPage();
};

#endif	//BOOKWIDGET_H
