#include "global.h"
#include "book.h"
#include <allegro.h>
#include <fstream>
using namespace std;

Book::Book() : title(NULL) {
}


Book::~Book() {
	lines.clear();
	if (title) {
		delete [] title;
		title = NULL;
	}
}


void Book::LoadLinesFromFile(char *filename) {
	if (title) {
		delete [] title;
		title = NULL;
	}
	
	if (filename) {
		ifstream f;
		f.open(filename, ios::in);
	
		title = new char[ustrsizez(filename)];
		ustrcpy(title, filename);
		
		lines.clear();
		while (f) {
			string s;
			getline(f, s);
			lines.push_back(s); 
		}
		
		f.close();
	}
	else {
		lines.clear();
	}
}


char *Book::GetTitle() {
	return title;
}
