#ifndef		MAINDLG_H
#define		MAINDLG_H

#include <MASkinG.h>
#include "book.h"
#include "bookwidget.h"
#include <vector>

class MainDlg : public MAS::Dialog {
	private:
		MAS::ClearScreen desktop;
		int counter;
		Book book;
		BookWidget bookw;

		MAS::Menu topMenu, fileMenu, editMenu, bookmarkMenu, bookmarkRemoveMenu, helpMenu;
		enum { FILE_EXIT = MSG_SUSER, FILE_OPEN, FILE_CLOSE, EDIT_OPTIONS, EDIT_GOTOPAGE, BOOKMARK_ADD, HELP_INDEX, HELP_ABOUT };
		MAS::Panel menuHotSpot;
		
		MAS::Shortcut sc[10];
	
		MAS::Color colBack, colFont, colShadow;
		char *path;
		char *fontName;
		char fontSize;
		
		struct Bookmark {
			char *title;
			int page;
			int ID;
		};
		
		std::vector<Bookmark *> bookmarks;
	
	protected:
		void MsgInitSkin();
		bool MsgClose();
		void MsgTick();
	
		void MakeMenu();
		void AddBookmarkMenuEntry(Bookmark *bm);
		void OnFileOpen();
		void OnFileClose();
		void OnEditOptions();
		void OnEditGotoPage();
		void OnHelpIndex();
		void OnHelpAbout();
		void OnSizeUp();
		void OnSizeDown();
		void OnAddBookmark();
		void OnLoadBookmark(int index);
		void OnRemoveBookmark(int index);
	
	public:
		MainDlg();
		~MainDlg();
	
		void HandleEvent(MAS::Widget &obj, int msg, int arg1=0, int arg2=0);
};

#endif	//MAINDLG_H
