#ifdef LIBNET

#include <libnet.h>
#include <string.h>

#include "log.h"
#include "net.h"

int serverisrunning=0;
NET_CHANNEL *listenchan=0;
NET_CHANNEL *clientlist=0;

int initserver() {
 int netdriver=NETDRIVER;

 listenchan=net_openchannel(netdriver,"");

 if(!listenchan){
  logmsg("Couldn't open input channel.\n");
  return 1;
 }
 logmsg("Return address is '%s'.\n",net_getlocaladdress(listenchan));
 clientlist=0;

 serverisrunning=1;
 return 0;
}

int endserver() {
 if(!serverisrunning) return 0;

 if(clientlist) {
  net_closechannel(clientlist);
 }\
 net_closechannel(listenchan);

 clientlist=0;
 listenchan=0;

 serverisrunning=0;
 return 0;
}

//  0=ok, got new connection
//  1=error
// -1=no new connection yet
int checkfornewconnection(){
 char address[NET_MAX_ADDRESS_LENGTH];
 char temp[1024];
 int x;
 int netdriver=NETDRIVER;

 x=net_receive(listenchan,temp,1024,address);

 if(x>0&&!strncmp(temp,"hey",3)) {

  logmsg("Client joined from '%s'.\n",address);

  clientlist=net_openchannel(netdriver,NULL);

  if(!clientlist) {
   logmsg("Failed to open channel for '%s'.\n",address);
   return 1;
  }

  logmsg("Return address is '%s'.\n",net_getlocaladdress(clientlist));

  if(net_assigntarget(clientlist,address)){
   logmsg("Couldn't assign target '%s' to channel.\n",address);
   net_closechannel(clientlist);
   return 1;
  }

  strcpy(temp,"OK");
  net_send(clientlist,temp,strlen(temp));

  return 0;
 }

 return -1;
}

#endif
