#include <allegro.h>
#include <math.h>

#include "ob.h"
#include "map.h"
#include "tile.h"
#include "snd.h"
#include "main.h"
#include "game.h"

// k&1  run
// k&2  left
// k&4  right
// k&8  fire
// k&16 back
void processallefant(int n,int k) {
 int w=haveboat[n]?TILE_WATER:TILE_GRASS;
 int c,d;

 // uncheck collision flag
 opos(all[n].x,all[n].y)&=~128;

 // check if we can drop code page
 if(opos(all[n].x,all[n].y)==TILE_LIBRARY) {
  if(ch[n]) {
   ch[n]--;
   opos(all[n].x,all[n].y)=TILE_LIBRARYCODE;
   play_sample(glp,255,127,1000,0);
   if(ch[n]<ADDITIONAL_CODES) {
    if(scod-POS_CODE==0) mod=2;   // game is won
   }
  }
 }

 // check if health should go up
 if(ticks-tlife[n]>100) {
  tlife[n]=ticks;
  if(all[n].l<=99) {
   all[n].l++;
  }
 }

 // check if ammo should refill
 if(ticks-tshot[n]>20) {
  tshot[n]=ticks;
  if(wshot[n]<=99) {
   wshot[n]++;
  }
 }

 // eat some grass?
 if(opos(all[n].x,all[n].y)==TILE_HEALTHYGRASS) {
  if(all[n].l<=90) {
   play_sample(glp,255,127,1000,0);
   all[n].l+=10;
   opos(all[n].x,all[n].y)=TILE_GRASS;
  }
 }

 // pick up a code page
 c=checkcode(all[n].x,all[n].y);
 if(all[c].id==OB_CODE) {
  if(ch[n]<5) {
   saving=1;
   ch[n]++;
   delob(c,&scod);
   if(scod-POS_CODE==70) {
    putpixel(map,512,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==60) {
    putpixel(map,511,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==50) {
    putpixel(map,513,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==40) {
    putpixel(map,510,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==30) {
    putpixel(map,514,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==20) {
    putpixel(map,509,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==10) {
    putpixel(map,515,512-15,TILE_SPAWNDRAGON);
   }
   if(scod-POS_CODE==0) {
    putpixel(map,512,512-14,TILE_SPAWNDRAGON);
   }
  } else toomany=ticks+200;
  play_sample(glp,255,127,1000,0);
 }

 // run
 if(k&1) {
  float g=1;
  if(opos(all[n].x,all[n].y)==TILE_ICE) g=0.4;
  all[n].u+=sin(all[n].a)*g;
  all[n].v-=cos(all[n].a)*g;
 }

 if(k&16) {
  all[n].u-=sin(all[n].a)*0.25;
  all[n].v+=cos(all[n].a)*0.25;
 }

 // fire !
 if(k&8) {
  // enough time has passed since last shot, and enough ammo
  if(ticks-tshot[n]>4&&wshot[n]>0) {
   if(swat<POS_WATER+NUM_WATER) {
    play_sample(spt,255,127,1000,0);
    wshot[n]--;
    tshot[n]=ticks;
    all[swat].a=all[n].a;
    all[swat].u=all[n].u+sin(all[n].a)*7;
    all[swat].v=all[n].v-cos(all[n].a)*7;
    all[swat].x=all[n].x+sin(all[n].a)*30;
    all[swat].y=all[n].y-cos(all[n].a)*30;
    all[swat].id=OB_SHOT;
    all[swat].l=25;
    all[swat].s=0;
    swat++;
   }
  }
 }

 // turn
 if(k&2) all[n].s-=pi/360.0;
 if(k&4) all[n].s+=pi/360.0;

 // oh no, we are dead already
 if(all[n].l<=0) mod=2;

 // some physics formulas
 all[n].x+=all[n].u;
 c=opos(all[n].x,all[n].y);
 if((c&128)||tt[c&127]!=w) {all[n].x-=all[n].u;all[n].u=-all[n].u;}

 all[n].y+=all[n].v;
 d=opos(all[n].x,all[n].y);
 if((d&128)||tt[d&127]!=w) {all[n].y-=all[n].v;all[n].v=-all[n].v;}

 // drinking water ?
 if(c==TILE_WATER||d==TILE_WATER) if(wshot[n]<100) {
  wshot[n]++;
  play_sample(glp,255,127,1000,0);
 }

 // should we pick up a boat ?
 if(tt[c]==TILE_WATER||tt[d]==TILE_WATER) {
  if(!haveboat[n]) if((haveboat[n]=checkboat(all[n].x,all[n].y))) {
   if(tt[c]==TILE_WATER) {all[n].u=-all[n].u;all[n].x+=all[n].u;}
   if(tt[d]==TILE_WATER) {all[n].v=-all[n].v;all[n].y+=all[n].v;}
  }
 }

 // come to land with boat ?
 if(haveboat[n]) {
  all[haveboat[n]].a=all[n].a;
  all[haveboat[n]].x=all[n].x;
  all[haveboat[n]].y=all[n].y;
  if(tt[c]==TILE_GRASS||tt[d]==TILE_GRASS) {
   if(tt[c]==TILE_GRASS) {all[n].u=-all[n].u;all[n].x+=all[n].u;}
   if(tt[d]==TILE_GRASS) {all[n].v=-all[n].v;all[n].y+=all[n].v;}
   haveboat[n]=0;
  }
 }

 // slow down
 all[n].a+=all[n].s;
 if(c==TILE_ICE||d==TILE_ICE){
  all[n].u*=0.98;
  all[n].v*=0.98;
  all[n].s*=0.98;
 }else{
  all[n].u*=0.85;
  all[n].v*=0.85;
  all[n].s*=0.85;
 }

 if(all[n].a<0) all[n].a+=2*pi;
 if(all[n].a>=2*pi) all[n].a-=2*pi;

 // check collision flag and possibly new position
 opos(all[n].x,all[n].y)|=128;

}
