#include <allegro.h>
#include <math.h>

#include "ob.h"
#include "map.h"
#include "tile.h"
#include "snd.h"
#include "main.h"

void processdragon(int n) {
 int c,d;
 float g;  // grip
 float od;
 int r;

 opos(all[n].x,all[n].y)&=~128;
 opos(all[n].x+1,all[n].y)&=~128;
 opos(all[n].x-1,all[n].y)&=~128;
 opos(all[n].x,all[n].y+1)&=~128;
 opos(all[n].x,all[n].y-1)&=~128;

 g=1;

 // distance from player
 od=all[n].e+all[n].f;

 if(od<40000) g=(od+10000)/50000;

 if(all[n+2].id==0) g*=0.75; // lost tail ?
 if(all[n+3].id==0) g*=0.75; // lost left wing ?
 if(all[n+4].id==0) g*=0.75; // lost rigt wing ?

 if(all[n].l<=0) {
  // even if the dragon lost some parts,
  // now they will become visible and everything
  // will be removed correctly
  all[n].id=OB_DEADDRAGON;
  all[n+1].id=OB_DEADDRAGON;
  all[n+2].id=OB_DEADDRAGON;
  all[n+3].id=OB_DEADDRAGON;
  all[n+4].id=OB_DEADDRAGON;
  all[n].l=600;
  all[n+1].l=1000;
  all[n+2].l=500;
  all[n+3].l=400;
  all[n+4].l=400;
  return;
 }

 if(all[n+1].l<=0) all[n+1].id=0;
 if(all[n+2].l<=0) all[n+2].id=0;
 if(all[n+3].l<=0) all[n+3].id=0;
 if(all[n+4].l<=0) all[n+4].id=0;

 all[n].e=all[all[n].t].x-all[n].x;all[n].e*=all[n].e;
 all[n].f=all[all[n].t].y-all[n].y;all[n].f*=all[n].f;

 if(all[n].e+all[n].u*all[n].u+
    all[n].f+all[n].v*all[n].v>=od) {

  r=od; //r=rand(); just a guess of mine...rand() is bad when
  // trying to precalulate what server will do ???

  if(all[n+3].id==0&&all[n+4].id!=0) r=1;  // lost left wing ?
  if(all[n+3].id!=0&&all[n+4].id==0) r=0;  // lost right wing ?
  if(r&1) all[n].s+=pi/45; else all[n].s-=pi/45;
 }

 if(all[n+1].id!=0)  // still got head ?
 if((rand()&63)==1) {
  if(swat<POS_WATER+NUM_WATER) {
   all[swat].a=all[n].a;
   all[swat].u=sin(all[n].a)*20;
   all[swat].v=-cos(all[n].a)*20;
   all[swat].x=all[n].x+sin(all[n].a)*90;
   all[swat].y=all[n].y-cos(all[n].a)*90;
   all[swat].id=OB_FIREBALL;
   all[swat].l=50;
   all[swat].s=0;
   all[swat].t=all[n].t;
   swat++;
  }
 }

 all[n].u+=sin(all[n].a)*g;
 all[n].v-=cos(all[n].a)*g;

 if(checkcollision(all[n].x,all[n].y,all[n].t,4096)) {
  play_sample(yee,255,127,1000,0);
  all[all[n].t].l--;
 }

 // move + turn

 all[n].x+=all[n].u;
 c=opos(all[n].x,all[n].y);
 if((c&128)||
  (tt[c&127]!=TILE_WATER&&
  tt[c&127]!=TILE_GRASS)) {all[n].x-=all[n].u;all[n].u=-all[n].u;}

 all[n].y+=all[n].v;
 d=opos(all[n].x,all[n].y);
 if((d&128)||
  (tt[d&127]!=TILE_WATER&&
  tt[d&127]!=TILE_GRASS)) {all[n].y-=all[n].v;all[n].v=-all[n].v;}

 all[n].a+=all[n].s;

 // slow down

 all[n].u*=0.9;
 all[n].v*=0.9;
 all[n].s*=0.9;

 if(all[n].a<0) all[n].a+=2*pi;
 if(all[n].a>=2*pi) all[n].a-=2*pi;

 opos(all[n].x,all[n].y)|=128;
 opos(all[n].x-1,all[n].y)|=128;
 opos(all[n].x+1,all[n].y)|=128;
 opos(all[n].x,all[n].y-1)|=128;
 opos(all[n].x,all[n].y+1)|=128;

}
