// OB

#include <math.h>

#include "main.h"
#include "map.h"
#include "ob.h"
#include "snd.h"
#include "tile.h"

// all objects are stored in an array of 512 entries
// the following variables mark the end of the objects
// of one of the five types water,flying monster,monster,code or boat
// the players always start with player 0

// 0... splayer-1         players
// POS_WATER... swat-1    shot objects
// POS_FLIGHT... sfmon-1  flying monsters
// POS_MONSTER... smon-1  ground monsters
// POS_CODE... scod-1     code page objects
// POS_BOAT... sbot-1     boat objects

int splayer;
int swat;
int sfmon;
int smon;
int scod;
int sbot;

int ch[NUM_PLAYER];       // the number of currently carried code pages
int ctrl[NUM_PLAYER];     // the control input from the user
int wshot[NUM_PLAYER];    // number of ammo
int haveboat[NUM_PLAYER]; // number of boat we are using, 0 if no
int tlife[NUM_PLAYER];    // time of healing
int tshot[NUM_PLAYER];    // time last shot was fired

object all[512]; // the very heart of this program: the objects array

int toomany=0; // flag indicating the player tried to pick up too many codes

// group the tiles to their terrain type
int tt[]={
 TILE_NO,
 TILE_GRASS,
 TILE_WATER,
 TILE_WALL,
 TILE_GRASS,
 TILE_GRASS,
 TILE_GRASS,
 TILE_GRASS,
 TILE_WATER,
 TILE_GRASS,
 TILE_WALL,       //10
 TILE_GRASS,
 TILE_GRASS,
 TILE_WATER,
 TILE_NO,
 TILE_NO
};

// delete object n, from group terminated by last
// i.e. last is pointer to smon,swat...
void delob(int n,int *last) {
 (*last)--;
 all[n]=all[*last];
 all[*last].id=0;
}

// quadratic distance from object n to position x,y
float distance(int n,float x,float y){
 int dx,dy;
 dx=all[n].x-x;
 dy=all[n].y-y;
 return dx*dx+dy*dy;
}

// check if object n collides with circle at x,y radius r
int checkcollision(float x,float y,int n,float r) { // collision  ?
 return distance(n,x,y)<r?1:0;
}

// check for collision of player with any monster at pos x,y
int check(float x,float y) {
 int n;
 for(n=POS_MONSTER;n<smon;n++){
  if(all[n].id==OB_ALLEGATOR||
     all[n].id==OB_ALLEBEAR||
     all[n].id==OB_ALLEFISH)
  if(distance(n,x,y)<1600){
   return n;
  }
 }
 for(n=POS_FLIGHT;n<sfmon;n++){
  if(all[n].id==OB_DRAGONBODY||
     all[n].id==OB_DRAGONHEAD||
     all[n].id==OB_DRAGONTAIL||
     all[n].id==OB_DRAGONWINGL||
     all[n].id==OB_DRAGONWINGR)
  if(distance(n,x,y)<1600){
   return n;
  }
 }
 return 0;
}

int checkboat(float x,float y) {  // collision of player with boat ?
 int n;
 for(n=POS_BOAT;n<sbot;n++){
  if(distance(n,x,y)<1000){
   return n;
  }
 }
 return 0;
}

int check0(float x,float y,int p) { // collision of monster with player ?
 return distance(p,x,y)<1024?1:0;
}

int checkcode(float x,float y) { // collision of player with code ?
 int n;
 for(n=POS_CODE;n<scod;n++){
  if(distance(n,x,y)<1600){
   return n;
  }
 }
 return 0;
}

// make the objects alive
void processob(int n) {
 // id decides what the object does
 switch(all[n].id) {
  case OB_ALLEFANT: processallefant(n,ctrl[0]); break;
  case OB_ALLEFANT2: processallefant(n,ctrl[1]); break;

  case OB_ALLEBEAR:
  case OB_ALLEFISH:
  case OB_ALLEGATOR: processallemonster(n); break;

  case OB_DRAGONBODY:
   processdragon(n);
  break;

  case OB_DRAGONHEAD:
   all[n].a=all[n-1].a;
   all[n].x=all[n-1].x+sin(all[n].a)*50;
   all[n].y=all[n-1].y-cos(all[n].a)*50;
  break;
  case OB_DRAGONTAIL:
   all[n].a=all[n-2].a;
   all[n].x=all[n-2].x-sin(all[n].a)*50;
   all[n].y=all[n-2].y+cos(all[n].a)*50;
  break;
  case OB_DRAGONWINGL:
   all[n].a=all[n-3].a;
   all[n].x=all[n-3].x-cos(all[n].a)*50;
   all[n].y=all[n-3].y-sin(all[n].a)*50;
  break;
  case OB_DRAGONWINGR:
   all[n].a=all[n-4].a;
   all[n].x=all[n-4].x+cos(all[n].a)*50;
   all[n].y=all[n-4].y+sin(all[n].a)*50;
   all[n].a+=pi; // 180 degree turn
  break;

  case OB_SHOT:
  case OB_FIREBALL:
   processshot(n);
  break;

  case OB_DEADALLEBEAR:
  case OB_DEADALLEFISH:
  case OB_DEADALLEGATOR:
   if(all[n].l){
    all[n].l--;
   } else {
    delob(n,&smon);
   }
  break;
  case OB_DEADDRAGON:
  if(all[n].l){
    all[n].l--;
   } else {
    delob(n,&sfmon);
   }
  break;

  case OB_NUMBER:
   if(all[n].l){
    all[n].x-=all[n].u;
    all[n].y-=all[n].v;
    all[n].l--;
   } else {
    delob(n,&swat);
   }
  break;

 }

}

// spawn a new monster (if free spot in objects array)
void makemon(int id,int x,int y,int a,int l) {
 int n;
 if(smon<POS_MONSTER+NUM_MONSTER) {
  n=smon;
  all[n].x=x;
  all[n].y=y;
  all[n].a=a;
  all[n].u=0;
  all[n].v=0;
  all[n].t=0;
  all[n].l=l;
  all[n].id=id;

  all[n].e=all[all[n].t].x-all[n].x;all[n].e*=all[n].e;
  all[n].f=all[all[n].t].y-all[n].y;all[n].f*=all[n].f;

  smon++;
 }
}

// spawn a dragon
void makefmon(int id,int x,int y,int a,int l) {
 int n;
 if(sfmon<POS_FLIGHT+NUM_FLIGHT) {
  n=sfmon;
  all[n].x=x;
  all[n].y=y;
  all[n].a=a;
  all[n].u=0;
  all[n].v=0;
  all[n].t=0;
  all[n].l=l;
  all[n].id=id;

  all[n].e=all[all[n].t].x-all[n].x;all[n].e*=all[n].e;
  all[n].f=all[all[n].t].y-all[n].y;all[n].f*=all[n].f;

  sfmon++;
 }
}

// check for spawning objects
void spawn(int p) {
 int n;
 int x,y;
 int wx,wy;
 int u,v,s;

 // tile position of player
 wx=512+((int)all[p].x>>5);
 wy=512+((int)all[p].y>>5);

 // check surrounding area for spawn points
 for(v=-8;v<=8;v++){
  for(u=-10;u<=10;u++){
   x=wx+u;
   y=wy+v;
   s=pos(x,y)&127;

   // found a monster spawn point ?
   if(s==TILE_SPAWNALLEGATOR||
      s==TILE_SPAWNALLEBEAR||
      s==TILE_SPAWNALLEFISH||
      s==TILE_SPAWNDRAGON) {

    // yes, now spawn the monster

    if(smon<POS_MONSTER+NUM_MONSTER) {
     n=smon;
     if(s==TILE_SPAWNALLEGATOR) {
      pos(x,y)=TILE_HEALTHYGRASS;
      makemon(OB_ALLEGATOR,(x-512)*32+16,(y-512)*32+16,(rand()%360)*pi/180.0,100);
     }
     if(s==TILE_SPAWNALLEBEAR) {
      pos(x,y)=TILE_ICE;
      makemon(OB_ALLEBEAR,(x-512)*32+16,(y-512)*32+16,(rand()%360)*pi/180.0,200);
     }
     if(s==TILE_SPAWNALLEFISH) {
      pos(x,y)=TILE_WATER;
      makemon(OB_ALLEFISH,(x-512)*32+16,(y-512)*32+16,(rand()%360)*pi/180.0,300);
     }
     if(s==TILE_SPAWNDRAGON) {
      pos(x,y)=TILE_GRASS;
      makefmon(OB_DRAGONBODY,(x-512)*32+16,(y-512)*32+16,0,1500);
      makefmon(OB_DRAGONHEAD,(x-512)*32+16,(y-512)*32+16,0,2000);
      makefmon(OB_DRAGONTAIL,(x-512)*32+16,(y-512)*32+16,0,1000);
      makefmon(OB_DRAGONWINGL,(x-512)*32+16,(y-512)*32+16,0,1000);
      makefmon(OB_DRAGONWINGR,(x-512)*32+16,(y-512)*32+16,0,1000);
     }
    }
   }
  }
 }
}
