// MAP
#include <math.h>
#include <stdio.h>
#include <string.h>

#include "log.h"

#include "map.h"
#include "ob.h"
#include "main.h"
#include "tile.h"

#ifdef LIBNET

#include "server.h"
#include "client.h"

#endif

BITMAP *map=0; // the map
BITMAP *satmap=0;

int mapnum;

void makesatmap(void) {
 int x,y,c;
 satmap=create_hw_bitmap(256,256);

 {for(y=0;y<256;y++) {
   for(x=0;x<256;x++) {
    switch(pos(x*4,y*4)) {
     case TILE_GRASS: c=makecol(0,250,0); break;
     case TILE_TREE: c=makecol(0,150,0); break;
     case TILE_WATER: c=makecol(0,0,250); break;
     case TILE_DEEPWATER: c=makecol(0,0,150); break;
     case TILE_WALL: c=makecol(150,150,150); break;
     case TILE_ICE: c=makecol(200,200,255); break;
     default: c=makecol(0,0,0);
    }
    putpixel(satmap,x,y,c);
   }
  }
 }
}

int createmap(int num) {      // create the world map
 int n,c; // loop counter
 int x,y; // map location
 int z;   // isle radius
 int b;   // helper variable
 int r;   // random number
 int u,v; // monster position on isle
 int g[]={TILE_GRASS,TILE_WATER,TILE_ICE}; // ground type
 int s[]={TILE_SPAWNALLEGATOR,TILE_SPAWNALLEFISH,TILE_SPAWNALLEBEAR}; // spawn
 float a; // angle
 int p;
 int playernum=1;

 #ifdef LIBNET
 if(serverisrunning||clientisrunning) playernum=2;
 #endif

 logmsg("Loading World Map.\n");

 if(map) delmap();

 map=create_bitmap_ex(8,LW+1,LH+1);

 mapnum=num;
 srand(mapnum);

 // clear all objects
 memset(all,0,sizeof(all));
 splayer=0;
 swat=POS_WATER;
 sfmon=POS_FLIGHT;
 smon=POS_MONSTER;
 scod=POS_CODE;
 sbot=POS_BOAT;

 for(p=0;p<NUM_PLAYER;p++) {
  ch[p]=0;
  ctrl[p]=0;
  wshot[p]=0;
  haveboat[p]=0;
  tlife[p]=0;
  tshot[p]=0;
 }

 // clear map
 clear_to_color(map,0);

 // fill map with water
 rectfill(map,10,10,1013,1013,TILE_DEEPWATER);

 // randomly place 1000 isles
 for(n=0;n<1000;n++){
  // random number
  r=rand()+(1+RAND_MAX)*rand();

  // extract a map position for a new isle
  x=r%800;r/=800;
  y=r%800;r/=800;
  // radius for the isle
  z=3+(r%20);r/=20;
  b=r%40;     // randomness for ice
  r=rand()%2; // land or water
  if(y<b*10) r=2; // the farther north, the greater the possibility for ice

  // draw the isle
  circlefill(map,112+x,112+y,z,g[r]);

  // place monsters (the bigger the isle, the more monsters)
  for(c=0;c<z;c++){
   b=rand();
   u=(b%z);
   v=(b/z)%z;
   pos(112+x+u-z/2,112+y+v-z/2)=s[r];
  }

  if(r==0) { // grass isle
   // place random trees
   for(c=0;c<(z*z*(1+(b%4)))/4;c++){
    b=rand();
    u=(b%(z*2+1))-z;
    v=((b/(z*2+1))%(z*2+1))-z;
    if(pos(112+x+u,112+y+v)==TILE_GRASS)
     pos(112+x+u,112+y+v)=TILE_TREE;
   }
  }

 }

 circlefill(map,512,512,25,TILE_GRASS);  // starting isle
 circlefill(map,512,533,5,TILE_WATER);   // lake south of the library

 for(n=0;n<4;n++){                       // the library
  rectfill(map,512-6+n,512-8+n,512+6-n,512+8-n,n==3?6:3);
  putpixel(map,512,512-9+n,1);
 }
 putpixel(map,510,502,TILE_TREE);
 putpixel(map,514,502,TILE_TREE);


 // objects

 // the allefants
 for(p=0;p<playernum;p++) {
  if(p==0) all[p].id=OB_ALLEFANT;
  else all[p].id=OB_ALLEFANT2;

  all[p].x=16;
  all[p].y=16;
  all[p].l=100;  // start with complete health

  wshot[p]=100;  // start with full ammo
  tshot[p]=0;    // no shots fired yet
  haveboat[p]=0; // start without a boat
  tlife[p]=0;    // start self-healing
  ch[p]=0;       // no codespages yet
  ctrl[p]=0;     // no keyboard input yet
 }
 splayer=p;

 // scatter codepages
 for(n=POS_CODE;n<POS_CODE+NUM_CODE;n++) {
  do { // wait until we find a grass location
   r=rand()+(1+RAND_MAX)*rand();
   x=(r%800)+((LW+1-800)/2);r/=800;
   y=(r%800)+((LH+1-800)/2);
  } while(tt[(int)pos(x,y)]!=TILE_GRASS);
  all[n].x=(x-512)*32;
  all[n].y=(y-512)*32;
  all[n].id=OB_CODE;
 }
 scod=n; // index for last code page

 // boats
 for(n=POS_BOAT;n<POS_BOAT+NUM_BOAT;n++){
  all[n].id=OB_BOAT;
  all[n].l=100;
  a=(rand()%3600)*pi/1800.0; // random direction
  // go into this direction until we find water
  for(x=0,y=0;tt[(int)opos(x,y)]!=TILE_WATER;x+=sin(a)*32.0,y-=cos(a)*32.0);
  all[n].x=x;
  all[n].y=y;
  all[n].a=a;
 }
 sbot=n; // index of last boat

 makesatmap();
 return 0;
}

void delmap() {
 if(map) destroy_bitmap(map);
 if(satmap) destroy_bitmap(satmap);
 map=0;
 satmap=0;
}

void savemap(char *name) {
 FILE *file=fopen(name,"wb");
 int x,y,w=LW,h=LH;
 int n=511;
 int pn=NUM_PLAYER-1,p;
 char c;
 fwrite("map",3,1,file);
 fwrite("xmax",4,1,file);
 fwrite(&w,sizeof(int),1,file);
 fwrite("ymax",4,1,file);
 fwrite(&h,sizeof(int),1,file);
 fwrite("data",4,1,file);
 for(y=0;y<=h;y++) {
  for(x=0;x<w;x++) {
   c=pos(x,y);
   fwrite(&c,1,1,file);
  }
 }
 fwrite("ob",2,1,file);
 fwrite("max",3,1,file);
 fwrite(&n,sizeof(int),1,file);
 fwrite("data",4,1,file);
 fwrite(all,sizeof(all),1,file);
 fwrite("players",7,1,file);
 fwrite("max",3,1,file);
 fwrite(&pn,sizeof(int),1,file);
 fwrite("data",4,1,file);
 for(p=0;p<=pn;p++) {
  fwrite(&ch[p],4,1,file);
  fwrite(&ctrl[p],4,1,file);
  fwrite(&wshot[p],4,1,file);
  fwrite(&haveboat[p],4,1,file);
  fwrite(&tlife[p],4,1,file);
  fwrite(&tshot[p],4,1,file);
 }
 fwrite("shot",4,1,file);
 fwrite("max",3,1,file);
 fwrite(&swat,sizeof(int),1,file);
 fwrite("flight",6,1,file);
 fwrite("max",3,1,file);
 fwrite(&sfmon,sizeof(int),1,file);
 fwrite("monster",7,1,file);
 fwrite("max",3,1,file);
 fwrite(&smon,sizeof(int),1,file);
 fwrite("code",4,1,file);
 fwrite("max",3,1,file);
 fwrite(&scod,sizeof(int),1,file);
 fwrite("boat",4,1,file);
 fwrite("max",3,1,file);
 fwrite(&sbot,sizeof(int),1,file);

 fclose(file);
}

void loadmap(char *name) {
 FILE *file=fopen(name,"rb");
 int x,y,w=LW,h=LH;
 int n=511;
 int pn=NUM_PLAYER-1,p;
 char c;

 char str[256];

 logmsg("Loading Map from Disk.\n");

 if(map) delmap();
 map=create_bitmap_ex(8,LW+1,LH+1);

 fread(str,3,1,file);
 if(strncmp(str,"map",3)) goto error;
 fread(str,4,1,file);
 if(strncmp(str,"xmax",4)) goto error;
 fread(&w,sizeof(int),1,file);
 fread(str,4,1,file);
 if(strncmp(str,"ymax",4)) goto error;
 fread(&h,sizeof(int),1,file);
 fread(str,4,1,file);
 if(strncmp(str,"data",4)) goto error;
 for(y=0;y<=h;y++) {
  for(x=0;x<w;x++) {
   fread(&c,1,1,file);
   pos(x,y)=c;
  }
 }
 fread(str,2,1,file);
 if(strncmp(str,"ob",2)) goto error;
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&n,sizeof(int),1,file);
 fread(str,4,1,file);
 if(strncmp(str,"data",4)) goto error;
 fread(all,sizeof(all),1,file);

 logmsg(" loading player data.\n");

 fread(str,7,1,file);
 if(strncmp(str,"players",7)) goto error;
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;

 fread(&pn,sizeof(int),1,file);
 fread(str,4,1,file);
 if(strncmp(str,"data",4)) goto error;
 for(p=0;p<=pn;p++) {
  fread(&ch[p],4,1,file);
  fread(&ctrl[p],4,1,file);
  fread(&wshot[p],4,1,file);
  fread(&haveboat[p],4,1,file);
  fread(&tlife[p],4,1,file);
  fread(&tshot[p],4,1,file);

  tshot[p]=0;
  tlife[p]=0;

 }
 fread(str,4,1,file);
 if(strncmp(str,"shot",4)) goto error;
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&swat,sizeof(int),1,file);
 logmsg(" shots: %d\n",swat);

 fread(str,6,1,file);
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&sfmon,sizeof(int),1,file);
 logmsg(" flying monsters: %d\n",sfmon);

 fread(str,7,1,file);
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&smon,sizeof(int),1,file);
 logmsg(" monsters: %d\n",smon);

 fread(str,4,1,file);
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&scod,sizeof(int),1,file);
 logmsg(" codes: %d\n",scod);

 fread(str,4,1,file);
 fread(str,3,1,file);
 if(strncmp(str,"max",3)) goto error;
 fread(&sbot,sizeof(int),1,file);
 logmsg(" boats: %d\n",sbot);
 makesatmap();
 splayer=0;

 fclose(file);
 return;
error:
 destroy_bitmap(map);map=0;
 logmsg("!failed\n");
}
