// TILE

#include <math.h>
#include <allegro.h>

#include "log.h"

#include "main.h"
#include "tile.h"
#include "ob.h"

BITMAP *O[NUM_PICS][32];
BITMAP *tile[NUM_TILES];

inline int col(int x) {
 return x<0?0:x>255?255:x;
}

// blur a (tiled) bitmap from b to dest
void blur(BITMAP *b,BITMAP *dest) {
 int tab[3][3]={
  {  3, 14,  3},
  { 14, 32, 14},
  {  3, 14,  3}
 };
 int x,y,u,v;
 int red,grn,blu;
 for(y=0;y<b->h;y++) {
  for(x=0;x<b->w;x++) {
   red=grn=blu=0;
   for(v=-1;v<=1;v++) {
    for(u=-1;u<=1;u++) {
     int xpos,ypos,c,w;
     xpos=(x+u);
     ypos=(y+v);
     w=tab[1+v][1+u];
     if(xpos<0) xpos+=b->w;
     if(xpos>=b->w) xpos-=b->w;
     if(ypos<0) ypos+=b->h;
     if(ypos>=b->h) ypos-=b->h;
     c=getpixel(b,xpos,ypos);
     red+=getr(c)*w;
     grn+=getg(c)*w;
     blu+=getb(c)*w;
    }
   }
   putpixel(dest,x,y,makecol(red/100,grn/100,blu/100));
  }
 }
}

// draw gradient filled circle
void ball(BITMAP *b,int x,int y,int r,int red,int grn,int blu) {
 int c;
 for(c=0;c<r;c++) {
  int v=c+r;
  circlefill(b,x,y,r-c,makecol(red*v/r/2,grn*v/r/2,blu*v/r/2));
 }
}

void maketile(int n,int r,int g,int b,int rv,int gv,int bv){  // make ugly looking tile
 int x,y;
 BITMAP *t=create_bitmap(32,32);
 BITMAP *pic;

 pic=create_hw_bitmap(32,32);

 for(y=0;y<32;y++){
  for(x=0;x<32;x++){
   int rn=rand();
   int rd,gd,bd;
   rd=rn%rv;
   gd=(rn/rv)%gv;
   bd=(rn/rv/gv)%bv;
   rd=col(r+rd-rv/2);
   gd=col(g+gd-gv/2);
   bd=col(b+bd-bv/2);
   putpixel(t,x,y,makecol(rd,gd,bd));
  }
 }
 blur(t,pic);
 tile[n]=pic;
 destroy_bitmap(t); 
}

void rotate(BITMAP * a,BITMAP **all){        // rotate 32 times
 int i;
 for(i=0;i<32;i++){
  BITMAP *b;

  b=create_hw_bitmap(64,64);

  clear_to_color(b,makecol(255,0,255));
  pivot_sprite(b,a,31,31,31,31,65536*i*8);
  all[i]=b;
 }
}

void loadballs(BITMAP **p,char*pic){
 int x=0,y=0,d=0,r=0,g=0,b=0,n=0,c=0;
 BITMAP *a=create_bitmap(63,63);
 clear_to_color(a,makecol(255,0,255));
 for(;(c=*pic);pic++){
  if(c>='0'&&c<='9')n=n*10+(c-'0');else{
   switch(c){
    case'x':x=n;break;
    case'y':y=n;break;
    case'd':d=n;break;
    case'r':r=n;break;
    case'g':g=n;break;
    case'b':b=n;break;
    case'.':ball(a,x,y,d,r,g,b);
   }
   n=0;
  }
 }
 rotate(a,p);
 destroy_bitmap(a);
}
BITMAP *makecode(void) {      // create picture of codepage
 int y;

 BITMAP * a;

 a=create_hw_bitmap(32,32);

 clear_to_color(a,makecol(255,0,255));
 for(y=0;y<4;y++){
  hline(a,5-y,25-y,25-y,makecol(150,100,50));
 }
 rectfill(a,5,5,25,25,makecol(200,150,100));
 for(y=0;y<4;y++){
  hline(a,5+y,5+y,25+y,makecol(250,200,150));
 }
 return a;
}
BITMAP *makeboat(void) {     // crate picture of boat
 int n;
 BITMAP * a=create_bitmap(63,63);
 clear_to_color(a,makecol(255,0,255));
 ball(a,31,31,27,200,100,0);
 for(n=0;n<20;n++){
  ball(a,31+(int)(cos(n*pi/10)*27.0),31+(int)(sin(n*pi/10)*27),4,100,50,0);
 }
 ball(a,31,14,14,200,100,0);
 return a;
}
BITMAP *makeshot(void){      // create picture of water drop
 BITMAP *a;

 a=create_hw_bitmap(8,8);

 clear_to_color(a,makecol(255,0,255));
 ball(a,3,3,3,0,0,255);
 return a;
}

void loadpics(void){
 BITMAP *a;

 memset(O,0,sizeof(O));

 loadballs(O[OB_ALLEFANT],"31x28y8d255r255g0b.31x45y13d.31x60y3d.18x30y8d.43x30y8d.31x17y4d.31x10y4d.31x4y4d.25x21y4d0r0g255b.37x.37x19y2d0b.25x.");
 loadballs(O[OB_ALLEGATOR],"31x17y8d0r100g200b.10y6d150g.4y4d200g.23y10d150b.38y100b.44y9d150b.50y7d200b.57y5d150g.60y3d100g.25x21y4d255r0g0b.37x.19y2d0r.25x.");
 loadballs(O[OB_DEADALLEGATOR],"31x31y18d255r0g0b.17y8d100r100g200b.10y6d150g.4y4d200g.23y10d150b.38y100b.44y9d150b.50y7d200b.57y5d150g.60y3d100g.");
 a=makeboat();
 rotate(a,O[OB_BOAT]);
 destroy_bitmap(a);
 O[OB_CODE][0]=makecode();
 O[OB_SHOT][0]=makeshot();
 loadballs(O[OB_ALLEBEAR],"31x45y17d200r200g255b.15y10d.28y16d.59y4d.19x30y5d.44x.25x21y4d255r0g0b.37x.19y2d0r.25x.");
 loadballs(O[OB_DEADALLEBEAR],"31x31y20d255r0g0b.45y15d150r150g200b.15y9d.28y14d.59y4d.20x30y5d.43x.");
 loadballs(O[OB_ALLEFISH],"31x31y30d0r0g200b.25x21y4d255r0g0b.37x.19y2d0r.25x.");
 loadballs(O[OB_DEADALLEFISH],"31x31y23d0r0g200b.");

 loadballs(O[OB_DRAGONHEAD],"31x20y19d200r0g0b.25x21y4d255r0g0b.37x.19y2d0r.25x.\
                             31x46y7d255r.10x31y10d.53x.");
 loadballs(O[OB_DRAGONBODY],"31x33y21d200r0g0b.5y5d.15y.57x31y.6x.");
 loadballs(O[OB_DRAGONTAIL],"31x10y5d200r0g0b.20y.30y.40y.50y.");
 loadballs(O[OB_DRAGONWINGL],"31y200r0g0b\
                              3x2d.8x3d.15x4d.24x5d.33x4d.40x3d.48x4d.\
                              23y\
                              7x2d.11x3d.18x4d.27x5d.36x4d.43x3d.51x4d.\
                              39y\
                              7x2d.11x3d.18x4d.27x5d.36x4d.43x3d.51x4d.
                              ");
 loadballs(O[OB_DRAGONWINGR],"31y200r0g0b\
                              3x2d.8x3d.15x4d.24x5d.33x4d.40x3d.48x4d.\
                              23y\
                              7x2d.11x3d.18x4d.27x5d.36x4d.43x3d.51x4d.\
                              39y\
                              7x2d.11x3d.18x4d.27x5d.36x4d.43x3d.51x4d.
                              ");
 loadballs(O[OB_DEADDRAGON],"31x31y10d200r0g0b.");
 loadballs(O[OB_FIREBALL],"31x34y10d200r255g40b.31y7d255r50g0b.");
 loadballs(O[OB_ALLEFANT2],"31x28y8d255r200g0b.31x45y13d.31x60y3d.18x30y8d.43x30y8d.31x17y4d.31x10y4d.31x4y4d.25x21y4d0r0g255b.37x.37x19y2d0b.25x.");

}

void loadtiles(void) {
 logmsg("Loading Textures.\n");
 loadpics();

 memset(tile,0,sizeof(tile));

 maketile(TILE_NO,0,0,0,1,1,1);
 maketile(TILE_GRASS,0,150,0,1,100,1);
 maketile(TILE_WATER,0,0,200,10,10,50);
 maketile(TILE_WALL,100,100,100,10,10,10);
 maketile(TILE_SPAWNALLEGATOR,200,0,0,10,10,10);
 maketile(TILE_ICE,128,250,250,128,10,10);
 maketile(TILE_LIBRARY,100,100,50,50,70,1);
 maketile(TILE_LIBRARYCODE,100,100,50,50,70,1);
 draw_sprite(tile[TILE_LIBRARYCODE],O[OB_CODE][0],0,0);
 maketile(TILE_DEEPWATER,0,0,150,10,10,50);
 maketile(TILE_HEALTHYGRASS,200,150,0,1,100,1);

 maketile(TILE_TREE,0,150,0,1,100,1);
 ball(tile[TILE_TREE],15,15,15,0,150,0);

 maketile(TILE_SPAWNALLEBEAR,200,200,0,10,10,10);
 maketile(TILE_SPAWNALLEFISH,200,0,200,10,10,10);
 maketile(TILE_SPAWNDRAGON,200,0,0,10,10,10);
}

void deltiles(void) {
 int n,m;
 logmsg("Unloading Textures.\n");
 for(n=0;n<NUM_PICS;n++) {
  for(m=0;m<32;m++) {
   if(O[n][m]) destroy_bitmap(O[n][m]);
  }
 }
 for(n=0;n<NUM_TILES;n++) {
  if(tile[n]) destroy_bitmap(tile[n]);
 }
}
