#include <math.h>
#include <allegro.h>

#include "main.h"
#include "log.h"

SAMPLE *spt,*hit,*yee,*glp;

void loadsound(void){     // create the sounds
 int n;
 logmsg("Loading Sound Samples.\n");
 spt=create_sample(8,0,44100,1024);
 hit=create_sample(8,0,44100,1024);
 yee=create_sample(8,0,44100,1024);
 glp=create_sample(8,0,44100,128);
 for(n=0;n<1024;n++){
  float t=n/44100.0;
  float f=sin(n/512.0*pi);

  *((char*)spt->data+n)=128+127*f*
  sin(2000*t+sin(600*t*t)*5);

  *((char*)hit->data+n)=128+127*f*
  sin(cos(pi*2*1000*(1-f)*t));

  *((char*)yee->data+n)=128+127*f*
  cos(pi*2*(2000-n/2)*t);

  *((char*)glp->data+n/8)=128+127*f*
  sin(300*t+sin(600*t*t)*5);
 }
}
