// MENU
// This file contains the menu code. It's not programmed very clean, its
// purpose is just to provide a menu, even if it's a complicated menu.
// The menu's style somehow fits to the game IMO : )

#include <allegro.h>

#include "log.h"

#include "main.h"
#include "game.h"
#include "snd.h"
#include "map.h"
#include "tile.h"

#ifdef LIBNET

#include "net.h"
#include "server.h"
#include "client.h"

#endif

int mti=0;
int menu=0;

int redrawmenu=0;
int dirtyrect[4];

// We use some basic dirty rectangle system for drawing the menu
void invalidaterect(int x1,int y1,int x2,int y2) {
 redrawmenu=1;
 dirtyrect[0]=x1;
 dirtyrect[1]=y1;
 dirtyrect[2]=x2;
 dirtyrect[3]=y2;
}

typedef struct {
 int y,c;
 char *t;
} simplemenu;

simplemenu *themenu;
BITMAP *menumap;

simplemenu mainmenu[]={
 {1,TILE_SPAWNALLEBEAR,"A L L E F A N T !"},
 {10,TILE_DEEPWATER,"SizeHack 2000"},
 {20,TILE_LIBRARY,"Entry"},
 {30,TILE_LIBRARY,"by Elias Pschernig"},
 {40,TILE_HEALTHYGRASS,"Main Menu"},
 {50,TILE_SPAWNALLEGATOR,"Start Game"},
 #ifdef LIBNET
 {60,0,"Multiplayer"},
 #else
 {60,0,"[no libnet]"},
 #endif
 {70,0,"Options"},
 {80,0,"Game"},
 {90,0,"Help"},
 {100,TILE_SPAWNALLEGATOR,"Quit"},
 {110,TILE_WALL,version},{0,0,0}};

simplemenu optionsmenu[]={
 {1,TILE_SPAWNALLEBEAR,"A L L E F A N T !"},
 {10,TILE_DEEPWATER,"SizeHack 2000"},
 {20,TILE_LIBRARY,"Entry"},
 {30,TILE_LIBRARY,"by Elias Pschernig"},
 {40,TILE_HEALTHYGRASS,"Options Menu"},
 {50,TILE_WALL,"Resolution 640x480"},
 {60,0,"/colordepth/"},
 {70,0,"/videoaccel/"},
 {80,TILE_WALL,"Sound is on"},
 {90,0,"Controls"},
 {100,TILE_SPAWNALLEGATOR,"Back"},
 {110,TILE_WALL,version},{0,0,0}};

simplemenu controlsmenu[]={
 {1,TILE_SPAWNALLEBEAR,"A L L E F A N T !"},
 {10,TILE_DEEPWATER,"SizeHack 2000"},
 {20,TILE_LIBRARY,"Entry"},
 {30,TILE_LIBRARY,"by Elias Pschernig"},
 {40,TILE_HEALTHYGRASS,"Options Menu"},
 {50,0,"Run"},
 {60,0,"Turn Left"},
 {70,0,"Turn Right"},
 {80,0,"Spit"},
 {90,0,"Move Back"},
 {100,TILE_SPAWNALLEGATOR,"Back"},
 {110,TILE_WALL,version},{0,0,0}};

simplemenu multiplayermenu[]={
 {1,TILE_SPAWNALLEBEAR,"A L L E F A N T !"},
 {10,TILE_DEEPWATER,"SizeHack 2000"},
 {20,TILE_LIBRARY,"Entry"},
 {30,TILE_LIBRARY,"by Elias Pschernig"},
 {40,TILE_HEALTHYGRASS,"Multiplayer Menu"},
 {50,0,"Address (0=Server)"},
 {60,TILE_WATER,"0"},
 {70,0,"Name"},
 {80,TILE_WATER,"unknown"},
 {90,TILE_SPAWNALLEGATOR,"Start"},
 {100,TILE_SPAWNALLEGATOR,"Back"},
 {110,TILE_WALL,version},{0,0,0}};

simplemenu gamemenu[]={
 {1,TILE_SPAWNALLEBEAR,"A L L E F A N T !"},
 {10,TILE_DEEPWATER,"SizeHack 2000"},
 {20,TILE_LIBRARY,"Entry"},
 {30,TILE_LIBRARY,"by Elias Pschernig"},
 {40,TILE_HEALTHYGRASS,"Game Menu"},
 {50,TILE_SPAWNALLEGATOR,"Save"},
 {60,0,"Load"},
 {70,0,"Continue"},
 {80,0,"Story"},
 {90,0,"Map"},
 {100,TILE_SPAWNALLEGATOR,"Back"},
 {110,TILE_WALL,version},{0,0,0}};

int *readnextkey=0;

int tellstory=0;
int tellhelp=0;

char story[]="\



                       Allefant Story


  There was a big C-Library, and many programmers did like it.
  It was founded by the Master of Allegro, and many of the
  many programmers contributed to it. There was a mailing
  list, where the programmers could post their patches and
  discuss changes and programming topics and other things, and
  where even newbies was allowed to ask newbie questions. In
  all that time, the Great Master organized and watched
  everything, so nothing would go wrong, and the Library grew
  and got better.

  But then, one day, for only a moment, the Great Godly Master
  of the Library wasn't careful, and he left his Library
  unattended. Outside, a hord of bad evil Allegators was just
  waiting for this moment. They broke into the Library, ripped
  all the code they could get, and scattered it all over the
  world. From the once so great library, they did leave back
  nothing usable. There was much pain and mourning and crying.
  All hope was gone.

  No! There is hope. Little, but there is. In this game, you
  are the last hope to save the world, and put together the
  library again. You take over the part of Allefant, your
  objective is to find all the Allegro Code and bring it back
  to the Great Library. You start on the Isle of Allegro,
  inside the Library. Run around, and hopefully you will soon
  find the first Source Code. Grab it, and take it back to the
  library. But don't think it will be easy. The evil
  Allegators still are out there - and they won't give back
  the Code of Codes without fight!


                -Press Esc to return to menu-
";

char help[]="\
Allefant Help

<i1>        You can control the Allefant's movement by turning
        left and right, and running forward. Run around and<i8>      <t3>
        look for code pieces. If you find one, pick it up.
        But keep in mind that you can't carry the complete
        library with you, so you will often have to return to<t6>    <t7>
        the library and deposit the already found code there.

<i2>        If you are attacked by Allegators, your only defense  <i4> <i4> <i4>
        is to spill water onto them. If they bite you, you <t2>
        can look for some orange colored grass, its very     <t1>
        healthy grass. When spitting too much, the Allefant <t9>
        gets thirsty, so it will have to drink water.

<i6>        If you want to travel over water, use boats. Note that <t8>
        out in the see the water may get too salty for the
        Allefant to drink. And be carefull about attacks of <i11,20>
        evil Allefish.

<i9>        The farther north you travel, the more icy the land
        will get. No one except the Allebears can walk on ice
        without helpless sliding around. They will use this for
        very mean attacks on you. <t5>


        The numbers in the top left corner of the screen tell you
        how many code pages still are missing, and how many you
        are currently carrying.

        The red and blue bars at the bottom are your health and
        how thirsty you are.

        At the bottom of the screen you can see the Code Compass.
        All codepages have little transmitters, so this radar
        can find them. You are in the middle of the circle, and
        green circles represent the location of code pages.
        The red triangle always points to the Library.

-Press Esc to return to menu-
";

void drawmenu(void) {
 int n;

 text_mode(-1);
 rectfill(menumap,0,0,160-1,120-1,TILE_GRASS);
 for(n=0;themenu[n].t;n++) {
  textprintf_centre(menumap,font,80,themenu[n].y,themenu[n].c,themenu[n].t);
 }

 invalidaterect(0,0,SCREEN_W-1,SCREEN_H-1);
}

int menu_init() {
 logmsg("Running in Menu Mode.\n");
 menumap=create_bitmap_ex(8,160,120);
 loadtiles(); // the menu display uses the game pictures, so load them
 themenu=mainmenu;
 drawmenu();
 mod=MODE_MENU;

 // empty keybuffer (so we don't catch ESC key and exit from menu at once)
 while(keypressed()) readkey();

 return 0;
}

int menu_end() {
 deltiles();
 destroy_bitmap(menumap);

 // if color depth changes, we restart Allegro
 // (in the version this was tested, it wouldn't work
 //  with just calling set_gfx_mode again)

 if(bitmap_color_depth(screen)!=colordepth) {
  if(usevideobitmaps) {
   destroy_bitmap(page1);page1=0;
   destroy_bitmap(page2);page2=0;
  } else {
   destroy_bitmap(page);
  }

  allegro_exit();
  allegro_init();
  if(launchAllegro()) {
   allegro_message("\
Failed to start Allegro.
Maybe the selected color depth (%d bit) isn't supported.
You might find information in the log.txt that has been created.
Some options can be set in the allefant.ini file.
",colordepth);
   exit(-1);
  }

 }
 return 0;
}

char *colordepthmenutext[]={
 "Palette 8bit",
 "HighColor 16bit",
 "Truecolor 24bit",
 "Truecolor 32bit"
};

char *videoaccelmenutext[]={
 "Video Accel: OFF",
 "Video Accel: ON"
};

// Character position for string input
int inputpos=0;

int menu_process() {
 int k=0,c=0;
 if(keypressed()) {
  k=readkey();
  c=k;
  c&=255; // ascii code
  k>>=8;
  k&=255; // scan code

  if(readnextkey) { // we are to read in one of the game keys
   *readnextkey=k;
   readnextkey=0;
   k=0;
   play_sample(hit,255,127,300,0);
  }
 }

 if(readnextkey) { // catch some special keys for use as game keys
  int specialkeys[]={
   KEY_LSHIFT,KEY_RSHIFT,KEY_LCONTROL,KEY_RCONTROL,KEY_ALT,KEY_ALTGR,0};
  int n;
  for(n=0;specialkeys[n];n++) {
   if(key[specialkeys[n]]) {
    *readnextkey=specialkeys[n];
    readnextkey=0;
    play_sample(hit,255,127,300,0);
   }
  }
 }

 if(tellstory||tellhelp) {
  if(k==KEY_ESC) {
   tellstory=0;
   tellhelp=0;
   goto backtomain;
  }
  return 0;
 }

 if(ticks-mti>=5) { // wait at least 5 frames before moving menu selection

  if(k==KEY_UP) if(menu>0) {
   invalidaterect(0,195+menu*40,SCREEN_W-1,200+menu*40+39);
   menu--;
   mti=ticks;
   play_sample(glp,255,127,1000,0);
   inputpos=0;
  }

  if(k==KEY_DOWN) if(menu<5) {
   invalidaterect(0,195+menu*40,SCREEN_W-1,200+menu*40+39);
   menu++;
   redrawmenu=1;
   mti=ticks;
   play_sample(glp,255,127,1000,0);
   inputpos=0;
  }

 }


 if(themenu==mainmenu) {
  if(k==KEY_ESC) return 1;
  if(k==KEY_ENTER){
   if(menu==0){
    menu_end();
    #ifdef LIBNET
    // single player needs no server or client
    serverisrunning=0;
    clientisrunning=0;
    #endif
    delmap();
    game_init();
   }

   #ifdef LIBNET
   if(menu==1) { //multiplayer
    multiplayermenu[6].t=address;
    multiplayermenu[8].t=nick;
    themenu=multiplayermenu;
    drawmenu();
   }
   #endif

   if(menu==2) { //options
    optionsmenu[6].t=colordepthmenutext[colordepth/8-1];
    optionsmenu[7].t=videoaccelmenutext[usevideobitmaps];
    themenu=optionsmenu;
    drawmenu();
   }

   if(menu==3) { //game
    themenu=gamemenu;
    drawmenu();
   }

   if(menu==4) { //help
    tellhelp=1;
   }

   if(menu==5){
    return 1;
   }
  }
 }

 else

 if(themenu==gamemenu) {
  if(k==KEY_ESC) goto backtomain;

  if(k==KEY_ENTER){

   if(menu==0) { //save
    savemap("allefant.sav");
   }
   if(menu==1) { //load
    menu_end();
    #ifdef LIBNET
    serverisrunning=0;
    clientisrunning=0;
    #endif
    loadmap("allefant.sav");
    game_init();
   }
   if(menu==2) { //continue
    menu_end();
    #ifdef LIBNET
    serverisrunning=0;
    clientisrunning=0;
    #endif
    game_init();
   }
   if(menu==3) { //story
    tellstory=1;
   }
   if(menu==4) { //map
   }

   if(menu==5) {
    goto backtomain;
   }
  }
 }

 else

 #ifdef LIBNET
 if(themenu==multiplayermenu) {
  if(k==KEY_ESC) goto backtomain;

  if(menu==1||menu==3) {
   char *input;
   if(menu==1) input=address; else input=nick;

   if(k==KEY_BACKSPACE) {
    inputpos--;
    input[inputpos]=0;
    drawmenu();
    invalidaterect(0,195+menu*40,SCREEN_W-1,200+menu*40+39);
   }
   if(c>=32) {
    input[inputpos]=c;
    inputpos++;
    input[inputpos]=0;
    drawmenu();
    invalidaterect(0,195+menu*40,SCREEN_W-1,200+menu*40+39);
   }
  }

  if(k==KEY_ENTER){

   if(menu==4) {
    net_init();
    net_loadconfig(0);

    {NET_DRIVERLIST drivers;
     NET_DRIVERNAME *name;
     drivers=net_detectdrivers(net_classes[NET_CLASS_INET].drivers);
     name=net_getdrivernames(drivers);
     usedriver(name->num);
     free(name);
     net_driverlist_destroy(drivers);
    }

    if(!strcmp(address,"0")) {
     logmsg("Running as server.\n");

     initdriver();
     initserver();

     clientisrunning=0;
     game_init();
    } else {
     logmsg("Running as client.\n");

     initdriver();
     initclient(address);

     serverisrunning=0;
     game_init();
    }
   }

   if(menu==5) {
    goto backtomain;
   }
  }
 }

 else
 #endif

 if(themenu==controlsmenu) {
  if(k==KEY_ESC) goto backtomain;

  if(k==KEY_ENTER){

   if(menu==0) readnextkey=&key_run;
   if(menu==1) readnextkey=&key_left;
   if(menu==2) readnextkey=&key_right;
   if(menu==3) readnextkey=&key_fire;
   if(menu==4) readnextkey=&key_back;

   if(menu==5) {
    goto backtomain;
   }
  }
 }

 else

 if(themenu==optionsmenu) {
  if(k==KEY_ESC) goto backtomain;

  if(k==KEY_ENTER){

   if(menu==2){

    usevideobitmaps=!usevideobitmaps;
     optionsmenu[7].t=videoaccelmenutext[usevideobitmaps];

    // change display mode at once
    if(usevideobitmaps) {
     destroy_bitmap(page);
     page1=create_video_bitmap(SCREEN_W,SCREEN_H);
     page2=create_video_bitmap(SCREEN_W,SCREEN_H);
     page=page2;
    } else {
     destroy_bitmap(page1);page1=0;
     destroy_bitmap(page2);page2=0;
     page=create_bitmap(SCREEN_W,SCREEN_H);
    }

    drawmenu();

   }

   if(menu==1) {

    // color depth will only change when game is started or program
    // is restarted

    if(colordepth==8) {
     colordepth=16;
    } else if(colordepth==16) {
     colordepth=24;
    } else if(colordepth==24) {
     colordepth=32;
    } else if(colordepth==32) {
     colordepth=8;
    }

    optionsmenu[6].t=colordepthmenutext[colordepth/8-1];

    drawmenu();
    invalidaterect(0,195+menu*40,SCREEN_W-1,200+menu*40+39);

   }

   if(menu==4) {
    themenu=controlsmenu;
    drawmenu();
   }

   if(menu==5) {
backtomain:

    themenu=mainmenu;
    drawmenu();
   }
  }
 }
 return 0;
}

int menu_grafix(BITMAP *page) {
 int x,y;

 // This formats and outputs the help and story texts...
 if(tellstory||tellhelp) {
  char *text;
  char letter[2]=" ";
  int p;

  if(tellstory) text=story; else text=help;

  text_mode(-1);
  clear_to_color(page,makecol(200,150,150));
  x=0;
  y=0;
  for(p=0;p<(int)strlen(text);p++) {
   letter[0]=text[p];
   if(letter[0]==10) {
    x=0;
    y+=text_height(font)+4;
   } else if(letter[0]=='<') {

// at least one of those scary defines has to be in any good c program : )
// (even if there's no reason to not make it a function)

#define GETNUM(_p,_n) {\
 _n=(key[_p]-'0'); \
 _p++; \
 while(key[_p]>='0'&&key[_p]<='9') { \
  _n=_n*10+(key[_p]-'0'); \
  _p++; \
 } \
}

    char key[256];
    int k;
    p++;
    for(k=0;k<256;k++,p++) {
     if(text[p]=='>') break;
     key[k]=text[p];
    }
    key[k]=0;

    if(key[0]=='i') {
     int img,i2=0;
     int np=1;
     GETNUM(np,img);

     if(key[np]==',') {
      np++;
      GETNUM(np,i2);
     }
     draw_sprite(page,O[img][i2],x,y);
    }

    if(key[0]=='t') {
     int img;
     int np=1;
     GETNUM(np,img);
     draw_sprite(page,tile[img],x,y);
    }

   } else if(letter[0]>=' ') {
    textprintf(page,font,x,y,makecol(0,0,0),letter);
    x+=text_length(font,letter)+1;
   }
  }


 }
 else // draw the menu
 if(redrawmenu) {
  redrawmenu=0;
  for(y=dirtyrect[1]/4;y<(dirtyrect[3]+3)/4;y++) {
   for(x=dirtyrect[0]/4;x<(dirtyrect[2]+3)/4;x++) {
    int t=*((char *)menumap->line[y]+x);
    if(tile[t]) {
     if(page1) {
      stretch_blit(tile[t],page1,0,0,32,32,x*4,y*4,4,4);
      stretch_blit(tile[t],page2,0,0,32,32,x*4,y*4,4,4);
     } else {
      stretch_blit(tile[t],page,0,0,32,32,x*4,y*4,4,4);
     }
    }
   }
  }

  // this is the selection bar (=bar over current selected menu item)
  {int n;
   if(page1&&page2) {

    for(n=0;n<5;n++) {
     xor_mode(-1);
     rect(page1,0+n,195+menu*40+n,SCREEN_W-1-n,200+menu*40+39-n,
      n==0||n==4?makecol(255,0,0):makecol(0,255,0));
     rect(page2,0+n,195+menu*40+n,SCREEN_W-1-n,200+menu*40+39-n,
      n==0||n==4?makecol(255,0,0):makecol(0,255,0));
     solid_mode();
    }

   } else {
    for(n=0;n<5;n++) {
     rect(page,0+n,195+menu*40+n,SCREEN_W-1-n,200+menu*40+39-n,
      n==0||n==4?makecol(0,0,0):makecol(100,100,100));
    }
   }
  }
 }
 return 0;
}
