char version[]="Version 2.05";

#define FPS 50

// MAIN

#include <allegro.h>
#include <math.h>
#include <time.h>
#include <stdio.h>

#include "log.h"

#include "map.h"
#include "ob.h"
#include "snd.h"
#include "main.h"
#include "game.h"
#include "tile.h"
#include "menu.h"

#include "net.h"
#include "server.h"
#include "client.h"

int frames=0;
// fps counter
int gframes=0,frametime=0;
int fps=0;
// clock ticks counter
volatile int ticks;
void ticker() {ticks++;}

// setup variables
int usevideobitmaps=0;
int colordepth=16;
char address[256]="0";
char nick[256]="unknown";

// program mode (menu or game)
int mod=0;

// keyboard controls
int key_run=KEY_UP;
int key_left=KEY_LEFT;
int key_right=KEY_RIGHT;
int key_fire=KEY_SPACE;
int key_back=KEY_DOWN;

// the active pointer to video memory
BITMAP *page=0;
// if page flipping is used - the two video pages
BITMAP *page1=0,*page2=0;

// create hardware bitmap if available, else use software bitmap
BITMAP *create_hw_bitmap(int w,int h) {
 BITMAP *b=0;
 if(usevideobitmaps) b=create_video_bitmap(w,h);
 if(b==0) b=create_bitmap(w,h);
 return b;
}

// read user settings
void readsetup() {
 FILE *file;
 file=fopen("allefant.ini","r");
 if(!file) return;
 fscanf(file,"colordepth %d\n",&colordepth);
 fscanf(file,"videobitmaps %d\n",&usevideobitmaps);
 fscanf(file,"address %s\n",address);
 fscanf(file,"nickname %s\n",nick);
 fscanf(file,"keyleft %d\n",&key_left);
 fscanf(file,"keyright %d\n",&key_right);
 fscanf(file,"keyrun %d\n",&key_run);
 fscanf(file,"keyfire %d\n",&key_fire);
 fscanf(file,"keyback %d\n",&key_back);
 fclose(file);
}

// write user settings
void writesetup() {
 FILE *file;
 file=fopen("allefant.ini","w");
 fprintf(file,"colordepth %d\n",colordepth);
 fprintf(file,"videobitmaps %d\n",usevideobitmaps);
 fprintf(file,"address %s\n",address);
 fprintf(file,"nickname %s\n",nick);
 fprintf(file,"keyleft %d\n",key_left);
 fprintf(file,"keyright %d\n",key_right);
 fprintf(file,"keyrun %d\n",key_run);
 fprintf(file,"keyfire %d\n",key_fire);
 fprintf(file,"keyback %d\n",key_back);
 fclose(file);
}

// initialize everything
int launchAllegro() {
 int r;

  logmsg("Setting ColorDepth to %d.\n",colordepth);
  set_color_depth(colordepth);
  logmsg("Setting Video Resolution to 640 x 480.\n",
  r=set_gfx_mode(GFX_AUTODETECT,640,480,0,0));
  if(r) {
   logmsg("!failed\n");
   return 1;
  }
  logmsg("Setting up Timer.\n");
  install_timer();
  logmsg("Hooking Tickers.\n");
  install_int_ex(ticker,BPS_TO_TIMER(FPS));
  //install_int(ticker,1000/FPS);
  logmsg("Setting up Keyboard Communications.\n");
  install_keyboard();
  logmsg("Initializing Allegro Sound Subsystem.\n");
  install_sound(-1,-1,0);

  // if palette mode is used, we have to set up a palette
  // (my palettes always look ugly, but i don't use paletted modes
  //  anymore for quite some time anyway)
  if(colordepth==8) {
   int n,c;
   PALETTE p;

   c=0;
   for(n=0;n<32;n++) {p[c+n].r=0;p[c+n].g=0;p[c+n].b=0;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=n*2;p[c+n].g=0;p[c+n].b=0;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=n*2;p[c+n].g=n*2;p[c+n].b=0;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=0;p[c+n].g=n*2;p[c+n].b=0;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=0;p[c+n].g=n*2;p[c+n].b=n*2;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=0;p[c+n].g=0;p[c+n].b=n*2;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=n*4;p[c+n].g=0;p[c+n].b=n*4;}
   c+=32;
   for(n=0;n<32;n++) {p[c+n].r=n*4;p[c+n].g=n*4;p[c+n].b=n*4;}

   p[0].r=63;
   p[0].g=0;
   p[0].b=63;

   set_palette(p);
  }

  if(usevideobitmaps) {
   logmsg("Creating Video Page Flipping Surface.(hardware accel)\n");
   page1=create_video_bitmap(SCREEN_W,SCREEN_H);
   if(!page1) {
    logmsg("!failed\n");
    goto doublebuffer;
   }
   page2=create_video_bitmap(SCREEN_W,SCREEN_H);
   if(!page2) {
    destroy_bitmap(page1);page1=0;
    logmsg("!failed to create 2nd page\n");
    goto doublebuffer;
   }
   page=page2;
  } else {
doublebuffer:
   logmsg("Creating Software Double Buffer.(slow!)\n");
   page=create_bitmap(SCREEN_W,SCREEN_H);
  }
 return 0;
}

int main() {
 

 allegro_init();
 {char dir[1024];
  get_executable_name(dir,1024);
  replace_filename(dir,dir,"",1024);
  chdir(dir);
  remove("log.txt");
  logmsg("Executing in %s.\n",dir);

  readsetup();
 }

 logmsg("Initializing Main Allegro System.\n");
 {time_t t;
  time(&t);
  logmsg("Time is %s",asctime(localtime(&t)));
  logmsg("Randomizing Random Numbers Generator with %d.\n",t);
  srand(t);
 }

 loadsound();

 if(launchAllegro()) {
  allegro_message("Unable to start Allegro System!
Read log.txt for possible reasons.");
  exit(-1);
 }

 logmsg("Launching Menu.\n");
 menu_init();

 // This is the main loop, where user input is checked and grafix are displayed
 ticks=0;
 while(1){
  // Always keep up with frames.
  // This causes the game to run with constant speed at faster machines.
  // At slower machines, it causes grafix frames to be dropped.
  // (If the machine is too slow to keep up with the frames, this program
  //  will completely lock up.)
  if(frames<=ticks) { // We are just in time or behind
   

   if(mod==MODE_MENU) {
    if(menu_process()) break;
   }
   else
   if(mod==MODE_GAME||mod==MODE_GAMEDONE) {

    #ifdef LIBNET

    // Neither server nor client -> treat as single player

    if(serverisrunning==0&&clientisrunning==0) {
     if(game_process()) return -1;
    }
    else if(serverisrunning) {
     if(game_server()) return -1;
    }
    else if(clientisrunning) {
     if(game_client()) return -1;
    }

    #else

    game_process();

    #endif
   }
   frames++;
  } else { // whenever there is time, do the graphics

   acquire_bitmap(page); // In case it is a hardware bitmap

   if(mod==MODE_MENU){
    menu_grafix(page);
   }
   if(mod==MODE_GAME||mod==MODE_GAMEDONE) {
    game_grafix(page);
   }

   release_bitmap(page); // done with drawing to our video bitmap

   if(page1&&page2) { // use page flipping
    show_video_bitmap(page);
    if(page==page1) page=page2; else page=page1;
   } else { // no page flipping, try double buffer
    acquire_screen();
    blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    release_screen();
   }

   gframes++; // count graphics frames, so we can measure the fps
   if(ticks>frametime+50) { // one second has passed ?
    frametime=ticks; // remember time
    fps=gframes; // the this is our fps
    gframes=0;   // clear frames for next second
   }

  }
 }
 writesetup(); // save user data so they don't need to be typed in again

 return 0;
} END_OF_MAIN();
