// GAME

#include <math.h>
#include <allegro.h>
#include <stdlib.h>
#include <string.h>

#include "main.h"
#include "menu.h"
#include "ob.h"
#include "tile.h"
#include "map.h"
#include "log.h"

#include "server.h"
#include "client.h"

// variables for autozoom of codecompass
int codecom=0,codecomz=250,codecomf=0;

int saving=0;
int messagetime=0;
int messagetype=0;
enum {MSG_NO,MSG_SAVE,MSG_LOAD,MSG_CODE};

int game_init(void) {
 int r = 0;
 loadtiles();
 mod=1;
 if(map==0) {
  #ifdef LIBNET
   if(clientisrunning==0) createmap(r=rand()); else delmap();
  #else
   createmap(r=rand());
  #endif
 }

 if(map) logmsg("Using Map %d.\n",r);

 #ifdef LIBNET
 if(serverisrunning) logmsg("Starting Server.\n");
 else if(clientisrunning) logmsg("Starting Client.\n");
 else logmsg("Starting Single Player.\n");
 #else
  logmsg("Starting Game.\n");
 #endif

 saving=0;

 return 0;
}

int game_end() {
 #ifdef LIBNET
 endserver();
 endclient();
 #endif
 deltiles();
 return 0;
}

int game_process() {
 int n;
 if(key[KEY_ESC]) {
  game_end();
  menu_init();
 }

 if(key[KEY_F2]&&mod==MODE_GAME) {
  if(saving) {
   int pause=ticks;
   savemap("allefant.sav");
   ticks=pause;
   saving=0;
   messagetype=MSG_SAVE;
   messagetime=ticks+100;
  } else {
   messagetype=3;
   messagetime=ticks+100;
  }
 }
 if(key[KEY_F3]) {
  int pause=ticks;
  loadmap("allefant.sav");
  ticks=pause;
  saving=scod-POS_CODE;
  messagetype=MSG_LOAD;
  messagetime=ticks+100;
  mod=MODE_GAME;
  saving=0;
 }

 // Every player has a control byte, telling what keys are pressed.
 // All the network code in this game is just a test, so there may
 // be some un-useful variables and things in there

 ctrl[0]=0;
 if(key[key_run]) ctrl[0]|=1;
 if(key[key_left]) ctrl[0]|=2;
 if(key[key_right]) ctrl[0]|=4;
 if(key[key_fire]) ctrl[0]|=8;
 if(key[key_back]) ctrl[0]|=16;

 if(mod==MODE_GAME) {
  for(n=0;n<512;n++) {
   processob(n);
  }
  spawn(0);
 }
 return 0;
}

#ifdef LIBNET

//uh oh ... dunno if this is good idea...
//i just update the objects on the client with server position
int server_update_pos=POS_FLIGHT;

// We are running this as the server
// I have no experience with network games, so in this program the
// server is also its own first client somehow...
int game_server() {
 int n;
 char str[1024];
 int x;

 if(key[KEY_ESC]) {
  game_end();
  menu_init();
 }

 // Server is in state 1: Wait for connecting client(s)
 if(serverisrunning==1) {
  if(checkfornewconnection(3)==0) serverisrunning=2;
 }
 // Server state 2: negotiate with client(s)
 if(serverisrunning==2) {
  int x;
  char str[1024];
  x=net_receive(clientlist,str,1024,0);
  if(x>0) {
   str[x]=0;
   if(!strcmp(str,"gimme mapnum")) {
    sprintf(str,"mapnum=%d",mapnum);
    net_send(clientlist,str,strlen(str));
   }
   if(!strcmp(str,"let's do it")) {
    serverisrunning=3;
    ticks=0;
    frames=0;
    ctrl[1]=0; // assume client does nothing
   }
  }
 }
 // Server state 3 means server is running a game
 if(serverisrunning==3) {

  // Object 0 is the server-side Allefant
  // Object 1..<num of clients> are the client Allefants

  // In the moment, there is only one client, with object nr 1

  // Control byte for server
  ctrl[0]=0;
  if(key[key_run]) ctrl[0]|=1;
  if(key[key_left]) ctrl[0]|=2;
  if(key[key_right]) ctrl[0]|=4;
  if(key[key_fire]) ctrl[0]|=8;
  if(key[key_back]) ctrl[0]|=16;

  // assume client does same as before
  ctrl[1]=ctrl[1];

  // Receive data from client (if any)
  x=net_receive(clientlist,str,1024,0);
  // I'm not sure how this works, so if more than 1 bytes arrive,
  // i treat the first ones as the ones the client sent ???
  if(x>=1) {
   ctrl[1]=str[0]; // the client sends the state of its controls
  }

  // send control state of server back to client 1

  str[0]=ctrl[0];
  //str[1]=ctrl[1];

  // send the frame number, so client
  // can do some assumptions on real position
  *((short *)(&str[2]))=frames;

  // send server+client position to client
  *((short *)(&str[4]))=all[0].x;
  *((short *)(&str[6]))=all[0].y;
  *((short *)(&str[8]))=all[0].a*1000.0;
  *((short *)(&str[10]))=all[1].x;
  *((short *)(&str[12]))=all[1].y;
  *((short *)(&str[14]))=all[1].a*1000.0;

  // update monster position
  {int info=server_update_pos;
   info+=((all[server_update_pos].id)<<16);
   *((int *)(&str[16]))=info;

   info=smon+(sfmon<<16);
   *((int *)(&str[20]))=info;

   *((short *)(&str[24]))=(short)all[server_update_pos].x;
   *((short *)(&str[26]))=(short)all[server_update_pos].y;
   *((float *)(&str[28]))=all[server_update_pos].a;
  }
  server_update_pos++;
  if(server_update_pos>=sfmon&&
     server_update_pos<POS_MONSTER) server_update_pos=POS_MONSTER;
  if(server_update_pos>=smon) server_update_pos=POS_FLIGHT;

  net_send(clientlist,str,32); // 32 bytes, 50 times a second, makes 12.800 Bits
                               // from server, and there are also some from
                               // client
  if(mod==MODE_GAME) {
   for(n=0;n<POS_FLIGHT;n++) {
    processob(n);
   }
   for(n=POS_FLIGHT;n<sfmon;n++) {
    processob(n);
   }
   for(n=POS_MONSTER;n<smon;n++) {
    processob(n);
   }

   spawn(0);
   spawn(1);
  }
 }
 return 0;
}

// Ok, this time we really run as a client
int game_client() {
 int n;
 int x;
 char str[1024];

 if(key[KEY_ESC]) {
  game_end();
  menu_init();
 }

 // Client state 1: Try to connect to server
 if(clientisrunning==1) {
  if(checkforserverresponse()==0) clientisrunning=2;
 }

 // Client state 2: negotiate with server
 if(clientisrunning==2) {
  char str[1024];
  sprintf(str,"gimme mapnum");
  if(net_send(chan,str,strlen(str))==0) clientisrunning=3;
 }

 // Client state 3: negotiate again
 if(clientisrunning==3) {
  int x;
  char str[1024];
  x=net_receive(chan,str,1024,0);
  if(x>0) {
   str[x]=0;
   if(!strncmp(str,"mapnum=",7)) {
    sscanf(str,"mapnum=%d",&mapnum);
    createmap(mapnum);
    sprintf(str,"let's do it");
    if(net_send(chan,str,strlen(str))==0) clientisrunning=4;
    ticks=0;
    frames=0;
   }
  }
 }

 // Client in state 4 is a running client
 if(clientisrunning==4) {
  int frameping;

  // Object 0 now is our client, object 1 the server
  // (object 2... might get the remaining clients)

  // keyboard state
  ctrl[0]=0;
  if(key[key_run]) ctrl[0]|=1;
  if(key[key_left]) ctrl[0]|=2;
  if(key[key_right]) ctrl[0]|=4;
  if(key[key_fire]) ctrl[0]|=8;
  if(key[key_back]) ctrl[0]|=16;

  // send state of controls to server
  str[0]=ctrl[0];
  //*((float *)(&str[4]))=all[0].x;
  //*((float *)(&str[8]))=all[0].y;
  //*((float *)(&str[12]))=all[0].a;
  net_send(chan,str,1);

  // assume server (client who runs as server) is doing nothing
  ctrl[1]=0;

  // get data
  x=net_receive(chan,str,1024,0);
  // i still don't know what this code (exactly) does
  if(x>=32) {
   // update controls state
   //ctrl[1]=str[0];

   // get server controls
   ctrl[1]=str[0];

   frameping=*((unsigned short *)(&str[2]));

   // update server+client position

   opos(all[1].x,all[1].y)&=~128;

   all[1].x=*((short *)(&str[4]));
   all[1].y=*((short *)(&str[6]));
   all[1].a=*((short *)(&str[8]))/1000.0;

   opos(all[1].x,all[1].y)|=128;

   opos(all[0].x,all[0].y)&=~128;

   all[0].x=*((short *)(&str[10]));
   all[0].y=*((short *)(&str[12]));
   all[0].a=*((short *)(&str[14]))/1000.0;

   opos(all[0].x,all[0].y)|=128;

   //{int i=frameping;
    //processallefant(0,ctrl[0]);
   //}

   // get monster position
   {int info,upos,mapchange;
    int old;
    info=*((int *)(&str[16]));
    upos=info&511;
    info>>=16;
    all[upos].id=info;

    mapchange=0;
    if(info==OB_ALLEGATOR||
       info==OB_ALLEBEAR||
       info==OB_ALLEFISH||
       info==OB_DRAGONBODY) mapchange=1;

    if(mapchange) opos(all[upos].x,all[upos].y)&=~128;

    info=*((int *)(&str[20]));

    old=smon;
    smon=info&511;

    while(old>smon) {
     old--;
     all[old].id=0;
    }

    old=sfmon;
    sfmon=(info>>16)&511;
    while(old>sfmon) {
     old--;
     all[old].id=0;
    }

    all[upos].x=(float)*((short *)(&str[24]));
    all[upos].y=(float)*((short *)(&str[26]));
    all[upos].a=*((float *)(&str[28]));

    if(mapchange) opos(all[upos].x,all[upos].y)|=128;
   }
  }

 }

 if(mod==MODE_GAME) {

  for(n=0;n<POS_FLIGHT;n++) {
   processob(n);
  }
  for(n=POS_FLIGHT;n<sfmon;n++) {
   processob(n);
  }
  for(n=POS_MONSTER;n<smon;n++) {
   processob(n);
  }

  // guess i should this completely let do the server...but oh well,
  // i wait until i understand the sending and receiving a bit more
  // before i add too much to it
  //spawn(0);
  //spawn(1);
 }
 return 0;
}

#endif

// This draws all that is visible onto the page-bitmap,
// like a tilemap, objects, and some other stuff
int game_grafix(BITMAP *page) {
 int n;
 float rot;

 int ix,iy;
 int tx,ty,ltx,tty;
 int xp,lxp,yp;

 #ifdef LIBNET

 if(clientisrunning||serverisrunning)
 if(serverisrunning!=3&&clientisrunning!=4) {
  clear_to_color(page,makecol(0,0,0));
  if(serverisrunning) {
   char *text[]={"","Listening","Negotiating","Running"};
   textprintf(page,font,0,0,makecol(200,0,0),"%s",text[serverisrunning]);
  }
  if(clientisrunning) {
   char *text[]={"","Connecting","Negotiating","Loading Map","Running"};
   textprintf(page,font,0,0,makecol(200,0,0),"%s",text[clientisrunning]);
  }
  return 0;
 }

 #endif

 // draw tilemap
 if(map) {
  ix=all[0].x-SCREEN_W/2;
  iy=all[0].y-SCREEN_H/2;

  ltx=512+(ix>>5);
  tty=512+(iy>>5);
  lxp=-(ix&31);
  yp=-(iy&31);

  ty=tty;
  for(;yp<SCREEN_H;yp+=32,ty++){
   xp=lxp;
   tx=ltx;
   for(;xp<SCREEN_W;xp+=32,tx++){
    int t=pos(tx,ty)&127;
    if(tile[t]){
     draw_sprite(page,tile[t],xp,yp);
    }
   }
  }

 }
 // draw objects
 for(n=511;n>=0;n--) {
  if(!all[n].id) continue;
  xp=SCREEN_W/2+all[n].x-(int)all[0].x;
  yp=SCREEN_H/2+all[n].y-(int)all[0].y;
  rot=(32.0*all[n].a/(pi*2))+0.5;
  if(rot<0)rot+=32;
  if(rot>=32)rot-=32;
  switch(all[n].id){
   case OB_SHOT: draw_sprite(page,O[OB_SHOT][0],xp-3,yp-3);break;
   case OB_NUMBER: textprintf(page,font,xp,yp,makecol(200,0,0),"%d",all[n].t);break;
   case OB_CODE: draw_sprite(page,O[OB_CODE][0],xp-16,yp-16); break;
   default: draw_sprite(page,O[all[n].id][(int)rot],xp-32,yp-32);
  }
 }
 {int x,y;

  x=SCREEN_W/2-35-100;
  y=SCREEN_H-35;

  // life bar
  rectfill(page,x,y,x+100,y+9,makecol(100,0,0));
  if(all[0].l>0)
   rectfill(page,x+100-all[0].l,y,x+100,y+9,
    makecol(150+all[0].l,0,0));
  rect(page,x-1,y-1,x+101,y+10,makecol(0,0,0));

  x=SCREEN_W/2+35;

  // ammo bar
  rectfill(page,x,y,x+100,y+9,makecol(0,0,100));
  if(wshot[0])
   rectfill(page,x,y,x+wshot[0],y+9,
    makecol(0,0,150+wshot[0]));
  rect(page,x-1,y-1,x+101,y+10,makecol(0,0,0));

  x=1;
  y=1;

  // collected codepages display
  draw_sprite(page,O[8][0],x,y);
  textprintf(page,font,x+10,y+10,makecol(50,0,0),"%d",scod-POS_CODE);
  textprintf(page,font,x+10,y+10+text_height(font),makecol(0,50,0),"%d",ch[0]);

  // danger display
  textprintf(page,font,x+10,y+10+text_height(font)*2,makecol(100,0,0),"%d",
   smon-POS_MONSTER);

  // fps display
  {char str[256];
   if(page1) sprintf(str,"fps=%d",fps);
   else sprintf(str,"fps=%d (not accel)",fps);
   textprintf(page,font,SCREEN_W-text_length(font,str),0,makecol(0,0,0),
   "%s",str);
   if(colordepth==8) {
    char str[256];sprintf(str,"PAL");
    textprintf(page,font,
     SCREEN_W-text_length(font,str),text_height(font),makecol(200,0,0),"%s",str);
   }
  }
 }

 if(mod==2){
  textprintf(page,font,280,230,makecol(255,0,0),scod==POS_CODE?"YOU WIN":"GAME OVER");
 }

 //satellite map
 rect(page,9,SCREEN_H-11-80,80+10,SCREEN_H-10,makecol(0,0,0));
 blit(satmap,page,
  ((((int)all[0].x)>>5)+512-160)/4,
  ((((int)all[0].y)>>5)+512-160)/4,10,SCREEN_H-10-80,80,80);
 rect(page,9+40-4,SCREEN_H-11-80+40-3,9+40+4,SCREEN_H-11-80+40+3,makecol(255,0,0));

 // code compass
 {int h=POS_CODE;
  int x,y;

  int cy=SCREEN_H-40;


  if(scod!=POS_CODE) h+=(rand()%(scod-POS_CODE));

  circlefill(page,SCREEN_W/2,cy,30,makecol(0,100,0));

  if(codecomf>0) {
   if(codecomz>100) codecomz--;
  } else {
   if(codecomz<500) codecomz++;
  }
  {int l=500-codecomz;
   l/=14;
   line(page,SCREEN_W/2,cy,SCREEN_W/2+l,cy,makecol(0,150,0));
   line(page,SCREEN_W/2,cy,SCREEN_W/2-l,cy,makecol(0,150,0));
   line(page,SCREEN_W/2,cy,SCREEN_W/2,cy+l,makecol(0,150,0));
   line(page,SCREEN_W/2,cy,SCREEN_W/2,cy-l,makecol(0,150,0));
  }

  x=(all[h].x-all[0].x)/codecomz;
  y=(all[h].y-all[0].y)/codecomz;
  if(x*x+y*y<27*27) {
   codecom=h;
  }

  x=(all[codecom].x-all[0].x)/codecomz;
  y=(all[codecom].y-all[0].y)/codecomz;

  if(x*x+y*y<27*27) {
   if(codecomf<250) codecomf++;
   line(page,SCREEN_W/2,cy,SCREEN_W/2+x,cy+y,makecol(0,200,0));
   circle(page,SCREEN_W/2+x,cy+y,3,makecol(0,255,0));
  } else {
   if(codecomf>-250) codecomf--;
  }

  {int l=sqrt(all[0].x*all[0].x+all[0].y*all[0].y);
   x=-all[0].x*30/l;
   y=-all[0].y*30/l;
   line(page,SCREEN_W/2+x/2-y/4,cy+y/2+x/4,SCREEN_W/2+x/2+y/4,cy+y/2-x/4,makecol(150,0,0));
   line(page,SCREEN_W/2+x,cy+y,SCREEN_W/2+x/2+y/4,cy+y/2-x/4,makecol(150,0,0));
   line(page,SCREEN_W/2+x/2-y/4,cy+y/2+x/4,SCREEN_W/2+x,cy+y,makecol(150,0,0));

   textprintf(page,font,
    SCREEN_W/2-text_length(font,"0")/2,
    cy-text_height(font)/2,makecol(150,0,0),"%d",l/1000);
  }

  circle(page,SCREEN_W/2,cy,30,makecol(0,0,0));
 }

 if(toomany>ticks) {
  textprintf_centre(page,font,
    SCREEN_W/2,SCREEN_H/2,makecol(150,0,0),"You already carry the maximum of 5 code pages !");
 }

 if(messagetime>ticks) {
  if(messagetype==MSG_SAVE) {
   textprintf_centre(page,font,
     SCREEN_W/2,SCREEN_H/2+10,makecol(150,0,0),"Game saved");
  }
  if(messagetype==MSG_LOAD) {
   textprintf_centre(page,font,
     SCREEN_W/2,SCREEN_H/2+10,makecol(150,0,0),"Game loaded");
  }
  if(messagetype==MSG_CODE) {
   textprintf_centre(page,font,
     SCREEN_W/2,SCREEN_H/2+10,makecol(150,0,0),"Collect Code Page before saving");
  }
 }
 return 0;
}
