#ifdef LIBNET

#include <libnet.h>

#include "net.h"
#include "log.h"

int clientisrunning=0;
NET_CHANNEL *chan=0;

int initclient(char *address) {

 int netdriver=NETDRIVER;

 chan=net_openchannel(netdriver,0);

 if(!chan) {
  logmsg("Unable to open channel.\n");
  return 1;
 }

 logmsg("Return address is '%s'.\n",net_getlocaladdress(chan));

 logmsg("Connecting to '%s'.\n",address);
 if(net_assigntarget(chan,address)) {
  net_closechannel(chan);

  logmsg("Can't assign address '%s'.\n",address);
  return 1;
 }
 {char str[256];
  strcpy(str,"hey");
  net_send(chan,str,strlen(str));
 }

 clientisrunning=1;
 return 0;
}

int endclient() {
 if(!clientisrunning) return 0;
 {char str[256];
  strcpy(str,"bye");
  net_send(chan,str,strlen(str));
 }
 net_closechannel(chan);
 chan=0;

 clientisrunning=0;
 return 0;
}

//  0=ok, got response
//  1=error
// -1=no response yet
int checkforserverresponse() {
 char temp[1024];
 char newaddr[NET_MAX_ADDRESS_LENGTH];
 int x;

 if(!net_query(chan)) return -1;

 x=net_receive(chan,temp,1024,newaddr);
 if(x<0) {
  net_closechannel(chan);

  logmsg("Failed to receive server response.\n");
  return 1;
 }

 if(x==0) {
  return -1;
 }

 temp[x]=0;

 if(strcmp(temp,"OK")){
  net_closechannel(chan);

  logmsg("Connection refused.\n");
  return 1;
 }
 logmsg("Redirecting to '%s'.\n",newaddr);
 if(net_assigntarget(chan,newaddr)) {
  net_closechannel(chan);

  logmsg("Can't assign address '%s'.\n",newaddr);
  return 1;
 }

 logmsg("Connection established.\n");
 return 0;
}

#endif
