/******************************************************************************/

#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include <allegro\internal\aintern.h>
#include <winalleg.h>
#include <time.h>
#include <commctrl.h>
#include "resource.h"

/******************************************************************************/

#define for if( false ) {} else for

#define WINDOW_TITLE            "Alarm Clock"
#define CLASSNAME               "My Class Name"
#define CONFIG_FILE             "alarm.cfg"

#define MAX_COLOR               11

#define MYWM_NOTIFYICON		    (WM_APP+100)
#define IDM_OPENWND             10001 
#define IDM_CLOSEWND            10003 

#define MIN_RANGE               0
#define MAX_RANGE               255

/******************************************************************************/

int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow );
LRESULT CALLBACK WndProc( HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK setting_dialog( HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK alarm_dialog( HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam );
BOOL TrayMessage( HWND hDlg, DWORD dwMessage );
int init( HWND hWnd );
void destroy();
void loop( HWND hWnd );
void load_config_data();
void save_config_data();
void draw_number( int a, int x, int y );
void draw_dnumber( int a, int x, int y );
void draw_time();
void paint( HDC hDC, RECT *lp );
void get_time();
void set_title();
int get_color( int i );
void colorNum();
void make_colors();
void stop_alarm();
void play_alarm();




/******************************************************************************/

HINSTANCE   hInstance       = NULL;
HWND        hWnd            = NULL;
HWND        hRed            = NULL;
HWND        hGreen          = NULL;
HWND        hBlue           = NULL;
HICON       hIcon           = NULL;
RECT        lpRect          = { 0, 0, 408, 128 };
RECT        box             = { 0, 0, 0, 0 };
RECT        colorbox        = { 0, 0, 0, 0 };
time_t      ltime;
struct tm   *today          = NULL;
static char tstring[ 60 ]   = WINDOW_TITLE;
BITMAP      *buffer         = NULL;
BITMAP      *numbit         = NULL;
bool        done            = false;
bool        con             = true;
bool        gettime         = false;
bool        soundon         = false;
bool        buzzer          = false;
bool        playing         = false;
bool        editing         = false;
int         count           = 0;
int         depth           = 8;
int         xpos            = 20;
int         ypos            = 20;

int         hours           = 0;
int         minutes         = 0;
int         seconds         = 0;


int         alarm           = 0;
int         ahour           = 0;
int         aminute         = 0;
int         military        = 0;
int         red             = 0;
int         green           = 100;
int         blue            = 0;
char        wavfile[ 256 ]  = "";
int         repeating       = 0;
int         playsound       = 0;
SAMPLE      *effect         = NULL;
int         oalarm          = alarm;
int         oahour          = ahour;
int         oaminute        = aminute;
int         omilitary       = military;
int         ored            = red;
int         ogreen          = green;
int         oblue           = blue;
char        owavfile[ 256 ] = "";
int         orepeating      = repeating;
int         oplaysound      = playsound;
SAMPLE      *oeffect        = NULL;


/******************************************************************************/

unsigned char array[ 56 ][ 28 ] =
{
    { 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0 },
    { 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0 },
    { 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0 },
    { 0, 0, 4, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 0, 0, 0, 0 },
    { 0, 0, 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0 },
    { 4, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 4, 0, 0, 4, 3, 4, 0, 0, 0, 0, 4, 3, 4, 0, 0 },
    { 4, 3, 3, 4, 0, 0, 0, 0, 0, 0, 4, 3, 3, 4, 0, 4, 3, 2, 3, 4, 0, 0, 4, 3, 2, 3, 4, 0 },
    { 4, 3, 2, 3, 4, 0, 0, 0, 0, 4, 3, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 2, 3, 4, 0, 0, 4, 3, 2, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 2, 3, 4, 0, 0, 4, 3, 2, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 3, 4, 0, 0, 0, 0, 4, 3, 2, 3, 4 },
    { 4, 3, 2, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 3, 3, 4, 0, 0, 0, 0, 0, 0, 4, 3, 3, 4 },
    { 0, 4, 3, 2, 3, 4, 0, 0, 4, 3, 2, 3, 4, 0, 4, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 4, 3, 4 },
    { 0, 0, 4, 3, 4, 0, 0, 0, 0, 4, 3, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 },
    { 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0 },
    { 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0 },
    { 0, 0, 4, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 0, 0, 0, 0 },
    { 0, 4, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 0, 0, 0 },
    { 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0 },
    { 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0 },
    { 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 2, 1, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 2, 1, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 2, 2, 2, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 4, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

unsigned char coords[ 8 ][ 6 ] =
{
    {  0,  0, 26,  7,  3,  3 },
    {  0,  7,  7, 27,  1,  5 },
    {  7,  7,  7, 27, 24,  5 },
    {  0, 34, 22,  7,  5, 28 },
    { 14,  7,  7, 26,  1, 32 },
    { 21,  7,  7, 26, 24, 32 },
    {  0, 41, 26,  7,  3, 53 },
    {  0, 48,  8,  8,  0,  0 }
};

unsigned char bitmark[ 11 ] =
{
    119, 36, 93, 109, 46, 107, 123, 37, 127, 111, 128
};

RGB colors[ MAX_COLOR ] =
{
    {   0,   0,   0 },    
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {   0,   0,   0 },
    {  64,  64,  64 },
    { 255, 255, 255 }
};


unsigned char pos[ 7 ] =
{
    8, 40, 72, 80, 112, 144, 156
};


int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    WNDCLASSEX  WndClass;
    MSG         Msg;
    HDC         hDC        = NULL;
    int         dwStyle    = 0;

    hInstance = hInst;

    WndClass.cbSize        = sizeof( WNDCLASSEX );
    WndClass.style         = NULL;
    WndClass.lpfnWndProc   = WndProc;
    WndClass.cbClsExtra    = 0;
    WndClass.cbWndExtra    = 0;
    WndClass.hInstance     = hInstance;
    WndClass.hIcon         = LoadIcon( hInstance, MAKEINTRESOURCE( IDI_ICON ) );
    WndClass.hIconSm       = LoadIcon( hInstance, MAKEINTRESOURCE( IDI_ICON16 ) );
    WndClass.hCursor       = LoadCursor( hInstance, IDC_ARROW );
    WndClass.hbrBackground = ( HBRUSH )GetStockObject( BLACK_BRUSH );
    WndClass.lpszMenuName  = NULL;
    WndClass.lpszClassName = CLASSNAME;

    hIcon = WndClass.hIconSm;

    if( !RegisterClassEx( &WndClass ) )
    {
        MessageBox( NULL, "Window Registration Failed!", "Error!", MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
        return 0;
    }

    dwStyle =  WS_DLGFRAME | 
               WS_CAPTION | 
               WS_SYSMENU | 
               WS_MINIMIZEBOX;
    
    AdjustWindowRect( &lpRect, dwStyle, FALSE );

    if ( ( hWnd = CreateWindowEx( WS_EX_CLIENTEDGE,// | WS_EX_TOPMOST,
                           CLASSNAME,
                           WINDOW_TITLE,
                           dwStyle,
                           xpos,
                           ypos,
                           lpRect.right - lpRect.left,
                           lpRect.bottom - lpRect.top,
                           NULL,
                           NULL,
                           hInstance,
                           NULL ) ) == NULL )
    {
        MessageBox( hWnd, "Window Creation Failed!", "Error!",
                    MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL );
        return 0;
    }

    if( ( hDC = GetDC( hWnd ) ) == NULL )
    {
        MessageBox( hWnd, "Device Context Creation Failed!", "Error!",
                    MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL );
        return 0;
    }

    if ( init( hWnd ) >= 0 )
    {
        ShowWindow( hWnd, SW_SHOWNORMAL );
        UpdateWindow( hWnd );

        while ( !done )
        {
            while ( PeekMessage( &Msg, hWnd, 0, 0, PM_REMOVE ) )
            {
                TranslateMessage( &Msg );
                DispatchMessage( &Msg );
            }

            loop( hWnd );
        }       
    }

    ShowWindow( hWnd, SW_HIDE );

    destroy();


    return Msg.wParam;
}

LRESULT CALLBACK WndProc( HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam )
{
    bool active = false;
    static UINT s_uTaskbarRestart;

    switch( Message )
    {
        case WM_CREATE:
        {
        } break;

        case WM_COMMAND:
        {
            switch ( wParam )
            {

            case IDM_CLOSEWND:
                {
                    TrayMessage( hWnd, NIM_DELETE );
                    SendMessage( hwnd, WM_DESTROY, wParam, lParam );
                } break;
        
            case IDM_OPENWND:
                {
                    ShowWindow( hWnd, SW_SHOWMINIMIZED );
                    Sleep(100);
                    OpenIcon( hWnd );
			        SetForegroundWindow( hWnd );
                    TrayMessage( hWnd, NIM_DELETE );
                } break;

            }
        } break;

        case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HDC hdc = BeginPaint( hWnd, &ps  );
            paint( hdc, &ps.rcPaint );
            EndPaint( hWnd, &ps );

        } break;

        case WM_MOUSEMOVE:
        {
            mouse_x = LOWORD( lParam );
            mouse_y = HIWORD( lParam );
        }
        break;

        case WM_LBUTTONDOWN:
        {
            stop_alarm();
            mouse_b |= 1;
        } break;

        case WM_LBUTTONUP:
        {
            stop_alarm();
            if ( mouse_b & 1 )
            {
                mouse_b ^= 1;
            }
        } break;

        case WM_RBUTTONDOWN:
        {
            stop_alarm();
            mouse_b |= 2;
        } break;

        case WM_RBUTTONUP:
        {
            stop_alarm();
            DialogBox( hInstance, MAKEINTRESOURCE( IDD_SETTING ), hWnd, (DLGPROC)setting_dialog );

            if ( mouse_b & 2 )
            {
                mouse_b ^= 2;
            }
        } break;


        case WM_MOVE:
        {
            xpos = LOWORD( lParam );
            ypos = HIWORD( lParam );
            InvalidateRect( hWnd, &lpRect, FALSE );
        } break;

        case WM_CLOSE:
        {
            SendMessage( hwnd, WM_DESTROY, wParam, lParam );
        }
        break;

        case WM_DESTROY:
        {
            done = true;
        } break;

        case WM_SIZE:
        {
            if ( wParam == SIZE_MINIMIZED )
            {
                ShowWindow( hWnd, SW_HIDE );
                TrayMessage( hWnd, NIM_ADD );
                return FALSE;
            }
        } break;

    	case MYWM_NOTIFYICON:
        {
            switch ( lParam )
            {
            case WM_LBUTTONDBLCLK:
                {
                    ShowWindow( hWnd, SW_SHOWMINIMIZED );
                    Sleep(100);
                    OpenIcon( hWnd );
			        SetForegroundWindow( hWnd );
                    TrayMessage( hWnd, NIM_DELETE );
                } break;

            case WM_RBUTTONUP:
                {
                    POINT point;        
                    GetCursorPos (&point);       

                    TCHAR szRestore[] = TEXT( "&Restore" );     
                    TCHAR szAbout[] = TEXT( "&About" );
                    TCHAR szClose[] = TEXT( "&Close" );

                    HMENU hm = CreatePopupMenu(); 

                    AppendMenu( hm, MF_ENABLED | MF_STRING, IDM_OPENWND, szRestore );
                    AppendMenu( hm, MF_SEPARATOR, 0, NULL );
                    AppendMenu( hm, MF_ENABLED | MF_STRING, IDM_CLOSEWND, szClose );

                    point.x -= 80;

                    TrackPopupMenu( hm, 
                                    TPM_LEFTBUTTON | TPM_RIGHTBUTTON, 
                                    point.x, 
                                    point.y, 
                                    0, 
                                    hWnd, 
                                    NULL );

                    DestroyMenu( hm ); 
            
                    PostMessage (hwnd, WM_USER, 0, 0); 
                }
            }
        } break;

        default:
        {
            return DefWindowProc( hwnd, Message, wParam, lParam );
        }
    }

    return FALSE;
}


BOOL CALLBACK setting_dialog( HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam )
{
    switch( uiMsg )
    {
    case WM_INITDIALOG:
        {
            editing = true;

            ored        = red;
            ogreen      = green;
            oblue       = blue;
            omilitary   = military;
            oalarm      = alarm;
            oahour      = ahour;
            oaminute    = aminute;
            orepeating  = repeating;
            oplaysound  = playsound;
            oeffect     = effect;
            strcpy( owavfile, wavfile );


            GetWindowRect( hDlg, &box );
            GetClientRect( GetDlgItem( hDlg, IDC_FRAME ), &colorbox );


            colorbox.left += 32;
            colorbox.right += 32;
            colorbox.top += 312;
            colorbox.bottom += 312;


            if ( repeating )
            {
                SendDlgItemMessage( hDlg, IDC_REPEAT, BM_SETCHECK, BST_CHECKED, 0 );
            }
            else
            {
                SendDlgItemMessage( hDlg, IDC_REPEAT, BM_SETCHECK, BST_UNCHECKED, 0 );
            }

            if ( playsound )
            {
                SendDlgItemMessage( hDlg, IDC_PLAY, BM_SETCHECK, BST_CHECKED, 0 );
            }
            else
            {
                SendDlgItemMessage( hDlg, IDC_PLAY, BM_SETCHECK, BST_UNCHECKED, 0 );
            }

            SendDlgItemMessage(hDlg, IDC_RADIO_12, BM_SETCHECK, !military, 0);
            SendDlgItemMessage(hDlg, IDC_RADIO_24, BM_SETCHECK, military, 0);

            SendDlgItemMessage(hDlg, IDC_RADIO_AM, BM_SETCHECK, ahour < 12, 0);
            SendDlgItemMessage(hDlg, IDC_RADIO_PM, BM_SETCHECK, ahour > 11, 0);

			SendDlgItemMessage(hDlg, IDC_SPIN_HOUR,UDM_SETRANGE, 0, (LPARAM) MAKELONG((short) 12, (short) 0) );
			SendDlgItemMessage(hDlg, IDC_SPIN_HOUR,UDM_SETPOS, 0, (LPARAM) MAKELONG((short) ahour, 0) );

			SendDlgItemMessage(hDlg, IDC_SPIN_MINUTE,UDM_SETRANGE, 0, (LPARAM) MAKELONG((short) 59, (short) 0)  );
			SendDlgItemMessage(hDlg, IDC_SPIN_MINUTE,UDM_SETPOS, 0, (LPARAM) MAKELONG((short) aminute, 0) );








            EnableWindow( GetDlgItem( hDlg, IDC_HOUR        ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_MINUTE      ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_EDIT6       ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_EDIT7       ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_SPIN_HOUR   ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_SPIN_MINUTE ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM    ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM    ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_PLAY        ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_EDIT5       ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_REPEAT      ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_BROWSE      ), FALSE );
            EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV     ), FALSE );

            if ( alarm )
            {
                SendDlgItemMessage( hDlg, IDC_CHECK1, BM_SETCHECK, BST_CHECKED, 0 );
                EnableWindow( GetDlgItem( hDlg, IDC_HOUR ), TRUE );
                EnableWindow( GetDlgItem( hDlg, IDC_MINUTE ), TRUE );
                EnableWindow( GetDlgItem( hDlg, IDC_EDIT6 ), TRUE );
                EnableWindow( GetDlgItem( hDlg, IDC_EDIT7 ), TRUE );
                EnableWindow( GetDlgItem( hDlg, IDC_SPIN_HOUR ), TRUE );
                EnableWindow( GetDlgItem( hDlg, IDC_SPIN_MINUTE ), TRUE );

                if ( !military )
                {
                    EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM ), TRUE );
                    EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM ), TRUE );
                }

                EnableWindow( GetDlgItem( hDlg, IDC_PLAY ), TRUE );
                if ( playsound )
                {
                    EnableWindow( GetDlgItem( hDlg, IDC_EDIT5 ), playsound );
                    EnableWindow( GetDlgItem( hDlg, IDC_REPEAT ), playsound );
                    EnableWindow( GetDlgItem( hDlg, IDC_BROWSE ), playsound );
                    if ( wavfile[ 0 ] != '\0' )
                    {
                        EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), TRUE );
                    }
                }
            }
            else
            {
                SendDlgItemMessage( hDlg, IDC_CHECK1, BM_SETCHECK, BST_UNCHECKED, 0 );
            }

            if ( military )
            {
                SetDlgItemInt( hDlg, IDC_EDIT6, ahour, FALSE ); 
            }
            else
            {
                if ( ahour % 12 == 0 )
                {
                    SetDlgItemInt( hDlg, IDC_EDIT6, 12, FALSE ); 
                }
                else
                {
                    SetDlgItemInt( hDlg, IDC_EDIT6, ahour % 12, FALSE ); 
                }
            }
            SetDlgItemInt( hDlg, IDC_EDIT7, aminute, FALSE ); 

            hRed = GetDlgItem( hDlg, IDC_SLIDER1 );
            hGreen = GetDlgItem( hDlg, IDC_SLIDER2 );
            hBlue = GetDlgItem( hDlg, IDC_SLIDER3 );

            SendMessage( hRed, TBM_SETRANGE, FALSE, MAKELONG( MIN_RANGE, MAX_RANGE ) );  
            SendMessage( hGreen, TBM_SETRANGE, FALSE, MAKELONG( MIN_RANGE, MAX_RANGE ) );  
            SendMessage( hBlue, TBM_SETRANGE, FALSE, MAKELONG( MIN_RANGE, MAX_RANGE ) );  

            SendMessage( hRed, TBM_SETPOS, TRUE, red );  
            SendMessage( hGreen, TBM_SETPOS, TRUE, green );
            SendMessage( hBlue, TBM_SETPOS, TRUE, blue );

            SetDlgItemInt( hDlg, IDC_EDIT1, red, FALSE );
            SetDlgItemInt( hDlg, IDC_EDIT2, green, FALSE );
            SetDlgItemInt( hDlg, IDC_EDIT3, blue, FALSE );

            SetDlgItemText( hDlg, IDC_EDIT5, wavfile );

            UpdateWindow( hDlg );

        } break;


		case WM_NOTIFY:
		{
			switch(LOWORD(wParam))
			{
				case IDC_SPIN_HOUR:	
				{
					LPNMUPDOWN lpnmud = (LPNMUPDOWN)lParam;
					if (lpnmud->iDelta > 0)
                    {
						ahour++;
                    }
					else
                    {
                        if ( ahour == 0 )
                        {
                            ahour = 24;
                        }
						ahour--;
                    }

                    ahour = ( ahour % 24 );

                    if ( military )
                    {
                        SetDlgItemInt( hDlg, IDC_EDIT6, ahour, FALSE ); 
                    }
                    else
                    {
                        if ( ahour % 12 == 0 )
                        {
                            SetDlgItemInt( hDlg, IDC_EDIT6, 12, FALSE ); 
                        }
                        else
                        {
                            SetDlgItemInt( hDlg, IDC_EDIT6, ahour % 12, FALSE ); 
                        }
                    }
                    SendDlgItemMessage(hDlg, IDC_RADIO_AM, BM_SETCHECK, ahour < 12, 0);
                    SendDlgItemMessage(hDlg, IDC_RADIO_PM, BM_SETCHECK, ahour > 11, 0);
                    InvalidateRect( hDlg, &box, FALSE );
				}
				break;

				case IDC_SPIN_MINUTE:	
				{
					LPNMUPDOWN lpnmud = (LPNMUPDOWN)lParam;

				
                    if (lpnmud->iDelta > 0)
                    {
						aminute++;
                    }
					else
                    {
                        if ( aminute == 0 )
                        {
                            aminute = 60;
                        }
						aminute--;
                    }

                    aminute = ( aminute % 60 );
                    
                    SetDlgItemInt( hDlg, IDC_EDIT7, aminute, 0 );
                    InvalidateRect( hDlg, &box, FALSE );
				}
				break;
			}
		}
		break;
 
    case WM_COMMAND:
        {
            switch ( LOWORD( wParam ) )
            {

            case IDC_CHECK1:
                {
                    if ( SendDlgItemMessage( hDlg, IDC_CHECK1, BM_GETCHECK, 0, 0 ) )             
                    {
                        alarm = 1;
                        EnableWindow( GetDlgItem( hDlg, IDC_HOUR ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_MINUTE ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT6 ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT7 ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_SPIN_HOUR ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_SPIN_MINUTE ), TRUE );
                        if ( !military )
                        {
                            EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM ), TRUE );
                            EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM ), TRUE );
                        }
                        EnableWindow( GetDlgItem( hDlg, IDC_PLAY ), TRUE );
                        if ( playsound )
                        {
                            EnableWindow( GetDlgItem( hDlg, IDC_EDIT5 ), TRUE );
                            EnableWindow( GetDlgItem( hDlg, IDC_REPEAT ), TRUE );
                            EnableWindow( GetDlgItem( hDlg, IDC_BROWSE ), TRUE );
                            if ( wavfile[ 0 ] != '\0' )
                            {
                                EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), TRUE );
                            }
                        }
                    }
                    else
                    {
                        alarm = 0;
                        EnableWindow( GetDlgItem( hDlg, IDC_HOUR ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_MINUTE ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT6 ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT7 ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_SPIN_HOUR ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_SPIN_MINUTE ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_PLAY ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT5 ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_REPEAT ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_BROWSE ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), FALSE );
                    }

                    return TRUE ;
                }


            case IDC_PLAY:
                {
                    if ( SendDlgItemMessage( hDlg, IDC_PLAY, BM_GETCHECK, 0, 0 ) )             
                    {
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT5 ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_REPEAT ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_BROWSE ), TRUE );
                        if ( wavfile[ 0 ] != '\0' )
                        {
                            EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), TRUE );
                        }
                        playsound = 1;
                    }
                    else
                    {
                        EnableWindow( GetDlgItem( hDlg, IDC_EDIT5 ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_REPEAT ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_BROWSE ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), FALSE );
                        playsound = 0;
                    }
                } break;

            case IDC_REPEAT:
                {
                    if ( SendDlgItemMessage( hDlg, IDC_REPEAT, BM_GETCHECK, 0, 0 ) )             
                    {
                        repeating = 1;
                    }
                    else
                    {
                        repeating = 0;
                    }
                } break;

            case IDC_TESTWAV:
                {
                    if ( effect )
                    {
                        play_alarm();
                    }
                } break;

            case IDC_RADIO_24:
                {
                    military = 1;
                    if ( alarm )
                    {
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM ), FALSE );
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM ), FALSE );
                    }

                    SetDlgItemInt( hDlg, IDC_EDIT6, ahour, FALSE ); 
                    
                    InvalidateRect( hWnd, &lpRect, FALSE );
                    InvalidateRect( hDlg, &box, FALSE );
                    return FALSE;
                }

            case IDC_RADIO_AM:
                {
                    if ( ahour > 11 )
                    {
                        ahour -= 12;
                    }
                } break;

            case IDC_RADIO_PM:
                {
                    if ( ahour < 12 )
                    {
                        ahour += 12;
                    }
                } break;

            case IDC_RADIO_12:
                {
                    military = 0;
                    if ( alarm )
                    {
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_AM ), TRUE );
                        EnableWindow( GetDlgItem( hDlg, IDC_RADIO_PM ), TRUE );
                    }

                    if ( ahour % 12 == 0 )
                    {
                        SetDlgItemInt( hDlg, IDC_EDIT6, 12, FALSE ); 
                    }
                    else
                    {
                        SetDlgItemInt( hDlg, IDC_EDIT6, ahour % 12, FALSE ); 
                    }

                    InvalidateRect( hWnd, &lpRect, FALSE );
                    InvalidateRect( hDlg, &box, FALSE );
                    return FALSE;
                }

            case IDOK:
                {
                    if ( effect && effect != oeffect )
                    {
                        destroy_sample( oeffect );
                    }

                    editing = false;

                    EndDialog( hDlg, TRUE );
                    return TRUE ;
                }
          
            case IDCANCEL:
                {
                    red         = ored;
                    green       = ogreen;
                    blue        = oblue;
                    military    = omilitary;
                    alarm       = oalarm;
                    ahour       = oahour;
                    aminute     = oaminute;
                    repeating   = orepeating;
                    playsound   = oplaysound;
                    if ( effect && effect != oeffect )
                    {
                        destroy_sample( effect );
                    }
                    effect      = oeffect;
                    strcpy( wavfile, owavfile );

                    make_colors();
                    colorNum();
                    InvalidateRect( hDlg, &colorbox, FALSE );
                    InvalidateRect( hWnd, &colorbox, FALSE );

                    editing = false;

                    EndDialog( hDlg, FALSE );
                    return TRUE ;
                }

            case IDC_BROWSE:
                {
                    OPENFILENAME ofn;
                    char szFile[ 256 ] = "";


                    ZeroMemory( &ofn, sizeof(OPENFILENAME) );
                    ofn.lStructSize = sizeof(OPENFILENAME);
                    ofn.hwndOwner = hWnd;
                    ofn.lpstrFile = szFile;
                    ofn.nMaxFile = sizeof(szFile);
                    ofn.lpstrFilter = "WAV Files\0*.wav\0All Files\0*.*\0";
                    ofn.nFilterIndex = 1;
                    ofn.lpstrFileTitle = NULL;
                    ofn.nMaxFileTitle = 0;
                    ofn.lpstrInitialDir = NULL;
                    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

                    if ( GetOpenFileName( &ofn ) ) 
                    {
                        SetDlgItemText( hDlg, IDC_EDIT5, ofn.lpstrFile );
                        strcpy( wavfile, ofn.lpstrFile );
                        if ( effect && effect != oeffect )
                        {
                            destroy_sample( effect );
                        }
                        effect = load_sample( wavfile );
                        EnableWindow( GetDlgItem( hDlg, IDC_TESTWAV ), TRUE );
                    }

                    return TRUE ;
                }

            }            
            
            return FALSE ;
        
        } break;

        case WM_PAINT:
            {
                PAINTSTRUCT ps;
                HDC hDC = BeginPaint( hDlg, &ps  );

                HBRUSH MyBrush = CreateSolidBrush( makecol24( red, green, blue));
		        HBRUSH OldBrush = (HBRUSH)SelectObject( hDC, MyBrush );

                FillRect( hDC, &colorbox, MyBrush );

                FrameRect( hDC, &colorbox, ( HBRUSH )GetStockObject( BLACK_BRUSH ) );

		        SelectObject( hDC, OldBrush );
		        DeleteObject( MyBrush );
           
                EndPaint( hDlg, &ps );
                return FALSE;
            } break;

        case WM_HSCROLL:
            {
                bool change = false;

                switch ( GetDlgCtrlID( (HWND)lParam ) )
                {
                    case IDC_SLIDER1:
                    {
                        switch( LOWORD(wParam) ) 
                        {
		                case SB_LINELEFT:
                            {
			                    red = MAX( MIN_RANGE, red - 1 );
                            } break;
		                
                        case SB_LINERIGHT:
                            {
			                    red = MIN( MAX_RANGE, red + 1 );
                            } break;
		                
                        case SB_PAGELEFT:
                            {
			                    red = MAX( MIN_RANGE, red - (MAX_RANGE/5) );
                            } break;

		                case SB_PAGERIGHT:
                            {
			                    red = MIN( MAX_RANGE, red + (MAX_RANGE/5) );
                            } break;

		                case SB_THUMBTRACK:
                            {
			                    red = HIWORD(wParam);
                            } break;
                        }

                        change = true;
                        SetDlgItemInt( hDlg, IDC_EDIT1, red, FALSE);
                        
                    } break;

                    case IDC_SLIDER2:
                    {
                        switch( LOWORD(wParam) ) 
                        {
		                case SB_LINELEFT:
                            {
			                    green = MAX( MIN_RANGE, green - 1 );
                            } break;
		                
                        case SB_LINERIGHT:
                            {
			                    green = MIN( MAX_RANGE, green + 1 );
                            } break;
		                
                        case SB_PAGELEFT:
                            {
			                    green = MAX( MIN_RANGE, green - (MAX_RANGE/5) );
                            } break;

		                case SB_PAGERIGHT:
                            {
			                    green = MIN( MAX_RANGE, green + (MAX_RANGE/5) );
                            } break;

		                case SB_THUMBTRACK:
                            {
			                    green = HIWORD(wParam);
                            } break;
                        }

                        change = true;
                        SetDlgItemInt( hDlg, IDC_EDIT2, green, FALSE);                    
                    } break;

                    case IDC_SLIDER3:
                    {
                        switch( LOWORD(wParam) ) 
                        {
		                case SB_LINELEFT:
                            {
			                    blue = MAX( MIN_RANGE, blue - 1 );
                            } break;
		                
                        case SB_LINERIGHT:
                            {
			                    blue = MIN( MAX_RANGE, blue + 1 );
                            } break;
		                
                        case SB_PAGELEFT:
                            {
			                    blue = MAX( MIN_RANGE, blue - (MAX_RANGE/5) );
                            } break;

		                case SB_PAGERIGHT:
                            {
			                    blue = MIN( MAX_RANGE, blue + (MAX_RANGE/5) );
                            } break;

		                case SB_THUMBTRACK:
                            {
			                    blue = HIWORD(wParam);
                            } break;
                        }

                        change = true;
                        SetDlgItemInt( hDlg, IDC_EDIT3, blue, FALSE);

                    } break;
                }

                if ( change )
                {
                    make_colors();
                    colorNum();
                    InvalidateRect( hDlg, &colorbox, FALSE );
                }

                return TRUE ;
            } break;

    default:
        {
        }
        break;
    }

    return FALSE ;
}

BOOL TrayMessage( HWND hDlg, DWORD dwMessage )
{
    BOOL res;

	NOTIFYICONDATA tnd;

	tnd.cbSize		        = sizeof(NOTIFYICONDATA);
	tnd.hWnd		        = hDlg;
	tnd.uID			        = 0;
	tnd.uFlags		        = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	tnd.uCallbackMessage	= MYWM_NOTIFYICON;
	tnd.hIcon		        = hIcon;

    if ( dwMessage ==  NIM_ADD || dwMessage == NIM_MODIFY )
    {
        strcpy( tnd.szTip, tstring );
    }

	res = Shell_NotifyIcon( dwMessage, &tnd );

    return res;
}


/******************************************************************************/

void inc_timer()
{
    set_title();
}
END_OF_FUNCTION( inc_timer );

int init( HWND hWnd )
{
    win_set_window( hWnd );

    allegro_init();
    install_timer();
    install_keyboard();

    load_config_data();

    MoveWindow( hWnd, xpos, ypos, lpRect.right - lpRect.left, lpRect.bottom - lpRect.top, TRUE );

    if ( install_sound( DIGI_WAVOUTID(1), MIDI_NONE, NULL ) < 0 ) 
    {
        effect = NULL;
        soundon = false;
    }
    else
    {
        soundon = true;
        effect = load_sample( wavfile );
    }

    _tzset();

    get_time();
    set_title();

    depth = desktop_color_depth();

    set_color_depth( depth );
    set_display_switch_mode( SWITCH_BACKGROUND );

    text_mode( -1 );

    buffer = create_bitmap( 208, 64 );
    if ( !buffer )
    {
        allegro_message( "Could not create buffer!" );
        return -1;
    }
    else
    {
        make_colors();            
        clear_to_color( buffer, get_color( 0 ) );
    }

    numbit = create_bitmap( 56, 56 );
    if ( !numbit )
    {
        allegro_message( "Could not create number bitmap!" );
        return -1;
    }
    else
    {
        colorNum();
    }

    LOCK_VARIABLE( timer );
    LOCK_FUNCTION( (void*)inc_timer );
    install_int( inc_timer, 500 );

    return 0;
}

void destroy()
{
    if ( numbit )
    {
        destroy_bitmap( numbit );
    }

    if ( buffer )
    {
        destroy_bitmap( buffer );
    }

    if ( effect )
    {
        destroy_sample( effect );
    }

    save_config_data();

    allegro_exit();

    FILE *pfile = NULL;

    if ( ( pfile = fopen( "alarm.debug", "r" ) ) )
    {
        fclose( pfile );
        MessageBox( hWnd, "Program Closed Normally", "Close Check", MB_ICONINFORMATION );
    }  
}


void loop( HWND hWnd )
{
    if ( key[ KEY_ESC ] )
    {
        done = true;
        SendMessage( hWnd, WM_CLOSE, 0, 0 );
    }

    if ( gettime )
    {
        get_time();
    }

    if ( !editing && alarm )
    {
        if ( ahour == hours && aminute == minutes && seconds == 0 )
        {
            if ( IsIconic( hWnd ) )
            {
                OpenIcon( hWnd );
            }

            ShowWindow( hWnd, SW_RESTORE );
			SetForegroundWindow( hWnd );
            TrayMessage( hWnd, NIM_DELETE );

            buzzer = true;
            
            if ( !playing && playsound && effect )
            {
                play_alarm();
                playing = true;
            }
        }
    }

    Sleep(1);
    yield_timeslice();
}

void load_config_data()
{
    set_config_file( CONFIG_FILE );

    xpos        = get_config_int( "Settings", "xpos", xpos );
    ypos        = get_config_int( "Settings", "ypos", ypos );
    military    = get_config_int( "Settings", "24hour", military );
   
    red         = get_config_int( "Colors", "red", red );
    green       = get_config_int( "Colors", "green", green );
    blue        = get_config_int( "Colors", "blue", blue );

    alarm       = get_config_int( "Alarm", "alarm", alarm );
    strcpy( wavfile, get_config_string( "Alarm", "sound", wavfile ) );
    playsound   = get_config_int( "Alarm", "play", playsound );
    ahour       = get_config_int( "Alarm", "hour", ahour );
    aminute     = get_config_int( "Alarm", "minute", aminute );
    repeating   = get_config_int( "Alarm", "repeat", repeating );
}

void save_config_data()
{
    WINDOWPLACEMENT wp;

    GetWindowPlacement( hWnd, &wp );

    xpos = wp.rcNormalPosition.left;
    ypos = wp.rcNormalPosition.top;

    set_config_int( "Settings", "xpos", xpos );
    set_config_int( "Settings", "ypos", ypos );
    set_config_int( "Settings", "24hour", military );
    
    set_config_int( "Colors", "red", red );
    set_config_int( "Colors", "green", green );
    set_config_int( "Colors", "blue", blue );

    set_config_int( "Alarm", "alarm", alarm );
    set_config_string( "Alarm", "sound", wavfile );
    set_config_int( "Alarm", "play", playsound );
    set_config_int( "Alarm", "hour", ahour );
    set_config_int( "Alarm", "minute", aminute );
    set_config_int( "Alarm", "repeat", repeating );
}

void draw_number( int a, int x, int y )
{
    int c = 0;
    
    for ( int i = 1; i < 255; i *= 2 )
    {      
        if ( i & bitmark[ a ] )
        {
            masked_blit( numbit, buffer, 
                            coords[ c ][ 0 ], coords[ c ][ 1 ], 
                            x + coords[ c ][ 4 ], y + coords[ c ][ 5 ],  
                            coords[ c ][ 2 ], coords[ c ][ 3 ] );
        }

        c++;
    }
}

void draw_dnumber( int a, int x, int y )
{
    int c = 0;
    
    for ( int i = 1; i < 256; i *= 2 )
    {      
        if ( i & bitmark[ a ] )
        {
            masked_blit( numbit, buffer, 
                            coords[ c ][ 0 ] + 28, coords[ c ][ 1 ], 
                            x + coords[ c ][ 4 ], y + coords[ c ][ 5 ],  
                            coords[ c ][ 2 ], coords[ c ][ 3 ] );
        }

        c++;
    }
}

void draw_time()
{
    draw_dnumber( 8,  pos[ 0 ], 0 );
    draw_dnumber( 8,  pos[ 1 ], 0 );
    draw_dnumber( 10, pos[ 2 ], 20 );
    draw_dnumber( 10, pos[ 2 ], 36 );
    draw_dnumber( 8,  pos[ 3 ], 0 );
    draw_dnumber( 8,  pos[ 4 ], 0 );
    draw_dnumber( 10, pos[ 5 ], 52 );

    if ( !military )
    {
        draw_dnumber( 10, pos[ 5 ], 4 );
        textout( buffer, font, "P.M.", pos[ 6 ], 4, get_color( 9 ) );
    }
    
    textout( buffer, font, "Alarm", pos[ 6 ], 52, get_color( 9 ) );

    if ( !buzzer || con )
    {
        if ( military )
        {
            if ( hours / 10 > 0 )
            {
                draw_number( hours / 10, pos[ 0 ], 0 );
            }
            draw_number( hours % 10, pos[ 1 ], 0 );
        }
        else
        {
            if ( hours % 12 == 0 )
            {
                draw_number( 1, pos[ 0 ], 0 );
                draw_number( 2, pos[ 1 ], 0 );
            }
            else
            {
                if ( ( ( hours % 12  ) / 10 ) > 0 )
                {
                    draw_number( ( ( hours % 12  ) / 10 ), pos[ 0 ], 0 );
                }
            
                draw_number( ( hours % 12  ) % 10, pos[ 1 ], 0 );
            }
        }

        if ( con )
        {
            draw_number( 10, pos[ 2 ], 20 );
            draw_number( 10, pos[ 2 ], 36 );
        }

        draw_number( ( minutes % 60  ) / 10, pos[ 3 ], 0 );
        draw_number( ( minutes % 60  ) % 10, pos[ 4 ], 0 );

        if ( !military && hours >= 12 )
        {
            draw_number( 10, pos[ 5 ], 4 );
            textout( buffer, font, "P.M.", pos[ 6 ], 4, get_color( 10 ) );
        }

        if ( alarm )
        {
            draw_number( 10, pos[ 5 ], 52 );

            textout( buffer, font, "Alarm", pos[ 6 ], 52, get_color( 10 ) );
        }
    }
}

void paint( HDC hDC, RECT *lp )
{
    clear_to_color( buffer, get_color( 0 ) );
    
    draw_time();

    stretch_blit_to_hdc( buffer, hDC, 0, 0, 204, 64, 0, 0, 408, 128 );
}

void get_time()
{
    gettime = false;

    time( &ltime );
    
    today = localtime( &ltime );

    minutes = today->tm_min;
    hours = today->tm_hour;
    seconds = today->tm_sec;
}

void set_title()
{
    if ( con )
    {
        con = false;
    }
    else
    {
        con = true;
    }

    if ( count++ %2 == 0 )
    {
        gettime = true;
    }

    if ( !buzzer || con )
    {
        sprintf( tstring, "%s ( %d%c%02d %s)", 
                WINDOW_TITLE, 
                ( military ? hours : hours % 12 ), 
                ( con ? ':' : ' ' ),
                minutes, 
                ( military ? "" : ( hours >= 12 ? "p.m. " : "a.m. " ) ) );
    }
    else
    {
        sprintf( tstring, "%s", WINDOW_TITLE );
    }

    SetWindowText( hWnd, tstring );
    TrayMessage( hWnd, NIM_MODIFY );

    InvalidateRect( hWnd, &lpRect, FALSE );
}

int get_color( int i )
{
    if ( depth == 8 )
    {
        return i;
    }
    else
    {
        if ( makecol( colors[ i ].r, colors[ i ].g, colors[ i ].b ) == makecol( 255, 0, 255 ) )
        {
            return makecol( 255, 3, 255 );
        }
    }

    return makecol( colors[ i ].r, colors[ i ].g, colors[ i ].b );
}


void make_colors()
{
    int r = red;
    int g = green;
    int b = blue;

    colors[ 1 ].r = r; 
    colors[ 1 ].g = g; 
    colors[ 1 ].b = b;
    
    colors[ 2 ].r = ( r * 75 ) / 100; 
    colors[ 2 ].g = ( g * 75 ) / 100; 
    colors[ 2 ].b = ( b * 75 ) / 100;

    colors[ 3 ].r = ( r * 50 ) / 100; 
    colors[ 3 ].g = ( g * 50 ) / 100; 
    colors[ 3 ].b = ( b * 50 ) / 100;

    colors[ 4 ].r = ( r * 25 ) / 100; 
    colors[ 4 ].g = ( g * 25 ) / 100; 
    colors[ 4 ].b = ( b * 25 ) / 100;



    colors[ 5 ].r = ( r * 32 ) / 100; 
    colors[ 5 ].g = ( g * 32 ) / 100; 
    colors[ 5 ].b = ( b * 32 ) / 100;

    colors[ 6 ].r = ( r * 24 ) / 100; 
    colors[ 6 ].g = ( g * 24 ) / 100; 
    colors[ 6 ].b = ( b * 24 ) / 100;

    colors[ 7 ].r = ( r * 16 ) / 100; 
    colors[ 7 ].g = ( g * 16 ) / 100; 
    colors[ 7 ].b = ( b * 16 ) / 100;

    colors[ 8 ].r = ( r *  8 ) / 100; 
    colors[ 8 ].g = ( g *  8 ) / 100; 
    colors[ 8 ].b = ( b *  8 ) / 100;

    if ( depth == 8 )
    {
        PALETTE pal;

        for ( int i = 0; i < MAX_COLOR; i++ )
        {
            pal[ i ].r = colors[ i ].r / 4;
            pal[ i ].g = colors[ i ].g / 4;
            pal[ i ].b = colors[ i ].b / 4;
        }

        for ( int i = MAX_COLOR; i < 255; i++ )
        {
            pal[ i ].r = 0;
            pal[ i ].g = 0;
            pal[ i ].b = 0;
        }

        set_palette( pal );
    }
}

void colorNum()
{
    if ( depth == 8 )
    {
        clear_to_color( numbit, 0 );
    }
    else
    {
        clear_to_color( numbit, makecol( 255, 0, 255 ) );
    }

    for ( int j = 0; j < 56; j++ )
    {
        for ( int i = 0; i < 28; i++ )
        {
            if ( array[ j ][ i ] > 0 )
            {
                putpixel( numbit, i,      j, get_color( array[ j ][ i ]     ) );
                putpixel( numbit, i + 28, j, get_color( array[ j ][ i ] + 4 ) );
            }
        }
    }
}

void stop_alarm()
{
    if ( buzzer )
    {
        buzzer = false;
        if ( playing )
        {
            stop_sample( effect );
            playing = false;
        }
    }
}

void play_alarm()
{
    if ( editing )
    {
        play_sample( effect, 255, 128, 1000, FALSE );
    }
    else
    {
        play_sample( effect, 255, 128, 1000, repeating );
    }
}
