/*

This is a small toy. It allows you to mess around with the screen.
Right now it supports only windows, due to the fact that there's no platform independent
way to get to a screenshot...

The whole project started as a test and then grew into what it is today.
This means the code is less structured than I'd prefer it to be... and if I ever decide
to make this into something "real" I'll clean it up.

What this means is: I don't want to hear any comments on how messed up this code is ;)
If you don't like it, don't read it.

You can do with that code whatever you want, use it for your own projects, etc.
If you want, you can give me some credit, but you don't have to.

Most of the graphics were done by me, so you can use them as well.
The only graphic you can't use freely is the broken glass sprite. That was done by
Johan Peitz (used with permission).

Have fun.

-spellcaster 

http://www.steinke.net/
*/


#define ALLEGRO_STATICLINK 1

#include <allegro.h>
#include <winalleg.h>
#include <stdio.h>
#include <math.h>

#define BAT_W 160
#define BAT_H 120                                                               

#define SABER_W 258
#define SABER_H 245

#define HOLE_X 60
#define HOLE_Y 60

#define LASER_W 173
#define LASER_H 163


#define HOTSPOT_X 140
#define HOTSPOT_Y 32

#define HOTSPOT_SABER_X 168
#define HOTSPOT_SABER_Y 172

#define HOLE_SABER_X 14
#define HOLE_SABER_Y 12

                             

BITMAP *desktopBMP;
HBITMAP hbmp;
HDC     mdc;    

BITMAP *doublebuffer;
BITMAP *bat;
BITMAP *hole;
BITMAP *saber;
BITMAP *saberhole;
BITMAP *laser;
BITMAP *laserHole;                       
BITMAP *pacman;
BITMAP *cherry;
BITMAP *pointer;
BITMAP *pacSpr[3];

#define COUNT_ICONS 5
BITMAP *icons[COUNT_ICONS];
BITMAP *iconCap[2];
BITMAP *iconEnd;

SAMPLE *saberSnd;
SAMPLE *laserSnd;
SAMPLE *glassSnd;
SAMPLE *saberSnd;
SAMPLE *saberOn;
SAMPLE *saberOff;
SAMPLE *mampfSnd;

int weapon, curWeapon;

int batFrames[] = {0,1,2,1,3,4,-1};
int batFrame;

int saberFrames[] = {0, 1, 2, 3, 4, -1};
int saberFrame;

int laserFrames[] = {0, 1, 2, 3, -1};
int laserFrame;

int pacFrames[] = {0, 1, 2, 1, -1};
int pacFrame;

int nextFrame = 0;

/* Timer variable and procedure */
volatile int timerCounter;
void my_timer_handler(void) {
    timerCounter++;
}END_OF_FUNCTION(my_timer_handler);


int weaponSwitch();

BITMAP *loadBitmap(const char* name) {
    char buffer[128];
    sprintf(buffer, "aggression.dat#%s", name);
    return load_bitmap(buffer, NULL);
}

SAMPLE *loadSample(const char* name) {
    char buffer[128];
    sprintf(buffer, "aggression.dat#%s", name);
    return load_sample(name);
}

void blitBat(BITMAP* dst, int x, int y, int frame) {
    masked_blit(bat, dst, frame * BAT_W, 0, x, y, BAT_W, BAT_H);
}

void blitSaber(BITMAP* dst, int x, int y, int frame) {
    masked_blit(saber, dst, frame * SABER_W, 0, x, y, SABER_W, SABER_H);
}

void blitLaser(BITMAP* dst, int x, int y, int frame) {
    masked_blit(laser, dst, frame * LASER_W, 0, x, y, LASER_W, LASER_H);
}

void grabDesktop() {
    HWND    hwnd;
    HDC     ddc;
    RECT    sz;

    hwnd = GetDesktopWindow();
    ddc  = GetDC(hwnd);

    GetWindowRect(hwnd, &sz);

    mdc  = CreateCompatibleDC(ddc);
    hbmp = CreateCompatibleBitmap(ddc, sz.right, sz.bottom);
    SelectObject(mdc, hbmp);
    BitBlt(mdc, 0, 0, sz.right, sz.bottom,  ddc, 0, 0, SRCCOPY);


    ReleaseDC(hwnd, ddc);
}

void convertDesktop() {
    blit_from_hdc(mdc, desktopBMP, 0,0, 0, 0, desktopBMP->w, desktopBMP->h);    
    blit(desktopBMP, screen, 0, 0, 0, 0, screen->w, screen->h);
    DeleteDC(mdc);
    DeleteObject(hbmp);
}

void baseball() {
    int hit = 0;
    while (!key[KEY_ESC]) {
        blit(desktopBMP, doublebuffer, 0, 0, 0, 0, screen->w, screen->h);        
        if (mouse_needs_poll()) {
            poll_mouse();
        }

        if ((mouse_b & 1) && hit == 0) {
            hit = 1;
        }

        if (hit == 1) {
            if (timerCounter > nextFrame) {
                if (batFrames[batFrame+1] != -1) {
                    batFrame++;
                    nextFrame = timerCounter + 5;
                } else if (hit != 2) {
                    play_sample(glassSnd, 255, (mouse_x * 250) / doublebuffer->w+3, 1000, 0);
                    /* "damage" the screen; */
                    rotate_sprite(desktopBMP, hole, mouse_x - HOLE_X, mouse_y - HOLE_Y, itofix(rand() % 255));                    
                    hit = 2;
                }
            }
        } else {
            batFrame = 0;
            hit = 0;
        }
        blitBat(doublebuffer, mouse_x-HOTSPOT_X, mouse_y-HOTSPOT_Y, batFrames[batFrame]);
        blit(doublebuffer, screen, 0, 0, 0, 0, screen->w, screen->h);

        weapon = weaponSwitch();
        if (weapon != curWeapon && weapon >= 0) {
            curWeapon = weapon;
            return;
        }
    }
    
    curWeapon = -1;
}

void saberLine(BITMAP *buf, int x, int y, int d) {
    draw_sprite(desktopBMP, saberhole, x - HOLE_SABER_X, y - HOLE_SABER_Y);
}

void saberRoutine() {
    int hit=0;
    int px[100];
    int py[100];
    int dx[100];
    int dy[100];
    int count = 0,a;
    int lx=-1, ly=-1;
    int voice = -1;
    int pos = 0;

    while (!key[KEY_ESC]) {
        blit(desktopBMP, doublebuffer, 0, 0, 0, 0, screen->w, screen->h);        
        if (mouse_needs_poll()) {
            poll_mouse();
        }
    
        if (mouse_b & 1) {
            hit = 1;         
            if (voice ==-1 || (voice > 0 && voice_get_position(voice) >=0)) {
                voice = play_sample(saberSnd, 255, (mouse_x*250)/doublebuffer->w+3, 1000, 0);
            }            
        } else {
            hit = 0;
            lx = -1;
            ly = -1;
        }
    
        if (hit == 1) {
            if (timerCounter > nextFrame) {
                if (saberFrames[saberFrame+1] != -1) {
                    saberFrame++;
                    nextFrame = timerCounter + 1;

                    if (saberFrame == 1 && lx <0) {
                        lx = mouse_x;
                        ly = mouse_y;
                    }
                    if (saberFrame > 1) {
                        do_line(doublebuffer, lx, ly, mouse_x, mouse_y, 0, saberLine);
                        lx = mouse_x;
                        ly = mouse_y;
                    }
                } else {
                    

                    /* "damage" the screen; */
                    do_line(doublebuffer, lx, ly, mouse_x, mouse_y, 0, saberLine);
                    pos =voice_get_position(voice);
                    if (pos ==-1) {
                        if (ABS(mouse_x - lx) > 5 || ABS(mouse_y - ly)) {
                            voice = play_sample(saberSnd, 255, (mouse_x*250)/doublebuffer->w+3, 1000, 0);
                        }                        
                    } else {
                        if (ABS(mouse_x - lx) > 5 || ABS(mouse_y - ly)) {
                            voice_set_pan(voice, (mouse_x*250)/doublebuffer->w+3);
                            voice_set_position(voice, pos);
                        }
                    }
                    lx = mouse_x;
                    ly = mouse_y;
                }
            }
        } else {
            saberFrame = 0;
            hit = 0;
            if (count > 0) {
                count--;
            }
            if (voice_get_position(voice) ==-1) {
                voice = -1;
            }
        }
        for (a=0; a < count; a++) {
            circlefill(doublebuffer, px[a], py[a], 2, makecol(0,156,0));
            px[a]+=dx[a];
            py[a]+=dy[a];
            dy[a]++;

            if (hit > 0 && (px[a] < 0 || px[a] > SCREEN_W || py[a] < 0 || py[a] > SCREEN_H)) {
                px[a] = mouse_x + rand()%20-10;
                py[a] = mouse_y + rand()%20-10;
    
                dx[a] = rand()%20-10;
                dy[a] = rand()%20-10;
    
                while (dx[a] == 0) {
                     dx[a]++;
                }
                while (dy[a] == 0) {
                    dy[a]++;
                }
            }
        }
        if (hit == 1 && count < 50) {
            px[count] = mouse_x + rand()%20-10;
            py[count] = mouse_y + rand()%20-10;

            dx[count] = rand()%20-10;
            dy[count] = rand()%20-10;

            if (dx[count] == 0) {
                dx[count] = rand()%10-5;
            }
            if (dy[count] == 0) {
                dy[count] = rand()%10-5;
            }
            count++;
        }
        blitSaber(doublebuffer, mouse_x-HOTSPOT_SABER_X, mouse_y-HOTSPOT_SABER_Y, saberFrames[saberFrame]);
        blit(doublebuffer, screen, 0, 0, 0, 0, screen->w, screen->h);

        weapon = weaponSwitch();
        if (weapon != curWeapon && weapon >= 0) {
            curWeapon = weapon;
            return;
        }
    
    }

    curWeapon = -1;
}


void laserRoutine() {
    int hit=0;
    int px[100];
    int py[100];
    int dx[100];
    int dy[100];
    int count = 0,a,b;
    int anim = 0;

    while (!key[KEY_ESC]) {
        blit(desktopBMP, doublebuffer, 0, 0, 0, 0, screen->w, screen->h);        
        
        if (mouse_needs_poll()) {
            poll_mouse();
        }
    
        if (mouse_b & 1) {
            if (hit == 0) {
                position_mouse(mouse_x+rand()%7, mouse_y+rand()%7);
                play_sample(laserSnd, 255, (mouse_x *250)/doublebuffer->w +3, 1000, 0);
                anim = 1;
            }
            hit = 1;            
        } else {
            hit = 0;
        }
    
        if (anim == 1) {
            if (timerCounter > nextFrame) {
                if (laserFrames[laserFrame+1] != -1) {
                    laserFrame++;
                    nextFrame = timerCounter + 5;
                } else {
                    rotate_sprite(desktopBMP, laserHole, mouse_x-14, mouse_y-14, itofix(rand()%255));
                    anim=0;
                }
            }
        } else {
            laserFrame = 0;
            hit = 0;
            if (count > 0) {
                count--;
            }
        }

        for (a=0; a < count; a++) {
            circlefill(doublebuffer, px[a], py[a], 1, makecol(200,16,10));
            px[a]+=dx[a];
            py[a]+=dy[a];
            dy[a]++;

            if (hit > 0 && (px[a] < 0 || px[a] > SCREEN_W || py[a] < 0 || py[a] > SCREEN_H)) {
                px[a] = mouse_x +  rand()%20-10;
                py[a] = mouse_y +  rand()%20-10;
    
                dx[a] = rand()%40-10;
                dy[a] = rand()%20-20;
    
                while (dx[a] == 0) {
                     dx[a]++;
                }
                while (dy[a] == 0) {
                    dy[a]++;
                }
            }
        }
        if (hit == 1 && count < 50) {

            for (b=0; b < 10 && count < 50; b++) {
                px[count] = mouse_x +  rand()%40-10;
                py[count] = mouse_y +  rand()%40-10;
    
                dx[count] = rand()%20-10;
                dy[count] = rand()%20-10;
    
                if (dx[count] == 0) {
                    dx[count] = rand()%10-5;
                }
                if (dy[count] == 0) {
                    dy[count] = rand()%10-5;
                }
                count++;
            }
        }
        blitLaser(doublebuffer, mouse_x, mouse_y, laserFrames[laserFrame]);
        blit(doublebuffer, screen, 0, 0, 0, 0, screen->w, screen->h);

        weapon = weaponSwitch();
        if (weapon != curWeapon && weapon >= 0) {
            curWeapon = weapon;
            return;
        }
    
    }

    curWeapon = -1;
}

void pacmanRoutine() {

    #define CHERRY_COUNT 8
    int pacX=0, pacY=0;

    int mouseDown = 0;

    float x = 0;
    float y = 0;
    float dx, dy;
    float dist;

    int angle   = 0;

    int targetX = rand() % SCREEN_W;
    int targetY = rand() % SCREEN_H;

    
    dx   = (targetX - x);
    dy   = (targetY - y);
    dist = sqrt(dx*dx+dy*dy);
    dist *= 0.25;
    dx /= dist;
    dy /= dist;
    angle = fixatan2(ftofix(dy), ftofix(dx));

    play_sample(mampfSnd, 256, MID(0, ((int)x*250)/SCREEN_W+3, 255), 1000, 1);
    while (!key[KEY_ESC]) {
        blit(desktopBMP, doublebuffer, 0, 0, 0, 0, screen->w, screen->h);        

        if (timerCounter > nextFrame) {
            if (pacFrames[pacFrame+1] != -1) {
                pacFrame++;
                nextFrame = timerCounter + 5;
            } else {
                pacFrame = 0;
            }
            x+=dx;
            y+=dy;
            adjust_sample(mampfSnd, 256, MID(0, ((int)x*250)/SCREEN_W+3, 255), 1000, 1);

            if (x > SCREEN_W || x < 0 || y > SCREEN_H || y < 0) {
                targetX = rand() % SCREEN_W;
                targetY = rand() % SCREEN_H;
            
                dx   = (targetX - x);
                dy   = (targetY - y);
                dist = sqrt(dx*dx+dy*dy);
                dist *= 0.25;
                dx /= dist;
                dy /= dist;
                angle = fixatan2(ftofix(dy), ftofix(dx));
            }
        } else {
        }

        if (mouse_b & 1) {
            if (!mouseDown) {
                mouseDown = TRUE;

                targetX = mouse_x;
                targetY = mouse_y;

                dx   = (targetX - x);
                dy   = (targetY - y);
                dist = sqrt(dx*dx+dy*dy);
                dist *= 0.25;
                dx /= dist;
                dy /= dist;
                angle = fixatan2(ftofix(dy), ftofix(dx));
            }            
        } else {
            mouseDown = FALSE;
        }
        

        circlefill(desktopBMP, x+13, y+13, 13, 0);
        rotate_sprite(doublebuffer, pacSpr[pacFrames[pacFrame]], x, y, angle);
        draw_sprite(doublebuffer, pointer, mouse_x, mouse_y);
        blit(doublebuffer, screen, 0, 0, 0, 0, screen->w, screen->h);

        weapon = weaponSwitch();
        if (weapon != curWeapon && weapon >= 0) {
            curWeapon = weapon;
            stop_sample(mampfSnd);
            return;
        }
    }
    stop_sample(mampfSnd);
    curWeapon = -1;
}

int weaponSwitch() {
    if (key[KEY_1]) {
        return 0;
    } else if (key[KEY_2]) {
        return 1;
    } else if (key[KEY_3]) {
        return 2;
    } else if (key[KEY_4]) {
        return 3;
    }

    return -1;
}

int menuRoutine() {    
    int menuX  = (SCREEN_W - (icons[0]->w   * COUNT_ICONS)) /2;
    int menuY  = (SCREEN_H - icons[0]->h)/2 - icons[0]->h;
    int startX = menuX - iconCap[0]->w;
    int w      = (icons[0]->w   * COUNT_ICONS) + iconCap[0]->w*2;
    int h      = icons[0]->h;
    int x;
    int a;
    int result = -1;
    int selected = -1;
    int mouseDown = 0;
    
    timerCounter = 0;
    
    show_mouse(NULL);
    if (bitmap_color_depth(doublebuffer) > 8) {
        blit(desktopBMP, screen, 0, 0, 0, 0, screen->w, screen->h);        
        while (timerCounter < 150) {
            set_trans_blender(0,0,0, (int)(timerCounter*1.7));        
            x = startX;
            draw_trans_sprite(doublebuffer, iconCap[0], x, menuY);
            x= menuX;
            for (a=0; a < COUNT_ICONS; a++) {
                draw_trans_sprite(doublebuffer, icons[a], x, menuY);
                x+=icons[a]->w;
            }
            draw_trans_sprite(doublebuffer, iconCap[1], x, menuY);
            
            blit(doublebuffer, screen, startX, menuY, startX, menuY, w, h);
        }
    }
    
    
    while (!key[KEY_ESC]) {
        scare_mouse();
        blit(desktopBMP, doublebuffer, 0, 0, 0, 0, screen->w, screen->h);        
        if (mouse_needs_poll()) {
            poll_mouse();
        }
        
        if (!mouseDown && (mouse_b & 1)) {
            mouseDown = 1;
            if (mouse_x > menuX && mouse_x < menuX+w && mouse_y > menuY && mouse_y < menuY+h)  {
                selected = (mouse_x - menuX) / icons[0]->w;                
            }
        }
        if (mouseDown && !(mouse_b & 1)) {
            mouseDown = 0;            
            if (mouse_x > menuX && mouse_x < menuX+w && mouse_y > menuY && mouse_y < menuY+h)  {
                if (selected == (mouse_x - menuX) / icons[0]->w) {
                    if (selected < COUNT_ICONS-1) {
                        result = selected;
                    }                    
                    break;
                }
            }
            selected = -1;
        }
        
        x = startX;
        draw_sprite(doublebuffer, iconCap[0], x, menuY);
        x= menuX;
        for (a=0; a < COUNT_ICONS; a++) {
            draw_sprite(doublebuffer, icons[a], x, menuY);
            if (a==selected) {
                rect(doublebuffer, x+3, menuY+4, x+icons[0]->w-6, menuY+icons[0]->h-6, makecol(0,0,64));
            }
            x+=icons[a]->w;
        }
        draw_sprite(doublebuffer, iconCap[1], x, menuY);
        draw_sprite(doublebuffer, mouse_sprite, mouse_x, mouse_y);
        blit(doublebuffer, screen, 0, 0, 0, 0, screen->w, screen->h);        
    }    
    
    return result;
}

void loadIcons() {
    char buffer[32];
    int  a;
    
    for (a=0; a < COUNT_ICONS-1; a++) {
        sprintf(buffer, "icon%02i.tga", a);
        icons[a] = loadBitmap(buffer);
    }
    icons[a] = loadBitmap("iconend.tga");
    iconCap[0] = loadBitmap("cap.tga");
    iconCap[1] = create_bitmap(iconCap[0]->w, iconCap[0]->h);    
    
    draw_sprite_h_flip(iconCap[1], iconCap[0], 0, 0);
}


int main (int argc, char *argv[]) {
    
    int w,h;
    int hit = 0;
    int a;
    int lastMode=0;

    grabDesktop();    
    allegro_init();
    get_desktop_resolution(&w, &h);
    set_color_depth(desktop_color_depth());
    set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,w,h,0, 0);

    set_mouse_speed(4,4);

    
    desktopBMP = create_bitmap(w,h);
    convertDesktop();
    doublebuffer = create_bitmap(w,h);

    install_timer();
    install_mouse();
    install_keyboard();
    install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

    LOCK_VARIABLE(timerCounter);
    LOCK_FUNCTION(my_timer_handler);
    install_int(my_timer_handler, 10);

    bat       = loadBitmap("bat.tga");
    hole      = loadBitmap("crack.tga");
    saber     = loadBitmap("saber.tga");
    saberhole = loadBitmap("saberhole.tga");
    laser     = loadBitmap("laser.tga");
    laserHole = loadBitmap("laserhole.tga");
    pacman    = loadBitmap("lady.tga");
    cherry    = loadBitmap("cherry.tga");
    pointer   = loadBitmap("pointer.tga");

    for (a=0; a < 3; a++) {
        pacSpr[a] = create_sub_bitmap(pacman, a*29, 0, 29, 29);
    }
    loadIcons();

    laserSnd = loadSample("laser.wav");
    glassSnd = loadSample("glass.wav");
    saberSnd = loadSample("lightsaber.wav");
    saberOn  = loadSample("saber0.wav");
    saberOff = loadSample("saberout.wav");
    mampfSnd = loadSample("mampf.wav");

    
    curWeapon = menuRoutine();
    while (curWeapon >=0) {
        while (curWeapon >=0) {
            switch (curWeapon) {
                case 0: baseball();      break;
                case 1: saberRoutine();  break;
                case 2: laserRoutine();  break;
                case 3: pacmanRoutine(); break;
            }
            if (lastMode != curWeapon) {
                if (lastMode == 1) {
                    play_sample(saberOff, 255, (mouse_x*250)/doublebuffer->w+3,1000,0);
                } else if (curWeapon == 1) {
                    play_sample(saberOn, 255, (mouse_x*250)/doublebuffer->w+3,1000,0);
                }
            }
            lastMode = curWeapon;
        }
        curWeapon = menuRoutine();
    }
    
    //pacmanRoutine();

    destroy_bitmap(desktopBMP);
    destroy_bitmap(doublebuffer);
    destroy_bitmap(bat);
    destroy_bitmap(hole);
    destroy_bitmap(saber);
    destroy_bitmap(saberhole);
    destroy_bitmap(laser);
    destroy_bitmap(laserHole);
    destroy_bitmap(pacman);
    destroy_bitmap(cherry);
    destroy_bitmap(pointer);
    for (a=0; a < 3; a++) {
        destroy_bitmap(pacSpr[a]);
    }
    for (a=0; a < COUNT_ICONS; a++) {
        destroy_bitmap(icons[a]);
    }
    destroy_bitmap(iconCap[0]);
    destroy_bitmap(iconCap[1]);
    
    destroy_sample(laserSnd);
    destroy_sample(glassSnd);
    destroy_sample(saberSnd);
    destroy_sample(saberOn);
    destroy_sample(saberOff);
    destroy_sample(mampfSnd);


    return(0);
}
END_OF_MAIN();



int test_pan_main (int argc, char *argv[]) {
    
    int w, h;
    int pressMono   = 0;
    int pressStereo = 0;
    int pan   = 0;

    SAMPLE *mono;
    SAMPLE *stereo;

    allegro_init();
    get_desktop_resolution(&w, &h);
    set_color_depth(desktop_color_depth());
    set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,w,h,0, 0);

    set_mouse_speed(4,4);

    install_timer();
    install_mouse();
    install_keyboard();
    //install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
    install_sound(DIGI_DIRECTAMX(0), MIDI_NONE, NULL);


    mono   = loadSample("lasermono.wav");
    stereo = loadSample("laser.wav");

    show_mouse(screen);
    while (!key[KEY_ESC]) {
        if (mouse_needs_poll()) {
            poll_mouse();
        }
        if (mouse_b & 1) {
            if (pressMono == 0) {
                pressMono = 1;
                pan   = (mouse_x *250) / SCREEN_W +3;
                play_sample(mono, 255, pan, 1000, 0);
            }         
        } else {
            pressMono = 0;
        }
        if (mouse_b & 2) {
            if (pressStereo == 0) {
                pressStereo = 1;
                pan   = (mouse_x *250) / SCREEN_W +3;
                play_sample(stereo, 255, pan, 1000, 0);
            }         
        } else {
            pressStereo = 0;
        }
        textprintf(screen, font, 10 , 10, -1, "Pan: %i     ", pan);
    }

    destroy_sample(mono);
    destroy_sample(stereo);
    return(0);
}

  
