#ifndef _VECTOR_H_
#define _VECTOR_H_

#ifndef RAD
#define RAD 57.295779513082320900
#endif

//57,295779513082320900

class Angle
{
public:
	double val;
	Angle(){val = 0;}
	Angle(double v){val = v;}
	Angle operator+(double v);
	Angle operator-(double v);
	Angle & operator+=(double v);
	Angle & operator-=(double v);
	Angle & operator=(double v);
	Angle operator-();
	bool operator<(Angle a);
	bool operator>(Angle a);
	double operator>>(Angle a);
};
Angle operator+(double v,Angle a);
Angle operator-(double v,Angle a);
Angle calcang(double x2, double y2, double x1, double y1);

class PolarVector;

class Vector
{
public:
//	double v[4];
        double x, y;
	Vector();
	Vector(double tx, double ty);
//	Vector(double x, double y, double s);
//	Vector(double x, double y, double s, double w);
	PolarVector pol();
	double mag();
	Angle ang();
//	double x();
//	double y();
//	Vector & x(double x);
//	Vector & y(double y);
	Vector operator+(const Vector & vect);
	Vector operator-(const Vector & vect);
	Vector operator-();
	Vector operator*(double val);
	Vector operator/(double val);
	Vector & operator*=(double val);
	Vector & operator/=(double val);
};

Vector operator*(double val, const Vector & vect);

class PolarVector
{
public:
	double mag;
	Angle ang;
	PolarVector() {}
	PolarVector(double m, double a);
	Vector rec();
	double x();
	double y();
	PolarVector operator*(double val);
	PolarVector operator/(double val);
	PolarVector & operator*=(double val);
	PolarVector & operator/=(double val);
	PolarVector operator-();
	PolarVector project(Angle a);
};
PolarVector operator*(double val, const PolarVector & vect);
PolarVector operator/(double val, const PolarVector & vect);
Angle calcang(double x2, double y2, double x1, double y1);

#endif
