#include <math.h>
#include "vector.h"

//////////////////////////////////////////////////
//**************ANGLE CLASS*********************//
//////////////////////////////////////////////////

Angle calcang(double x2, double y2, double x1, double y1)
{
   if(y1 == y2 && x1 >= x2) return 0;
   if(y1 == y2)             return 180;
   if(x1 == x2 && y1 >  y2) return 90;
   if(x1 == x2)             return 270;

   if(x1 > x2 && y1 > y2) return atan((y1-y2)/(x1-x2)) * RAD;
   if(x1 < x2 && y1 > y2) return atan((x2-x1)/(y1-y2)) * RAD + 90;
   if(x1 > x2 && y1 < y2) return atan((y1-y2)/(x1-x2)) * RAD + 360;
                          return atan((x2-x1)/(y1-y2)) * RAD + 270;
}

Angle Angle::operator+(double v)
{
	Angle a;
	a.val = v + val;
	while(a.val>360) a.val-=360;
	while(a.val<0) a.val+=360;
	return a;
}
Angle Angle::operator-(double v)
{
	Angle a;
	a.val = val - v;
	while(a.val>360) a.val-=360;
	while(a.val<0) a.val+=360;
	return a;
}
Angle & Angle::operator+=(double v)
{
	val += v;
	while(val>360) val-=360;
	while(val<0) val+=360;
	return *this;
}
Angle & Angle::operator-=(double v)
{
	val -= v;
	while(val>360) val-=360;
	while(val<0) val+=360;
	return *this;
}
Angle & Angle::operator=(double v)
{
	val = v;
	return *this;
}
Angle Angle::operator-()
{
	Angle a;
	a = *this + 180;
	return a;
}
bool Angle::operator<(Angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return true;
	else return false;
}
bool Angle::operator>(Angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return false;
	else return true;
}
double Angle::operator>>(Angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return tr;
	else return -tl;
}

Angle operator+(double v,Angle a)
{
	return a + v;
}
Angle operator-(double v,Angle a)
{
	Angle t;
	t.val = v- a.val;
	if(t.val<0) t.val+=360;
	return a;
}

//////////////////////////////////////////////////////
//###############RECTANGULAR VECTOR#################//
//////////////////////////////////////////////////////

Vector::Vector()
{
        x = 0;
        y = 0;
//        v[0] = 0;
//        v[1] = 0;
//	v[2] = 1;
//	v[3] = 1;
}
Vector::Vector(double tx, double ty)
{
	x = tx;
	y = ty;
//	v[0] = x;
//	v[1] = y;
//	v[2] = 1;
//	v[3] = 1;
}
/*Vector::Vector(double x, double y, double s)
{
	v[0] = x;
	v[1] = y;
	v[2] = s;
	v[3] = 1;
}
Vector::Vector(double x, double y, double s, double w)
{
	v[0] = x;
	v[1] = y;
	v[2] = s;
	v[3] = w;
}*/
PolarVector Vector::pol()
{
        return PolarVector(mag(), ang().val);
}
double Vector::mag()
{
	return sqrt((x*x)+(y*y));
}
Angle Vector::ang()
{
//	if(v[1] == 0 && v[0] >=0) return 0;
//	if(v[1] == 0)		  return 180;
//	if(v[0] == 0 && v[1] > 0) return 90;
//	if(v[0] == 0)		  return 270;

//	if(v[0] > 0 && v[1] > 0) return atan( v[1] / v[0]) * RAD;
//	if(v[0] < 0 && v[1] > 0) return atan(-v[0] / v[1]) * RAD + 90;
//	if(v[0] > 0 && v[1] < 0) return atan( v[1] / v[0]) * RAD + 360;
//				 return atan(-v[0] / v[1]) * RAD + 270;
	if(y == 0 && y >=0) return 0;
	if(y == 0)		  return 180;
	if(x == 0 && y > 0) return 90;
	if(x == 0)		  return 270;

	if(x > 0 && y > 0) return atan( y / x) * RAD;
	if(x < 0 && y > 0) return atan(-x / y) * RAD + 90;
	if(x > 0 && y < 0) return atan( y / x) * RAD + 360;
				 return atan(-x / y) * RAD + 270;
}
/*double Vector::x()
{
	return v[0];
}
double Vector::y()
{
	return v[1];
}
Vector & Vector::x(double x)
{
	v[0] = x;
	return * this;
}
Vector & Vector::y(double y)
{
	v[1] = y;
	return * this;
}
 */
Vector Vector::operator+(const Vector & vect)
{
	Vector t;
//	t.v[0] = v[0] + vect.v[0];
//	t.v[1] = v[1] + vect.v[1];
	t.x = x + vect.x;
	t.y = y + vect.y;
	return t;
}
Vector Vector::operator-(const Vector & vect)
{
	Vector t;
//	t.v[0] = v[0] - vect.v[0];
//	t.v[1] = v[1] - vect.v[1];
	t.x = x - vect.x;
	t.y = y - vect.y;
	return t;
}
Vector Vector::operator-()
{
	Vector t;
//	t.v[0] = -this->v[0];
//	t.v[1] = -this->v[1];
	t.x = -this->x;
	t.y = -this->y;
	return t;
}
Vector Vector::operator*(double val)
{
	Vector t;
//	t.v[0] = v[0] * val;
//	t.v[1] = v[1] * val;
	t.x = x * val;
	t.y = y * val;
	return t;
}
Vector Vector::operator/(double val)
{
	Vector t;
//	t.v[0] = v[0] / val;
//	t.v[1] = v[1] / val;
	t.x = x / val;
	t.y = y / val;
	return t;
}
Vector & Vector::operator*=(double val)
{
	x *= val;
	y *= val;
	return *this;
}
Vector & Vector::operator/=(double val)
{
	x /= val;
	y /= val;
	return *this;
}

Vector operator*(double val, Vector & vect)
{
	return vect * val;
}

///////////////////////////////////////////////
//###############POLAR VECTOR################//
///////////////////////////////////////////////

PolarVector::PolarVector(double m, double a)
{
	mag = m;
	ang = a;
}
Vector PolarVector::rec()
{
	Vector t;
//	t.v[0] = cos(ang.val / RAD) * mag;
//	t.v[1] = sin(ang.val / RAD) * mag;
//	t.v[2] = 1;
//	t.v[3] = 1;
	t.x = cos(ang.val / RAD) * mag;
	t.y = sin(ang.val / RAD) * mag;
	return t;
}
double PolarVector::x()
{
	return cos(ang.val / RAD) * mag;
}
double PolarVector::y()
{
	return sin(ang.val / RAD) * mag;
}
PolarVector PolarVector::operator*(double val)
{
	PolarVector t;
	t.mag = mag * val;
	return t;
}
PolarVector PolarVector::operator/(double val)
{
	PolarVector t;
	t.mag = mag / val;
	return t;
}
PolarVector & PolarVector::operator*=(double val)
{
	mag /= val;
	return *this;
}
PolarVector & PolarVector::operator/=(double val)
{
	mag /= val;
	return *this;
}
PolarVector PolarVector::operator-()
{
	PolarVector t;
	t.ang = ang + 180;
	return t;
}
PolarVector PolarVector::project(Angle a)
{
        PolarVector t;
        double gap = (ang>>a);
        if(gap> 90) gap -= 180;
        if(gap<-90) gap += 180;
        t.ang = ang + gap;
        t.mag = mag*cos(gap/RAD);
        return t;
}
PolarVector operator*(double val, PolarVector & vect)
{
	return vect * val;
}
PolarVector operator/(double val, PolarVector & vect)
{
	return vect / val;
}

