#include <math.h>
#include "main.h"
#include "vector.h"
#include "allegro.h"
#include "fblend.h"
#include "object.h"

extern BITMAP *buffer;
extern particle_data particle[MAX_PARTICLES];
extern BITMAP *p0,*p1,*p2,**p3;
extern double zoom, viewx, viewy;
extern int time_mul;
extern Ship ship2;
int last_particle = -1;
int tp;

void draw_particles()
{
//   set_add_blender(255,255,255,255);
   for(int i = 0; i < last_particle+1; i++)
      if(particle[i].free == false)
      {
         if(particle[i].type == 0)
//            draw_trans_sprite(buffer, p0, int((particle[i].x-viewx)*zoom+.5)-int(6*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(6*zoom+.5)+SCREEN_H/2);
            fblend_add(p0, buffer, int((particle[i].x-viewx)*zoom+.5)-int(6*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(6*zoom+.5)+SCREEN_H/2,255);
         if(particle[i].type == 1)
//            draw_trans_sprite(buffer, p1, int((particle[i].x-viewx)*zoom+.5)-int(13*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(13*zoom+.5)+SCREEN_H/2);
            fblend_add(p1, buffer, int((particle[i].x-viewx)*zoom+.5)-int(13*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(13*zoom+.5)+SCREEN_H/2,255);
         if(particle[i].type == 2)
//            draw_trans_sprite(buffer, p2, int((particle[i].x-viewx)*zoom+.5)-int(16*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(16*zoom+.5)+SCREEN_H/2);
            fblend_add(p2, buffer, int((particle[i].x-viewx)*zoom+.5)-int(16*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(16*zoom+.5)+SCREEN_H/2,255);
         if(particle[i].type == 3)
//            draw_trans_sprite(buffer, p3[rand()%5], int((particle[i].x-viewx)*zoom+.5)-int(15*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(15*zoom+.5)+SCREEN_H/2);
            fblend_add(p3[rand()%5], buffer, int((particle[i].x-viewx)*zoom+.5)-int(15*zoom+.5)+SCREEN_W/2,int((particle[i].y-viewy)*zoom+.5)-int(15*zoom+.5)+SCREEN_H/2,255);
      }
}
void move_particles()
{
   for(int i = 0; i < last_particle+1; i++)
      if(particle[i].free == false)
      {
         particle[i].x += particle[i].vel.x * time_mul;
         particle[i].y += particle[i].vel.y * time_mul;
         particle[i].life -= time_mul;
         if(particle[i].life <= 0)
            particle[i].free = true;
         else
            tp = i;
         if(particle[i].type == 3)
         {
            if(ship2.point_collision(particle[i].x-ship2.x,particle[i].y-ship2.y))
            {
               for(int j = 0; j < 15; j++)
                  create_particle(1, particle[i].x, particle[i].y, ship2.velocity , PolarVector(RND*RND*3,RND*360), 30);
               particle[i].free = true;
            }
         }
      }
   last_particle = tp;
}
void create_particle(int type, double x, double y,Vector ship_velocity, PolarVector velocity, int life)
{
   for(int i = 0; i < MAX_PARTICLES; i++)
      if(particle[i].free)
      {
         particle[i].type = type;
         particle[i].x = x;
         particle[i].y = y;
         particle[i].vel.x = velocity.x() + ship_velocity.x;
         particle[i].vel.y = velocity.y() + ship_velocity.y;
         particle[i].life = life;
         particle[i].free = false;
         if(i > last_particle)
            last_particle = i;
         break;
      }
}

