#ifndef _OBJECT_H_
#define _OBJECT_H_

#include <allegro.h>

class Weapon
{
public:
   int type;
   int x_diff;
   int y_diff;
   Angle angle;
   int load;

   int heat;
   int power;
   int energy;
   int rapidity;
   int condition;
   int quality;
};

class Motor
{
public:
   int type;
   int x_diff;
   int y_diff;

   int power;
   int energy;
   int condition;
   int quality;
   char name[30];
};

class Item
{
public:
   int type;
   int energy;
   int condition;
   int quality;
};

class Object
{
public:
   double x;
   double y;
   int height;
   int width;
   BITMAP * bmp;
   char ** mask;
   void calc_mask();
   bool point_collision(int dx, int dy);
   bool pix_point_collision(int dx, int dy, double ang);
   bool collision(Object &other);
   bool pix_collision(Object &other);
   int rad;
   void init();
};

class Ship : public Object
{
public:
   // ship characteristics
   int type;
   double accel;
   double angle_accel;
   int items;
   Item * item;

   int weapons;
   Weapon * weapon;
   int weapon_x(int index);
   int weapon_y(int index);

   int motors;
   Motor * motor;
   int motor_x(int index);
   int motor_y(int index);

   // ship state
   Angle angle;
   Vector velocity;
   double angle_speed;
   
   // guiding computer
   double max_accel;
   double max_angle_accel;
   double max_angle_speed;
   double max_speed;
   bool auto_pilot;
   double dest_x;
   double dest_y;
   
   // controls
   bool left_flag;
   bool right_flag;
   bool up_flag;
   bool down_flag;
   bool shoot_flag;

   // the AI
   bool ai;
   bool under_attack;

   // class generals
   void specs(int w_items, int w_weapons, int w_motors);
   Ship();
   Ship(int w_items, int w_weapons, int w_motors);
   ~Ship();
   Ship & operator=(Ship & source);
};

class Planet : public Object
{
public:
   char * name;
   double distance;
   Angle start;
   int speed;
   int moons;
   Planet * moon;
   void calc_xy();
   Planet();
   ~Planet();
};

class Star : public Object
{
public:
   char * name;
   int planets;
   Planet * planet;
   void calc_xy();
   Star();
   ~Star();
};

#endif
