#include <math.h>
#include "allegro.h"
#include "vector.h"
#include "object.h"

void Object::calc_mask()
{
   mask = new char*[int(double(width)/8+0.875)];
   for(int i = 0; i < int(double(width)/8+0.875); i++)
      mask[i] = new char[height];

   for(int tx = 0; tx < int(double(width)/8+0.875); tx++)
      for(int ty = 0; ty < height; ty++)
         mask[tx][ty] = 0;
   for(int tx = 0; tx < width; tx++)
      for(int ty = 0; ty < height; ty++)
         if(getpixel(bmp, tx, ty) != makecol(255,0,255))
            mask[tx/8][ty] |= 1 << (tx % 8);
}
bool Object::pix_point_collision(int dx, int dy, double ang)
{
   int tx = int(dx * cos(ang / RAD) + dy * sin(ang / RAD)+.5);
       dy = int(dx * sin(ang / RAD) - dy * cos(ang / RAD)+.5);
   if(abs(tx)+1 <= width/2 && abs(dy)+1 <= height/2)
      if(mask[(width/2+tx)/8][height/2+dy] & (1 << ((width/2+tx) % 8)))
         return true;
   return false;
}
bool Object::point_collision(int dx, int dy)
{
   if(abs(dx) <= rad && abs(dy) <= rad)
      if(sqrt(dx*dx+dy*dy) <= rad)
         return true;
   return false;
}
bool Object::collision(Object &other)
{
   double dx = fabs(x-other.x);
   double dy = fabs(y-other.y);
   if(dx <= rad+other.rad && dy <= rad+other.rad)
      if(sqrt(dx*dx+dy*dy) <= rad+other.rad)
         return true;
   return false;
}
bool Object::pix_collision(Object &other)
{
   return false;
}
void Object::init()
{
   width = bmp->w;
   height = bmp->h;
   rad = int(sqrt(bmp->w*bmp->w+bmp->h*bmp->h)/2+1);
}

int Ship::weapon_x(int index)
{
   return int(weapon[index].x_diff * cos(angle.val / RAD) + weapon[index].y_diff * sin(angle.val / RAD)+.5);
}
int Ship::weapon_y(int index)
{
   return int(weapon[index].x_diff * sin(angle.val / RAD) - weapon[index].y_diff * cos(angle.val / RAD)+.5);
}
int Ship::motor_x(int index)
{
   return int(motor[index].x_diff * cos(angle.val / RAD) + motor[index].y_diff * sin(angle.val / RAD)+.5);
}
int Ship::motor_y(int index)
{
   return int(motor[index].x_diff * sin(angle.val / RAD) - motor[index].y_diff * cos(angle.val / RAD)+.5);
}
void Ship::specs(int w_items, int w_weapons, int w_motors)
{
   delete [] item;
   delete [] weapon;
   delete [] motor;

   items = w_items;
   item = new Item[w_items];
   weapons = w_weapons;
   weapon = new Weapon[w_weapons];
   motors = w_motors;
   motor = new Motor[w_motors];
}
Ship::Ship()
{
   items = 1;
   item = new Item[1];
   weapons = 1;
   weapon = new Weapon[1];
   motors = 1;
   motor = new Motor[1];
}
Ship::Ship(int w_items, int w_weapons, int w_motors)
{
   items = w_items;
   item = new Item[w_items];
   weapons = w_weapons;
   weapon = new Weapon[w_weapons];
   motors = w_motors;
   motor = new Motor[w_motors];
}
Ship::~Ship()
{
   delete [] item;
   delete [] weapon;
   delete [] motor;
}
Ship & Ship::operator=(Ship & source)
{
   x = source.x;
   y = source.y;
   height = source.height;
   width = source.width;
   bmp = source.bmp;
   mask = source.mask;
   rad = source.rad;

   type = source.type;
   accel = source.accel;
   angle_accel = source.angle_accel;
   items = source.items;
   weapons = source.weapons;
   motors = source.motors;
   angle = source.angle;
   velocity = source.velocity;
   angle_speed = source.angle_speed;
   max_accel = source.max_accel;
   max_angle_accel = source.max_angle_accel;
   max_angle_speed = source.max_angle_speed;
   max_speed = source.max_speed;
   auto_pilot = source.auto_pilot;
   dest_x = source.dest_x;
   dest_y = source.dest_y;
   left_flag = source.left_flag;
   right_flag = source.right_flag;
   up_flag = source.up_flag;
   down_flag = source.down_flag;
   shoot_flag = source.shoot_flag;
   ai = source.ai;
   under_attack = source.under_attack;

//   delete [] item;
//   delete [] weapon;
//   delete [] motor;
   item = new Item[items];
   weapon = new Weapon[weapons];
   motor = new Motor[motors];

   for(int i = 0; i < items; i++)
      item[i] = source.item[i];
   for(int i = 0; i < weapons; i++)
      weapon[i] = source.weapon[i];
   for(int i = 0; i < motors; i++)
      motor[i] = source.motor[i];
   return *this;
}
Planet::Planet()
{
   moons = 0;
   name = "";
}
void Planet::calc_xy()
{
   for(int i = 0; i < moons; i++)
   {
      moon[i].x = x + cos(moon[i].start.val / RAD)*moon[i].distance;
      moon[i].y = y + sin(moon[i].start.val / RAD)*moon[i].distance;
   }
}
Planet::~Planet()
{
   if(moons > 0)
      delete [] moon;
}
void Star::calc_xy()
{
   for(int i = 0; i < planets; i++)
   {
      planet[i].x = x + cos(planet[i].start.val / RAD)*planet[i].distance;
      planet[i].y = y + sin(planet[i].start.val / RAD)*planet[i].distance;
   }
}
Star::Star()
{
   planets = 0;
   name = "";
}
Star::~Star()
{
   if(planets > 0)
      delete [] planet;
}

