#ifndef _MAIN_H_
#define _MAIN_H_

#define FBLEND
#define ALFONT

#include "allegro.h"
#include "vector.h"
#include "object.h"

#ifndef RAD
#define RAD 57.295779513082320900
#endif

#define RND (double(rand())/double(RAND_MAX))

#define MAX_PARTICLES 5000

#define BACK_STARS 100
#define BACK_STARS_W 800
#define BACK_STARS_H 600
#define BACK_DUST 200

// main.cpp
int init(void);
void load_data(void);
void increment_speed_counter(void);
void fps_calc(void);
void intro(void);

//flight.cpp
void flight_engine();
void flight_draw();
bool is_seen(Object target);
bool planet_is_seen(Object target);
bool star_is_seen(Object target);

// particle.cpp
void draw_particles();
void move_particles();
void create_particle(int type, double x, double y, Vector ship_velocity, PolarVector velocity,int life);

// stellar.cpp
void create_starsystems();

// namegen.cpp
void name_gen(int syllables, int race, int target, char * name);

struct particle_data
{
   double x;
   double y;
   Vector vel;
   int life;
   bool free;
   int type;
   BITMAP *pic;
};

struct back_star_data
{
   double x;
   double y;
   double speed;
   int color;
};

#endif
