#include <stdio.h>
#include <math.h>
#include "allegro.h"
//#include "jgmod.h"
#include "main.h"
#ifdef FBLEND
#include "fblend.h"
#endif
#ifdef ALFONT
#include "alfont.h"
#endif
#include "object.h"
#include "vector.h"

BITMAP *buffer;
Object planu, planu2, stara;
#ifdef FBLEND
BITMAP *hud;
#else
RLE_SPRITE *hud;
#endif
BITMAP *p0,*p1,*p2,**p3;
BITMAP *op0,*op1,*op2,**op3;
PALETTE pal;
BITMAP *fog1;
#ifdef ALFONT
ALFONT_FONT *arial;
#endif

Ship ship,ship2;

volatile int speed_counter = 0;
volatile int frame_count = 0;
volatile int fps = 0, fps1 = 0, fps2 = 0, fps3 = 0;
volatile int fps_graph[80], graph_w = -15;
volatile int max_fps;
volatile int min_fps;
char * name;

bool quit;

back_star_data back_star[BACK_STARS];
back_star_data back_dust[BACK_DUST];

particle_data particle[MAX_PARTICLES];

////////////////////////
//   SPEED EQUALIZER   //
/////////////////////////

void increment_speed_counter()
{
   speed_counter++;

}
END_OF_FUNCTION(increment_speed_counter);

/////////////////////////
//   FPS CALCULATION   //
/////////////////////////

void fps_calc()
{
   for(int i = 79; i > 0; i--)
      fps_graph[i] = fps_graph[i-1];

   fps_graph[0] = fps = fps1 + fps2 + fps3 + frame_count;
   fps1 = fps2;
   fps2 = fps3;
   fps3 = frame_count;
   max_fps = 0;
   if(graph_w < 80)
      graph_w++;
   for(int i = 0; i < graph_w; i++)
      if(fps_graph[i] > max_fps)
         max_fps = fps_graph[i];
   min_fps = 5000;
   for(int i = 0; i < graph_w; i++)
      if(fps_graph[i] < min_fps)
         min_fps = fps_graph[i];
   
   frame_count = 0;
}
END_OF_FUNCTION(fps_calc);

int main()
{
   if(init()) return 1;
//   intro();
   while(!quit)
   {
      while(speed_counter > 0)
      {
         flight_engine();
         speed_counter--;
      }
   flight_draw();
   }
#ifdef ALFONT
   alfont_exit();
#endif
   return 0;
}
END_OF_MAIN();

int init()
{
   srand(time(NULL));
   allegro_init();
   install_keyboard();
   install_mouse();
   set_color_depth(16);
   if(install_mouse()==-1 || mouse_needs_poll()) {
      allegro_message("Unable to install mouse");
      return 1;
   }
   if(set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0)) {
      allegro_message("Sorry, by a better computer! Unable to set gfx mode! \n ERROR:\n%s\n", allegro_error);
      return 1;
   }
   text_mode(-1);
#ifdef ALFONT
   alfont_init();
   alfont_text_mode(-1);
#endif
   buffer = create_bitmap(SCREEN_W,SCREEN_H);
   
//   install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,0);
//   reserve_voices(16, -1);
//   set_volume(255, -1);
//   set_volume_per_voice(0);

//   three_finger_flag = false;   // if declared, ctrl+alt+end won't quit

   load_data();
   create_starsystems();

   for(int i = 0; i < MAX_PARTICLES; i++)
      particle[i].free = true;

   for(int i = 0; i < BACK_STARS; i++)
   {
      back_star[i].x = RND*BACK_STARS_W-BACK_STARS_W/2;
      back_star[i].y = RND*BACK_STARS_H-BACK_STARS_H/2;
      back_star[i].speed = RND*0.0000001;
      back_star[i].color = makecol(int(255*(1-(back_star[i].speed)*10000000)+.5),int(255*(1-(back_star[i].speed)*10000000)+.5),int(255*(1-(back_star[i].speed)*10000000)+.5));
   }
   for(int i = 0; i < BACK_DUST; i++)
   {
      back_dust[i].x = RND*BACK_STARS_W-BACK_STARS_W/2;
      back_dust[i].y = RND*BACK_STARS_H-BACK_STARS_H/2;
      back_dust[i].speed = RND*0.05;
   }

   name = new char[30];

   LOCK_FUNCTION(fps_calc);
   LOCK_VARIABLE(fps);
   LOCK_VARIABLE(fps1);
   LOCK_VARIABLE(fps2);
   LOCK_VARIABLE(fps3);
   LOCK_VARIABLE(fps_graph);
   LOCK_VARIABLE(graph_w);
   LOCK_VARIABLE(max_fps);
   LOCK_VARIABLE(min_fps);
   LOCK_VARIABLE(frame_count);
   LOCK_FUNCTION(increment_speed_counter);
   LOCK_VARIABLE(speed_counter);
   install_int_ex(fps_calc, BPS_TO_TIMER(4));
   install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
   return 0;
}
void intro()
{
   int i = 255;
   while(i >= 8)
   {
      while(speed_counter > 0)
      {
         i-=8;
         speed_counter--;
      }
      clear_to_color(screen, makecol(i,i,i));
   }
}

void load_data()
{
   fog1 = load_pcx("planetary/fog2.pcx",pal);

//   temp = load_bmp("vehicles/light/Trilux1/pikku.bmp",pal);
//   temp = load_bmp("vehicles/light/RM180/default.bmp",pal);
//   temp = load_bmp("vehicles/medium/DeuxC1/default.bmp",pal);
//   temp = load_bmp("vehicles/heavy/Transporter/d12.bmp",pal);
   ship.bmp = load_bmp("vehicles/medium/DeuxC1/default.bmp",pal);
   ship.init();

//   ship.width = 56;
//   ship.height = 37;   //pod
//   ship.rad = 31;

//   ship.width = 47;
//   ship.height = 37;     //RM180
//   ship.rad = 30;

   ship.x = 0;
   ship.y = 0;
   ship.angle = 0;
   ship.accel = ship.max_accel = 0.08;
   ship.angle_accel = ship.max_angle_accel = 0.05;
   ship.max_speed = 0;
   ship.max_angle_speed = 0;
//   ship.width = 248;
//   ship.height = 101;     //DeuxC1
//   ship.rad = 144;
   ship.weapon[0].x_diff = 110;
   ship.weapon[0].y_diff = 0;
   ship.weapon[0].heat = 0;
   ship.motor[0].x_diff = -120;
   ship.motor[0].y_diff = 0;
   
   ship.calc_mask();
   ship2 = ship;
#ifdef FBLEND
   hud = load_bmp("gfx/hud.bmp",pal);
#else
   hud = get_rle_sprite(load_bmp("gfx/hud.bmp",pal));
#endif

   op3 = new BITMAP*[5];
   p3 = new BITMAP*[5];


   p0 = create_bitmap(11,11);
   p1 = create_bitmap(26,26);
   p2 = create_bitmap(31,31);
   p3[0] = create_bitmap(30,30);
   p3[1] = create_bitmap(30,30);
   p3[2] = create_bitmap(30,30);
   p3[3] = create_bitmap(30,30);
   p3[4] = create_bitmap(30,30);
   op0 = load_bitmap("gfx/p_blue_s.bmp",pal);
   op1 = load_bitmap("gfx/p_blue.bmp",pal);
   op2 = load_bitmap("gfx/p_blue_b.bmp",pal);
//   op3 = load_bitmap("gfx/p_fire_red.bmp",pal);
   op3[0] = load_bitmap("gfx/a1/1.bmp",pal);
   op3[1] = load_bitmap("gfx/a1/2.bmp",pal);
   op3[2] = load_bitmap("gfx/a1/3.bmp",pal);
   op3[3] = load_bitmap("gfx/a1/4.bmp",pal);
   op3[4] = load_bitmap("gfx/a1/5.bmp",pal);
   blit(op0,p0,0,0,0,0,11,11);
   blit(op1,p1,0,0,0,0,26,26);
   blit(op2,p2,0,0,0,0,31,31);
   blit(op3[0],p3[0],0,0,0,0,30,30);
   blit(op3[1],p3[1],0,0,0,0,30,30);
   blit(op3[2],p3[2],0,0,0,0,30,30);
   blit(op3[3],p3[3],0,0,0,0,30,30);
   blit(op3[4],p3[4],0,0,0,0,30,30);
#ifdef ALFONT
   arial = alfont_load_font("Arial.ttf");
   alfont_set_font_size(arial,0,10);
#endif
}

