#include <math.h>
#include "allegro.h"
#include "main.h"
#ifdef FBLEND
#include "fblend.h"
#endif
#ifdef ALFONT
#include "alfont.h"
#endif
#include "vector.h"
#include "object.h"

#define FLIGHT 0
#define MAP 1

extern BITMAP *buffer;
extern Object planu, planu2, stara;
#ifdef FBLEND
extern BITMAP *hud;
#else
extern RLE_SPRITE *hud;
#endif
extern BITMAP *p0,*p1,*p2,**p3;
extern BITMAP *op0,*op1,*op2,**op3,*fog1;
extern PALETTE pal;
#ifdef ALFONT
extern ALFONT_FONT *arial;
#endif

extern Ship ship, ship2;

extern volatile int frame_count;
extern volatile int fps;
extern volatile int fps_graph[80], graph_w;
extern volatile int max_fps;
extern volatile int min_fps;

extern bool quit;

extern Star * star;
extern int stars;

double viewx=0, viewy=0, guideang = 0;
double wanted_ang = -1;
int viewdifx = 0, viewdify = 0;
int g1x1, g1y1, g1x2, g1y2;
int g2x1, g2y1, g2x2, g2y2;
int type = 1;
int mode = FLIGHT;
double as = .05;
double t, t2, t3;
int time_mul = 1;

extern char *name;
double zoom=1;
double map_zoom=0.0001;
double map_viewx;
double map_viewy;
double map_viewdifx;
double map_viewdify;
int map_mousex;
int map_mousey;
bool mouse_drag;

bool button_down;

extern back_star_data back_star[BACK_STARS];
extern back_star_data back_dust[BACK_STARS];
extern particle_data particle[MAX_PARTICLES];

void flight_draw()
{
   frame_count++;
   acquire_screen();
   acquire_bitmap(buffer);
//   vsync();
if(mode==FLIGHT)
{
   clear(buffer);
//   pivot_scaled_sprite(buffer, temp, int(x+.5),int(y+.5),ship.width/2,ship.height/2, itofix(int(angle/1.40625 + .5)), ftofix(zoom));

   draw_sprite(buffer, fog1, 20, 20);

   if(ship.velocity.mag()*double(time_mul) < 600 * 10000000)
   {
      for(int i = 0; i < BACK_STARS; i++)
         putpixel(buffer,int(back_star[i].x+.5)+SCREEN_W/2,int(back_star[i].y+.5)+SCREEN_H/2,back_star[i].color);
//         putpixel(buffer,int((back_star[i].x-viewx)+.5)+SCREEN_W/2,int((back_star[i].y-viewy)+.5)+SCREEN_H/2,makecol(int(255*(1-(back_star[i].speed-0.9999999)*10000000)+.5),int(255*(1-(back_star[i].speed-0.9999999)*10000000)+.5),int(255*(1-(back_star[i].speed-0.9999999)*10000000)+.5)));
//         makecol(int(255*pow(1-(back_star[i].speed-0.95)*20,1/zoom/zoom)+.5),
//                 int(255*pow(1-(back_star[i].speed-0.95)*20,1/zoom/zoom)+.5),
//                 int(255*pow(1-(back_star[i].speed-0.95)*20,1/zoom/zoom)+.5)));
   }


#ifndef FBLEND
   set_add_blender(255,255,255,255);
#endif
   for(int i = 0; i < stars; i++)
   {
      if(star_is_seen(star[i]))
#ifdef FBLEND
         fblend_add(star[i].bmp, buffer, int((star[i].x-viewx)*.05+SCREEN_W/2-star[i].width/2+.5),int((star[i].y-viewy)*.05+SCREEN_H/2-star[i].height/2+.5), 255);
#else
         draw_trans_sprite(buffer, star[i].bmp, int((star[i].x-viewx)*.05+SCREEN_W/2-star[i].width/2+.5),int((star[i].y-viewy)*.05+SCREEN_H/2-star[i].height/2+.5));
#endif
//         stretch_sprite(buffer, star[i].bmp, int((star[i].x-viewx)*zoom*.2+SCREEN_W/2-star[i].width/2*zoom+.5),int((star[i].y-viewy)*zoom*.2+SCREEN_H/2-star[i].height/2*zoom+.5),int(star[i].width*zoom+.5),int(star[i].height*zoom+.5));
//         draw_trans_sprite(buffer, star[i].bmp, int((star[i].x-viewx)*.05+SCREEN_W/2-star[i].width/2+.5),int((star[i].y-viewy)*.05+SCREEN_H/2-star[i].height/2+.5));
      for(int j = 0; j < star[i].planets; j++)
      {
         if(planet_is_seen(star[i].planet[j]))
            stretch_sprite(buffer, star[i].planet[j].bmp, int((star[i].planet[j].x-viewx)*zoom*.2+SCREEN_W/2-star[i].planet[j].width/2*zoom+.5),int((star[i].planet[j].y-viewy)*zoom*.2+SCREEN_H/2-star[i].planet[j].height/2*zoom+.5),int(star[i].planet[j].width*zoom+.5),int(star[i].planet[j].height*zoom+.5));
         for(int k = 0; k < star[i].planet[j].moons; k++)
         {
         if(planet_is_seen(star[i].planet[j].moon[k]))
            stretch_sprite(buffer, star[i].planet[j].moon[k].bmp, int((star[i].planet[j].moon[k].x-viewx)*zoom*.2+SCREEN_W/2-star[i].planet[j].moon[k].width/2*zoom+.5),int((star[i].planet[j].moon[k].y-viewy)*zoom*.2+SCREEN_H/2-star[i].planet[j].moon[k].height/2*zoom+.5),int(star[i].planet[j].moon[k].width*zoom+.5),int(star[i].planet[j].moon[k].height*zoom+.5));
         }
      }

   }
//   if(ship.velocity.mag()*time_mul < 600*10)
//      for(int i = 0; i < BACK_DUST; i++)
//         putpixel(buffer, int((back_dust[i].x-viewx)*zoom+.5)+SCREEN_W/2,int((back_dust[i].y-viewy)*zoom+.5)+SCREEN_H/2, makecol(int(255*(0.5-(back_dust[i].speed)*10)+.5),int(255*(0.5-(back_dust[i].speed)*10)+.5),int(255*(0.5-(back_dust[i].speed)*10)+.5)));

   draw_particles();


   pivot_scaled_sprite(buffer, ship.bmp,  int((ship.x-viewx)*zoom+.5)+SCREEN_W/2,int((ship.y-viewy)*zoom+.5)+SCREEN_H/2,int(double(ship.width)/2+.5),int(double(ship.height)/2+.5), itofix(int(ship.angle.val/1.40625 + .5)), ftofix(zoom));
   if(is_seen(ship2))
      pivot_scaled_sprite(buffer, ship2.bmp, int((ship2.x-viewx)*zoom+.5)+SCREEN_W/2,int((ship2.y-viewy)*zoom+.5)+SCREEN_H/2,int(double(ship2.width)/2+.5),int(double(ship2.height)/2+.5), itofix(int(ship2.angle.val/1.40625 + .5)), ftofix(zoom));

   if(ship.collision(ship2))
   {
      circle(buffer, int((ship2.x-viewx)*zoom+.5)+SCREEN_W/2,int((ship2.y-viewy)*zoom+.5)+SCREEN_H/2,int(ship2.rad*zoom),makecol(0,0,255));
      circle(buffer, int((ship.x-viewx)*zoom+.5)+SCREEN_W/2,int((ship.y-viewy)*zoom+.5)+SCREEN_H/2,int(ship.rad*zoom),makecol(0,0,255));
   }

   line(buffer, g1x1, g1y1, g1x2, g1y2, makecol(0,170,0));
   line(buffer, g2x1, g2y1, g2x2, g2y2, makecol(170,0,0));
}
else
{
   clear_to_color(buffer, makecol(0,0,70));
   double space = map_zoom;
   int light;
   while(space < 30) space *= 2;
   light = int(int((map_viewx-viewx)*map_zoom - SCREEN_W/2)/space);
//   while(light < 0) light += 4;
   light = light %4;
   for(double i =
   -((map_viewx-viewx)*map_zoom - SCREEN_W/2)
   +space*double(int(((map_viewx-viewx)*map_zoom - SCREEN_W/2)/space)); i < SCREEN_W; i += space)
   {
      if(light == 0)
      {
         vline(buffer, int(i+.5), 0, SCREEN_H, makecol(60,60,210));
#ifdef ALFONT
         alfont_textprintf_centre_aa(buffer, arial,int(i+.5), 0, makecol(100,100,255), "%.0f", ((i-SCREEN_W/2)/map_zoom + map_viewx)/1000);
#else
         textprintf_centre(buffer, font, int(i+.5), 0, makecol(100,100,255), "%.0f", ((i-SCREEN_W/2)/map_zoom + map_viewx)/1000);
#endif
      }
      else if(light == 2)
         vline(buffer, int(i+.5), 0, SCREEN_H, makecol(0,0,150));
      else
         vline(buffer, int(i+.5), 0, SCREEN_H, makecol(0,0,90));
      light+=1;
      light = light%4;
   }
   light = int(int((map_viewy-viewy)*map_zoom - SCREEN_H/2)/space);
//   while(light < 0) light += 4;
   light = light %4;
   for(double i =
   -((map_viewy-viewy)*map_zoom - SCREEN_H/2)
   +space*double(int(((map_viewy-viewy)*map_zoom - SCREEN_H/2)/space)); i < SCREEN_H; i += space)
   {
      if(light == 0)
      {
         hline(buffer, 0, int(i+.5), SCREEN_W, makecol(60,60,210));
#ifdef ALFONT
         alfont_textprintf_aa(buffer, arial, 0,int(i+.5)-4, makecol(100,100,255), "%.0f", ((i-SCREEN_H/2)/map_zoom + map_viewx)/1000);
#else
         textprintf(buffer, font, 0,int(i+.5)-4, makecol(100,100,255), "%.0f", ((i-SCREEN_H/2)/map_zoom + map_viewx)/1000);
#endif
      }
      else if(light == 2)
         hline(buffer, 0, int(i+.5), SCREEN_W, makecol(0,0,150));
      else
         hline(buffer, 0, int(i+.5), SCREEN_W, makecol(0,0,90));
      light+=1;
      light = light%4;
  }

   circle(buffer, int((ship2.x-map_viewx)*map_zoom+.5)+SCREEN_W/2,int((ship2.y-map_viewy)*map_zoom+.5)+SCREEN_H/2,2,makecol(255,0,0));
   circle(buffer, int((ship.x-map_viewx)*map_zoom+.5)+SCREEN_W/2,int((ship.y-map_viewy)*map_zoom+.5)+SCREEN_H/2,2,makecol(255,255,255));
   for(int i = 0; i < stars; i++)
   {
      circle(buffer, int((star[i].x-map_viewx)*map_zoom+SCREEN_W/2+.5),int((star[i].y-map_viewy)*map_zoom+SCREEN_H/2+.5), 5, makecol(255,255,255));
#ifdef ALFONT
      alfont_textprintf_aa(buffer, arial, int((star[i].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].name);
#else
      textprintf(buffer, font, int((star[i].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].name);
#endif
      for(int j = 0; j < star[i].planets; j++)
      {
         circle(buffer, int((star[i].planet[j].x-map_viewx)*map_zoom+SCREEN_W/2+.5),int((star[i].planet[j].y-map_viewy)*map_zoom+SCREEN_H/2+.5), 3, makecol(128,128,128));
#ifdef ALFONT
         alfont_textprintf_aa(buffer, arial, int((star[i].planet[j].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].planet[j].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].planet[j].name);
#else
         textprintf(buffer, font, int((star[i].planet[j].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].planet[j].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].planet[j].name);
#endif
         for(int k = 0; k < star[i].planet[j].moons; k++)
         {
            circle(buffer, int((star[i].planet[j].moon[k].x-map_viewx)*map_zoom+SCREEN_W/2+.5),int((star[i].planet[j].moon[k].y-map_viewy)*map_zoom+SCREEN_H/2+.5), 2, makecol(128,128,128));
#ifdef ALFONT
            alfont_textprintf_aa(buffer, arial, int((star[i].planet[j].moon[k].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].planet[j].moon[k].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].planet[j].moon[k].name);
#else
            textprintf(buffer, font, int((star[i].planet[j].moon[k].x-map_viewx)*map_zoom+SCREEN_W/2+.5)+5,int((star[i].planet[j].moon[k].y-map_viewy)*map_zoom+SCREEN_H/2+.5)+5, makecol(100,100,255), star[i].planet[j].moon[k].name);
#endif
         }
      }

   }
   line(buffer, int(g1x1+(ship.x-map_viewx)*map_zoom+.5), int(g1y1+(ship.y-map_viewy)*map_zoom+.5), int(g1x2+(ship.x-map_viewx)*map_zoom+.5), int(g1y2+(ship.y-map_viewy)*map_zoom+.5), makecol(0,170,0));
   line(buffer, int(g2x1+(ship.x-map_viewx)*map_zoom+.5), int(g2y1+(ship.y-map_viewy)*map_zoom+.5), int(g2x2+(ship.x-map_viewx)*map_zoom+.5), int(g2y2+(ship.y-map_viewy)*map_zoom+.5), makecol(170,0,0));
}

   if(mouse_drag)
   {
      hline(buffer,map_mousex-5,map_mousey,map_mousex+5,makecol(255,255,255));
      vline(buffer,map_mousex,map_mousey-5,map_mousey+5,makecol(255,255,255));
   } else
   {
      hline(buffer,mouse_x-5,mouse_y,mouse_x+5,makecol(255,255,255));
      vline(buffer,mouse_x,mouse_y-5,mouse_y+5,makecol(255,255,255));
   }

#ifdef ALFONT
   alfont_textprintf_aa(buffer, arial, 576,0, makecol(255,255,255), "Fps: %d", fps);
   alfont_textprintf_aa(buffer, arial, 576,10, makecol(255,255,255), "X: %.0f", ship.x/1000);
   alfont_textprintf_aa(buffer, arial, 576,20, makecol(255,255,255), "Y: %.0f", ship.y/1000);
   alfont_textprintf_aa(buffer, arial, 576,30, makecol(255,255,255), "Zoom: %.2f", zoom*(mode==FLIGHT) + map_zoom*10000000*(mode==MAP));
   alfont_textprintf_aa(buffer, arial, 576,40, makecol(255,255,255), "Time mulitplier: %d", time_mul);
   alfont_textprintf_aa(buffer, arial, 576,50, makecol(255,255,255), "wanted_ang: %d", int(wanted_ang));
   alfont_textprintf_aa(buffer, arial, 576,60, makecol(255,255,255), "guide_ang: %d", int(guideang));
   alfont_textprintf_aa(buffer, arial, 576,70, makecol(255,255,255), name);

   alfont_textprintf_aa(buffer, arial, 10,40, makecol(0,90,50), "Speed: %.2f", ship.velocity.mag());
   alfont_textprintf_aa(buffer, arial, 10,50, makecol(0,90,50), "Speed Angle: %.2f", ship.velocity.ang().val);
   alfont_textprintf_aa(buffer, arial, 10,70, makecol(0,90,50), "Angle: %.1f", ship.angle.val);
   alfont_textprintf_aa(buffer, arial, 10,80, makecol(0,90,50), "Angle Speed: %.2f", ship.angle_speed);
   alfont_textprintf_aa(buffer, arial, 10,90, makecol(0,90,50), "Acceleration: %.1f", ship.accel);
   alfont_textprintf_aa(buffer, arial, 10,100, makecol(0,90,50), "Angle Acceleration: %.1f", ship.angle_accel);

   alfont_textprintf_aa(buffer, arial, 10,120, makecol(0,90,50), "Max Acceleration: %.2f", ship.max_accel);
   alfont_textprintf_aa(buffer, arial, 10,130, makecol(0,90,50), "Max Angle Acceleration: %.2f", ship.max_angle_accel);
   if(ship.max_speed == 0)
      alfont_textprintf_aa(buffer, arial, 10,140, makecol(0,90,50), "Max Speed: Off");
   else
      alfont_textprintf_aa(buffer, arial, 10,140, makecol(0,90,50), "Max Speed: %.1f", ship.max_speed);
   if(ship.max_angle_speed == 0)
      alfont_textprintf_aa(buffer, arial, 10,150, makecol(0,90,50), "Max Angle Speed: Off");
   else
      alfont_textprintf_aa(buffer, arial, 10,150, makecol(0,90,50), "Max Angle Speed: %.2f", ship.max_angle_speed);
#else
   textprintf(buffer, font, 576,0, makecol(255,255,255), "Fps: %d", fps);
   textprintf(buffer, font, 576,10, makecol(255,255,255), "X: %.0f", ship.x/1000);
   textprintf(buffer, font, 576,20, makecol(255,255,255), "Y: %.0f", ship.y/1000);
   textprintf(buffer, font, 576,30, makecol(255,255,255), "Zoom: %.2f", zoom*(mode==FLIGHT) + map_zoom*10000000*(mode==MAP));
   textprintf(buffer, font, 576,40, makecol(255,255,255), "Time mulitplier: %d", time_mul);
   textprintf(buffer, font, 576,50, makecol(255,255,255), "wanted_ang: %d", int(wanted_ang));
   textprintf(buffer, font, 576,60, makecol(255,255,255), "guide_ang: %d", int(guideang));
   textprintf(buffer, font, 576,70, makecol(255,255,255), name);

   textprintf(buffer, font, 10,40, makecol(0,90,50), "Speed: %.2f", ship.velocity.mag());
   textprintf(buffer, font, 10,50, makecol(0,90,50), "Speed Angle: %.2f", ship.velocity.ang().val);
   textprintf(buffer, font, 10,70, makecol(0,90,50), "Angle: %.1f", ship.angle.val);
   textprintf(buffer, font, 10,80, makecol(0,90,50), "Angle Speed: %.2f", ship.angle_speed);
   textprintf(buffer, font, 10,90, makecol(0,90,50), "Acceleration: %.1f", ship.accel);
   textprintf(buffer, font, 10,100, makecol(0,90,50), "Angle Acceleration: %.1f", ship.angle_accel);

   textprintf(buffer, font, 10,120, makecol(0,90,50), "Max Acceleration: %.2f", ship.max_accel);
   textprintf(buffer, font, 10,130, makecol(0,90,50), "Max Angle Acceleration: %.2f", ship.max_angle_accel);
   if(ship.max_speed == 0)
      textprintf(buffer, font, 10,140, makecol(0,90,50), "Max Speed: Off");
   else
      textprintf(buffer, font, 10,140, makecol(0,90,50), "Max Speed: %.1f", ship.max_speed);
   if(ship.max_angle_speed == 0)
      textprintf(buffer, font, 10,150, makecol(0,90,50), "Max Angle Speed: Off");
   else
      textprintf(buffer, font, 10,150, makecol(0,90,50), "Max Angle Speed: %.2f", ship.max_angle_speed);
#endif

/*   int dist = sqrt(ship.width*ship.width+ship.height*ship.height)/2+2;
   for(int tx = -dist; tx < dist; tx++)
      for(int ty = -dist; ty < dist; ty++)
         if(ship.pix_point_collision(tx,ty, ship.angle.val))
            putpixel(buffer, tx+dist,ty+dist,makecol(0,0,255));
  */
#ifdef FBLEND
   fblend_trans(hud, buffer, SCREEN_W-86, 0, 120);
#else
   set_trans_blender(255,255,255,120);
   draw_trans_rle_sprite(buffer, hud, SCREEN_W-86, 0);
#endif
   for(int i = 0; i < graph_w-1; i++)
      line(buffer, SCREEN_W - 80 + i, int(double(fps_graph[i]-min_fps)/double(max_fps-min_fps)*100), SCREEN_W - 79 + i, int(double(fps_graph[i+1]-min_fps)/double(max_fps-min_fps)*100), makecol(50,50,255));

   if(key[KEY_ENTER]) rest(100);

   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   release_bitmap(buffer);
   release_screen();
}
void flight_engine()
{
//   t = -ship.angle_speed / ((ship.angle_speed<0)*ship.angle_accel + (ship.angle_speed>0)*-ship.angle_accel);
//   guideang = ship.angle.val + ship.angle_speed*t + ((ship.angle_speed<0)*ship.angle_accel + (ship.angle_speed>0)*-ship.angle_accel)*t*t/2;
//   t =
   guideang = ship.angle.val - ship.angle_speed * ship.angle_speed / (2 * ((ship.angle_speed<=0)*ship.angle_accel + (ship.angle_speed>0)*-ship.angle_accel));
   while(guideang < 0) guideang += 360;
   while(guideang >= 360) guideang -= 360;


   if(!key[KEY_F10] && !key[KEY_TAB]) button_down = false;
   if(key[KEY_ESC]) quit = true;

   if(key[KEY_F10] && !button_down) {
      save_bmp("screenshot.bmp",buffer,pal);
      button_down = true;
   }
   
   if(key[KEY_TAB] && !button_down)
   {
      if(mode == FLIGHT)
         mode = MAP;
      else
         mode = FLIGHT;
      map_viewx = viewx;
      map_viewy = viewy;
      map_viewdifx = 0;
      map_viewdify = 0;
      button_down = true;
   }


   if(key[KEY_1]) type = 0;
   if(key[KEY_2]) type = 1;
   if(key[KEY_3]) type = 2;

   if(key[KEY_SPACE] && ship.weapon[0].heat <= 0)
   {
      create_particle(3,ship.x+ship.weapon_x(0),ship.y+ship.weapon_y(0),ship.velocity,PolarVector(10,ship.angle.val),1000);
      ship.weapon[0].heat = 60;
   }
   


   if(mouse_b & 2)
      wanted_ang = calcang(SCREEN_W/2,SCREEN_H/2,mouse_x,mouse_y).val;

   if(!(mouse_b & 1))
      mouse_drag = false;
   else if(mouse_b & 1 && !mouse_drag)
   {
      mouse_drag = true;
      map_mousex = mouse_x;
      map_mousey = mouse_y;
   }
   else if(mouse_b & 1)
   {
      map_viewdifx += (mouse_x - map_mousex)/map_zoom;
      map_viewdify += (mouse_y - map_mousey)/map_zoom;
      position_mouse(map_mousex, map_mousey);
   }

   double tempang = Angle(wanted_ang)>>Angle(guideang);
   if(key[KEY_LEFT])
   {
      ship.angle_speed-=ship.max_angle_accel*time_mul;
      wanted_ang =-1;
   }
   else if(key[KEY_RIGHT])
   {
      ship.angle_speed+=ship.max_angle_accel*time_mul;
      wanted_ang =-1;
   }
   else if(wanted_ang != -1)
   {
      if(tempang<0)
         ship.angle_speed+=ship.max_angle_accel*time_mul;
      else
         ship.angle_speed-=ship.max_angle_accel*time_mul;
   }
   else if(fabs(ship.angle_speed) <= ship.angle_accel*time_mul)
      ship.angle_speed = 0;
   else
      ship.angle_speed += ((ship.angle_speed<0)*ship.angle_accel + (ship.angle_speed>0)*-ship.angle_accel)*time_mul;

   if(wanted_ang != -1 && int(ship.angle.val + wanted_ang +.5) && fabs(ship.angle_speed) <= ship.max_accel)
      wanted_ang = -1;

   if(wanted_ang != -1 && time_mul > 5)
   {
      ship.angle = Angle(wanted_ang);
      ship.angle_speed = 0;
      wanted_ang = -1;
   }

   if(ship.angle_speed > 45)
      ship.angle_speed = 45;
   if(ship.angle_speed < -45)
      ship.angle_speed = -45;

   ship.angle += ship.angle_speed*time_mul;

   if(key[KEY_PLUS_PAD] && zoom < 1 && mode == FLIGHT)
      zoom*=1.01;
   if(key[KEY_MINUS_PAD]  && zoom > 0.1 && mode == FLIGHT)
      zoom/=1.01;

   if(key[KEY_PLUS_PAD] && map_zoom < 0.01 && mode == MAP && key_shifts & KB_SHIFT_FLAG)
      map_zoom*=1.1;
   else if(key[KEY_PLUS_PAD] && map_zoom < 0.01 && mode == MAP)
      map_zoom*=1.01;
   if(key[KEY_MINUS_PAD]  && map_zoom > 0.000000001 && mode == MAP && key_shifts & KB_SHIFT_FLAG)
      map_zoom/=1.1;
   else if(key[KEY_MINUS_PAD]  && map_zoom > 0.000000001 && mode == MAP)
      map_zoom/=1.01;

   if((key[KEY_MINUS_PAD] || key[KEY_PLUS_PAD]) && mode == FLIGHT)
   {
      destroy_bitmap(p0);
      p0 = create_bitmap(MAX(int(11*zoom+.5),1),MAX(int(11*zoom+.5),1));
      stretch_blit(op0, p0, 0, 0, 11,11,0,0,MAX(int(11*zoom+.5),1), MAX(int(11*zoom+.5),1));

      destroy_bitmap(p1);
      p1 = create_bitmap(MAX(int(26*zoom+.5),1),MAX(int(26*zoom+.5),1));
      stretch_blit(op1, p1, 0, 0, 26,26,0,0, MAX(int(26*zoom+.5),1), MAX(int(26*zoom+.5),1));

      destroy_bitmap(p2);
      p2 = create_bitmap(MAX(int(31*zoom+.5),1),MAX(int(31*zoom+.5),1));
      stretch_blit(op2, p2, 0, 0, 31,31,0,0, MAX(int(31*zoom+.5),1), MAX(int(31*zoom+.5),1));
      
      for(int i = 0; i < 5; i++)
      {
         destroy_bitmap(p3[i]);
         p3[i] = create_bitmap(MAX(int(30*zoom+.5),1),MAX(int(30*zoom+.5),1));
         stretch_blit(op3[i], p3[i], 0, 0, 30,30,0,0, MAX(int(30*zoom+.5),1), MAX(int(30*zoom+.5),1));
      }
   }


   if(key[KEY_Q] && ship.max_accel < ship.accel)
      ship.max_accel += ship.accel / 240;
   if(key[KEY_A] && ship.max_accel > ship.accel / 240)
      ship.max_accel -= ship.accel / 240;
   if(key[KEY_W] && ship.max_angle_accel < ship.angle_accel)
      ship.max_angle_accel += ship.angle_accel / 240;
   if(key[KEY_S] && ship.max_angle_accel > ship.angle_accel/240)
      ship.max_angle_accel -= ship.angle_accel / 240;
   if(key[KEY_E])
      ship.max_speed += 1;
   if(key[KEY_D] && ship.max_speed > 0)
      ship.max_speed -= 1;
   if(key[KEY_C] || ship.max_speed < 0)
      ship.max_speed = 0;
   if(key[KEY_R])
      ship.max_angle_speed += .02;
   if(key[KEY_F] && ship.max_angle_speed > 0)
      ship.max_angle_speed -= .02;
   if(key[KEY_V] || ship.max_angle_speed < 0)
      ship.max_angle_speed = 0;
   if(key[KEY_I])
      viewdify-=5;
   if(key[KEY_K])
      viewdify+=5;
   if(key[KEY_J])
      viewdifx-=5;
   if(key[KEY_L])
      viewdifx+=5;
   if(key[KEY_F1])
      time_mul = 1;
   if(key[KEY_F2])
      time_mul = 2;
   if(key[KEY_F3])
      time_mul = 5;
   if(key[KEY_F4])
      time_mul = 30;
   if(key[KEY_F5])
      time_mul = 100;
   if(key[KEY_F6])
      time_mul = 1000;
   if(key[KEY_F7])
      time_mul = 10000;
   if(key[KEY_N])
      name_gen(20/*int(RND*4+1.8)*/,0,0,name);

      
//   if(angle < 0) angle += 360;
//   if(angle >= 360) angle -= 360;
   if(ship.weapon[0].heat > 0)
      ship.weapon[0].heat -= time_mul;
   if(ship.weapon[0].heat < 0)
      ship.weapon[0].heat = 0;
      

   if(key[KEY_UP])
   {

         // PIKKULIEKKI TYYLIIN RM180
         ship.velocity.x += cos(ship.angle.val / RAD)*ship.max_accel*time_mul;
         ship.velocity.y += sin(ship.angle.val / RAD)*ship.max_accel*time_mul;
         for(int i = 0 ; i < 1; i++)
         {
            t = ship.angle.val + 180+RND*10-5;
            if(t >= 360) t -= 360;
            t2 = cos(t / RAD)+ship.x+ship.motor_x(0);
            t3 = sin(t / RAD)+ship.y+ship.motor_y(0);
//            create_particle(type, t2, t3, ship.velocity , PolarVector(1.5+RND*2,t+RND*10-5), 20);
         }
   }

   
   if(key[KEY_DOWN])
   {
         ship.velocity.x -= cos(ship.angle.val / RAD)*ship.max_accel*time_mul;
         ship.velocity.y -= sin(ship.angle.val / RAD)*ship.max_accel*time_mul;
   }
   if(mode==FLIGHT)
   {
      g1x1 = int(cos(guideang / RAD)*ship.rad*zoom+SCREEN_W/2+.5);
      g1y1 = int(sin(guideang / RAD)*ship.rad*zoom+SCREEN_H/2+.5);
      g1x2 = int(cos(guideang / RAD)*(ship.rad*zoom+10)+SCREEN_W/2+.5);
      g1y2 = int(sin(guideang / RAD)*(ship.rad*zoom+10)+SCREEN_H/2+.5);
   }
   else
   {
      g1x1 = int(cos(guideang / RAD)*3+SCREEN_W/2+.5);
      g1y1 = int(sin(guideang / RAD)*3+SCREEN_H/2+.5);
      g1x2 = int(cos(guideang / RAD)*10+SCREEN_W/2+.5);
      g1y2 = int(sin(guideang / RAD)*10+SCREEN_H/2+.5);
   }

   ship.x += ship.velocity.x*time_mul, ship.y += ship.velocity.y*time_mul;
   
   if(ship.max_speed > 0 && ship.velocity.mag() > ship.max_speed)
      ship.velocity /= ship.velocity.mag()/ship.max_speed;

   if(ship.max_angle_speed > 0 && ship.angle_speed > ship.max_angle_speed)
      ship.angle_speed = ship.max_angle_speed;
   if(ship.max_angle_speed > 0 && ship.angle_speed < -ship.max_angle_speed)
      ship.angle_speed = -ship.max_angle_speed;

   t = atan2(ship.velocity.y,ship.velocity.x) * RAD;
   t2 = sqrt(ship.velocity.x*ship.velocity.x+ship.velocity.y*ship.velocity.y);

   if(mode==FLIGHT)
   {
      g2x1 = int(cos(t / RAD)*ship.rad*zoom+SCREEN_W/2+.5);
      g2y1 = int(sin(t / RAD)*ship.rad*zoom+SCREEN_H/2+.5);
      g2x2 = int(cos(t / RAD)*(ship.rad+t2/time_mul)*zoom+SCREEN_W/2+.5);
      g2y2 = int(sin(t / RAD)*(ship.rad+t2/time_mul)*zoom+SCREEN_H/2+.5);
   }
   else
   {
      g2x1 = int(cos(t / RAD)*3+SCREEN_W/2+.5);
      g2y1 = int(sin(t / RAD)*3+SCREEN_H/2+.5);
      g2x2 = int(cos(t / RAD)*(3+t2/time_mul)+SCREEN_W/2+.5);
      g2y2 = int(sin(t / RAD)*(3+t2/time_mul)+SCREEN_H/2+.5);
   }
   move_particles();

   viewx = ship.x + viewdifx;
   viewy = ship.y + viewdify;
   if(mode==MAP)
   {
      map_viewx = viewx + map_viewdifx;
      map_viewy = viewy + map_viewdify;
   }


   if(ship.velocity.mag()*double(time_mul) < 600*10000000)
   {
      for(int i = 0; i < BACK_STARS; i++)
      {
         back_star[i].x -= ship.velocity.x * back_star[i].speed * time_mul;
         back_star[i].y -= ship.velocity.y * back_star[i].speed * time_mul;
         while(back_star[i].x > BACK_STARS_W/2) back_star[i].x -= BACK_STARS_W;
         while(back_star[i].x < -BACK_STARS_W/2) back_star[i].x += BACK_STARS_W;
         while(back_star[i].y > BACK_STARS_H/2) back_star[i].y -= BACK_STARS_H;
         while(back_star[i].y < -BACK_STARS_H/2) back_star[i].y += BACK_STARS_H;
      }
   }
/*   if(ship.velocity.mag()*time_mul < 600*10)
   {
      for(int i = 0; i < BACK_DUST; i++)
      {
         back_dust[i].x += ship.velocity.x * back_dust[i].speed * time_mul;
         back_dust[i].y += ship.velocity.y * back_dust[i].speed * time_mul;
         while(back_dust[i].x > viewx+BACK_STARS_W/2) back_dust[i].x -= BACK_STARS_W;
         while(back_dust[i].x < viewx-BACK_STARS_W/2) back_dust[i].x += BACK_STARS_W;
         while(back_dust[i].y > viewy+BACK_STARS_H/2) back_dust[i].y -= BACK_STARS_H;
         while(back_dust[i].y < viewy-BACK_STARS_H/2) back_dust[i].y += BACK_STARS_H;
      }
   }*/
}
bool is_seen(Object target)
{
   if(target.x-viewx+target.rad > -SCREEN_W/2/zoom && target.x-viewx-target.rad< SCREEN_W/2/zoom && target.y-viewy+target.rad > -SCREEN_H/2/zoom && target.y-viewy-target.rad< SCREEN_H/2/zoom)
      return true;
   return false;
}
bool planet_is_seen(Object target)
{
   if((target.x-viewx)*.2 + target.rad > -SCREEN_W/2/zoom && (target.x-viewx)*.2-target.rad < SCREEN_W/2/zoom && (target.y-viewy)*.2 + target.rad > -SCREEN_H/2/zoom && (target.y-viewy)*.2-target.rad < SCREEN_H/2/zoom)
      return true;
   return false;
}
bool star_is_seen(Object target)
{
   if((target.x-viewx)*.05 + target.rad > -SCREEN_W/2 && (target.x-viewx)*.05-target.rad < SCREEN_W/2 && (target.y-viewy)*.05 + target.rad > -SCREEN_H/2 && (target.y-viewy)*.05-target.rad < SCREEN_H/2)
      return true;
   return false;
}
