#include <allegro.h>

#include "main.h"

#include "game.h"
#include "plate.h"
#include "ball.h"
#include "target.h"

Target *launcher = 0;

Target *Target::targets = 0;

Target::Target(float _xp, float _yp, float _rp, float _R, bool _flip, int _type) : Part(_xp, _yp, _rp, _R) {
	nexttarget = targets;
	targets = this;
	hit = 0;
	flip = _flip;	
	redraw = true;		
	type = _type;
	owncol = true;
}

Target::~Target() { // Only ever delete all at once
	targets = 0;
}

void Target::ballcollision(Ball *b) {		
	
	if(hit) return;
	
	float bx = b->xp - xp;
	float by = b->yp - yp;
	
	if(bx * bx + by * by <= R * R + b->R * b->R) {
		collide(b);				
	}
}

bool Target::collide(Ball *b) {
	bool gotit = false;
	
	if(type == 7) return true;
		
	if(type == 10) {			
		if(game->leftramp == 3) {
			gotit = true;				
		}
		game->leftramp = 1;
	}
	if(type == 11) {
		if(game->leftramp == 1) game->leftramp = 2;
		if(game->leftramp == 4) game->leftramp = 3;
	}
	if(type == 12) {
		if(game->leftramp == 2) {
			gotit = true;
		}
		game->leftramp = 4;
		
	}
	if(type == 20) {
		if(game->rightramp == 3) {
			gotit = true;
		}
		game->rightramp = 1;			
	}
	if(type == 21) {
		if(game->rightramp == 1) game->rightramp = 2;
		if(game->rightramp == 4) game->rightramp = 3;
	}
	if(type == 22) {
		if(game->rightramp == 2) {
			gotit = true;
		}
		game->rightramp = 4;
		
	}
	
	if(gotit) {
		b->hit4 = 255;
		if(b->who == -1) {
			game->leftpoints += 400;
			
			lefttopplate->rest = lefttopplate->redraw = true;
		}
		if(b->who == 1) {
			game->rightpoints += 400;
			
			righttopplate->rest = righttopplate->redraw = true;
		}
		
		if(b->in_charge || game->netrate <= 0) game->newball = b->who;
		
		
	}
	
	return false;
}

bool Target::ballcollision(Ball *b, float *nx, float *ny) {
	float bx = b->xp - xp;
	float by = b->yp - yp;
	if(bx * bx + by * by <= R * R + b->R * b->R) {		
		*nx = bx;
		*ny = by;
		
		return collide(b);				
									
	}
	return false;
}

void Target::move(float d) {
	
}

void Target::draw() {
	//circle(page, int(xp), int(yp), int(R), makecol(255, 0, 0));
}

void Target::draw2() {
					
}