#include <allegro.h>

#include <string.h>

#include "story.h"
#include "main.h"

Story *story;

Story::Story() {
	
}

int Story::process(float d) {	
		
	while(keypressed()) {
		int k = readkey();
		k >>= 8;
		if(k == KEY_ESC || k == KEY_SPACE || k == KEY_ENTER) {									
			return 1;
		}
		
		if(k == KEY_LEFT) {
			xsc--;
			sc = true;
			dir = -1;
		}
		if(k == KEY_RIGHT) {
			xsc++;
			sc = true;
			dir = 1;
		}
	}	
	
	int mx, my;
	get_mouse_mickeys(&mx, &my);
	if(mx) {
		int b = xsc;
		xsc += mx;				
		
		if(mx < 0) dir = -1;
		if(mx > 0) dir = 1;
		
		if( b != xsc) {
			sc = true;
		}
	}
	
	if(!sc) {
		xsc += dir;
		sc = true;
	}
	
	return 0;
}

int Story::screen2world(int sx) {
	int wx = xsc + sx;
	wx %= 40 * 60;
	if(wx < 0) wx += 40 * 60;
	return wx;
}

int Story::world2screen(int wx) {
	int sx = wx - xsc;
	sx %= 40 * 60;
	if(sx < -20 * 60) sx += 40 * 60;
	if(sx > 20 * 60) sx -= 40 * 60;
	return sx;
}

void Story::redraw() {
				
	if(sc) {
				
		int x1 = 0;
		int y1 = 0;
		int x2 = page->w - 1;
		int y2 = page->h - 1;
		
		if(old) {
			if(xsc > oxsc) {
				x1 = page->w + oxsc - xsc;
				blit(page, page, 0, 0, oxsc - xsc, 0, page->w, page->h);
			}
			if(xsc < oxsc) {
				x2 = oxsc - xsc;
				blit(page, page, 0, 0, oxsc - xsc, 0, page->w, page->h);
			}
		}
		
		oxsc = xsc;
		old = true;
		
		set_clip(page, x1, y1, x2, y2);
		for(int y = 0; y < 12; y++) {
			int lx = screen2world(x1) / 40;
			int rx = lx + (x2 - x1 + 39) / 40;
																								
			int offx = world2screen(lx * 40);
			
			for(int x = lx; x <= rx; x++) {
				char str[8];					
				sprintf(str, "%c", txt[y][x % 60]);
				textout(page, (FONT *)(egyptfont[0].dat), str,  offx, y * 40, -1);																		
				offx += 40;
			}
		}
		set_clip(page, 0, 0, page->w - 1, page->h - 1);
		sc = false;
	}
}

int Story::translate(char *tok) {
	for(int j = 0; j < 256; j++) {
		if(!strcmp(toktab[j], tok)) return ' ' + j;
	}	
	return ' ';
}

int backupformat;

void Story::enter() {
	
	backupformat = get_uformat();
	set_uformat(U_ASCII);
	
	dir = 1;
	old = false;
	xsc = 0;	
	sc = true;
	
	background = create_bitmap(SCREEN_W, SCREEN_H);
	
	{
		PACKFILE *file = pack_fopen("dat.dat#dict.txt", "r");		
		
		if(file) {
			for(int j = 0; j < 256; j++) {
				int c = 0;
				for(int i = 0; i < 8; i++) {
					c = pack_getc(file);
					toktab[j][i] = 0;
					if(c == ' ') break;
					if(c == '\n') break;
					toktab[j][i] = c;
				}
				for(;c != '\n';) {
					c = pack_getc(file);
					if(c < 0) goto breakbreak;					
				} 
			}
			breakbreak:					
			pack_fclose(file);
		}
	}
	
	set_palette((RGB *)(egyptfont[1].dat));
	
	{	
		
		PACKFILE *file = pack_fopen("dat.dat#translation.txt", "r");
				
		if(file) {
							
			int x = 0, y = 0;
			bool newline = false;
			for(;;) {
				char str[8];
				
				if(newline) {
					x = 0;
					y ++;
					newline = false;
				}								
				
				for(int i = 0; i < 8; i++) {
					int c = pack_getc(file);
					if(c < 0) goto breakbreak2;
					str[i] = 0;
					if(c == ' ') break;
					if(c == '\n') {
						newline = true;
						break;
					}					
					str[i] = c;
				}	
				if(str[0] == 0) continue;								
				
				int c = translate(str);
				
				if(y < 12 && x < 60) txt[y][x] = c;
				
				x++;			
				
			}
			breakbreak2:
			pack_fclose(file);
		}
	}
	redraw_background();
	
}

void Story::leave() {
		
	set_uformat(backupformat);
	
	destroy_bitmap(background);
}	