#include <allegro.h>

#include "main.h"

#include "game.h"
#include "plate.h"
#include "ball.h"
#include "line.h"
#include "squirrel.h"

BITMAP *Squirrel::squirrel = 0;

int side = -1;

int Squirrel::num = 0;

Squirrel::Squirrel(float _xp, float _yp, float _rp, float _R, bool _flip) : Target(_xp, _yp, _rp, _R, _flip) {
	owncol = false;
	type = 1;
	going = false;	
	out = false;
	
	steptime = 0;
	invading = false;
	
	drx1 = -35;
	dry1 = -35;
	drx2 = 35;
	dry2 = 35;
	
	lifes = 1;
	
	xhome = xp;
	yhome = yp;
	rhome = rp;
	
	count = num++;
	
}

bool Squirrel::collide(Ball *b) {
	
	if(b->xc * b->xc + b->yc * b->yc < 100 * 100) return false;
	
	lifes--;
	if(lifes <= 0) {				
		yc = 0;
					
		hit = true;	
							
		if(b->who == -1) {
			game->leftpoints += 300;
			redraw = true;
			lefttopplate->rest = lefttopplate->redraw = true;
		}
		if(b->who == 1) {
			game->rightpoints += 300;
			redraw = true;
			righttopplate->rest = righttopplate->redraw = true;
		}
	}	
		
	b->hit3 = 255;
	
	return true;
}

void Squirrel::move(float d) {
	
	if(joy > 0) {
		joy -= d;
		if(joy <= 0) {
			joy = 0;
			hit = true;			
		}
		rp += d * 2 * M_PI;			
		rest = redraw = true;	
		return;
	}
	
	if(hit) {
						
		if(yp - 50 < SCREEN_H) {
		
			yp += yc;
			yc += d * GRAVITY / 100;		
			
			rp += d * 2 * M_PI;
			
			rest = redraw = true;	
			
		} else {
			invading = false;
			hit = false;
			out = true;	
						
			bool ok = false;
			for(Target *target = Target::targets; target; target = target->nexttarget) {
				if(target->type == 1) {
					if(!((Squirrel *)target)->out) {
						ok = true;
						break;													
					}
				}
			}
			
			if(!game->squirrelinvasion) {		
				if(!ok) {
					game->wave++;
					game->squirrelinvasion = 12;
					game->nextsquirreltime = 4;			
					game->nextsquirrel = false;
				}
			}				
		}	
		return;
	}	
	
				
	if(!invading && game->squirrelinvasion == 12 - count && game->nextsquirrel) {
		
		game->squirrelinvasion--;
																															
		if(out) {
			
			out = false;
			
			steptime = 0.5;
			
			invading = true;
			lifes = game->wave;
			
			game->nextsquirrel = false;
																	
			if(side > 0) {
				side = -1;
				
				pos = 0;
				rp = 0;
				flip = false;
				
				line = right;
				xc = 1;
				
			} else {
				side = 1;
				
				pos = 1;
				rp = M_PI;				
				flip = true;
				
				line = left;
				xc = -1;
				
			}																					
		}
	}
	
	if(invading) {
		steptime -= d;
		
		if(steptime <= 0) {	
			steptime = 0.25;
			pos += xc * 3.0 / line->R;
			
			if(xc > 0) {
				if(pos > 1) {										
					if(line == left) {
						play_sample(squeak, 255, int(1 + 254.0 * (xp / SCREEN_W)), 1100, 0);
						play_sample(squeak, 255, int(1 + 254.0 * (xp / SCREEN_W)), 900, 0);
						
						if(game->leftballs) {
							game->leftballs--;
							leftbottomplate->rest = leftbottomplate->redraw = true;							
						} else {
							game->leftpoints /= 2;
							lefttopplate->rest = lefttopplate->redraw = true;
						}																	
						
						joy = 2;
						xc = 0;
						yc = 0;
					} else {
						pos = 0;						
						if(line == lefttop) {line = left; rp -= M_PI / 2;}
						if(line == righttop) line = lefttop;					
						if(line == right) {line = righttop; rp -= M_PI / 2;}
					}
				}
			}
			else if(xc < 0) {
				if(pos < 0) {										
					if(line == right) {
						play_sample(squeak, 255, int(1 + 254.0 * (xp / SCREEN_W)), 1100, 0);
						play_sample(squeak, 255, int(1 + 254.0 * (xp / SCREEN_W)), 900, 0);
						
						if(game->rightballs) {
							game->rightballs--;
							rightbottomplate->rest = rightbottomplate->redraw = true;							
						} else {
							game->rightpoints /= 2;
							righttopplate->rest = righttopplate->redraw = true;
						}
						
						joy = 2;						
						xc = 0;
						yc = 0;
					} else {
						
						pos = 1;
						if(line == righttop) {line = right; rp += M_PI / 2;}
						if(line == lefttop) line = righttop;
						if(line == left) {line = lefttop; rp += M_PI / 2;}
					}
				}
			}
		
			line->point(pos, &xp, &yp);
			
			rest = redraw = true;
		}
	}
}

void Squirrel::draw2() {
					
	if(redraw) {
		old = true;
		redraw = false;
		
		if(flip)
			rotate_sprite_v_flip(page, squirrel, int(xp) - 35, int(yp) - 35, itofix(int(rp * 128.0 / M_PI)));
		else
			rotate_sprite(page, squirrel, int(xp) - 35, int(yp) - 35, itofix(int(rp * 128.0 / M_PI)));
								
		xo = xp;
		yo = yp;
		ro = rp;	
	}
		
}