#include <allegro.h>

#include "main.h"

#include "game.h"
#include "ball.h"

#include "plate.h"

Plate *lefttopplate = 0;
Plate *righttopplate = 0;
Plate *leftbottomplate = 0;
Plate *rightbottomplate = 0;

Plate *middleplate = 0;


Plate::Plate(float _xp, float _yp, int w_, int h_, int _type) : Part(_xp, _yp, 0, 0) {
	
	redraw = true;		
	type = _type;
	
	drx1 = 0;
	dry1 = 0;
	drx2 = w_;
	dry2 = h_;
}

void Plate::draw() {
	if(redraw) {
		redraw = false;
		old = true;
		
		xo = xp;
		yo = yp;				
		
		if(type == 1) {															
			text_mode(-1);
			textprintf(page, (FONT *)(numberfont[0].dat), 0, 0, -1, "%05d", game->leftpoints);	
		}
		if(type == 2) {
			text_mode(-1);
			textprintf_right(page, (FONT *)(numberfont[0].dat), SCREEN_W, 0, -1, "%05d", game->rightpoints);
		}
		if(type == 3) {
			int i;
		
			for(i = 0; i < game->leftballs; i++) {
				draw_sprite(page, ball[0]->bmpl, 10 + i * 15, SCREEN_H - 20);
			}
				
		}
		
		if(type == 4) {
			int i;
		
			for(i = 0; i < game->rightballs; i++) {
				draw_sprite(page, ball[0]->bmpr, SCREEN_W - 1 - 10 - 14 - i * 15, SCREEN_H - 20);
			}
				
		}
		
		if(type == 5) {
			int i;
		
			for(i = 0; i < 4; i++) {
				if(ball[i]->out)
					draw_sprite(page, ball[0]->bmp, int(xp + i * 15), int(yp));
			}
		}
		
	}
}