#ifndef _PART_H_
#define _PART_H_

#include <math.h>

#define GRAVITY             200  // pixels / s / s
#define FLIPPER_ANGEL_SPEED 8.0  // in radians / second
#define COLLISION_LOST      0.80 // actually this is what remains
#define FRICTION            -0.30
#define POSADJUST           0.01
#define HITVAL              1.50 // multiply momentum from bar
#define BOTREFLECT           400 // acceleration from reflecting bottom in pixels / s / s
#define REFLECT              100 // acceleration from reflecting bottom in pixels / s / s

class Part {
public:
	static Part *first;
	Part *next;
		
	bool old, redraw, rest;
	int drx1, dry1, drx2, dry2;
	
	// Last displayed position
	float xo, yo, ro;
		
	// Current position	
	float xp, yp, rp;	
	
	// Position change
	float xc, yc, rc;		
	
	float R;
	
	Part(float _xp, float _yp, float _rp, float _R);
	
	virtual ~Part();
	
	bool is_near(Part *p, float D);
	
	virtual void draw() = 0;
	virtual void restore();
	virtual void draw2();
};

#endif