#include <allegro.h>

#include "main.h"

#include "part.h"

Part::Part(float _xp, float _yp, float _rp, float _R) :
	xp(_xp), yp(_yp), rp(_rp), R(_R) {
	
	old = false;
	redraw = false;
	rest = false;
	
	xc = yc = rc = 0;
	
	next = first;
	first = this;
}

Part::~Part() { // Only ever delete all at once
	first = 0;			
}

void Part::draw2() {}

Part *Part::first = 0;

bool Part::is_near(Part *p, float D) {
	return (p->xp - xp) * (p->xp - xp) + (p->yp - yp) * (p->yp - yp) <= D * D;
}

void Part::restore() {
	if(rest) {	
		rest = false;		
		if(old) {
			
			int x = int(xo) + drx1;
			int y = int(yo) + dry1;
			int w = 1 + drx2 - drx1;
			int h = 1 + dry2 - dry1;
						
			blit(background, page, x, y, x, y, w, h);
			
			old = false;	
			
			for(Part *part = first; part; part = part->next) {
				if(part != this) {
					int x2 = int(part->xo) + part->drx1;
					int y2 = int(part->yo) + part->dry1;
					int w2 = 1 + part->drx2 - part->drx1;
					int h2 = 1 + part->dry2 - part->dry1;
					if(x < x2 + w2 && x2 < x + w &&
					   y < y2 + h2 && y2 < y + h) {
					   	
					   part->redraw = true;
					   
					}
				}			
			}									
			
		}					
	}
}