#include "unit.h"

class Entry {
private:
	int x, y, w, h;	
	bool is_editing;			
	int editpos;
public:		
	char *name;
	int editlen;	
	bool is_active;	
	bool can_edit;
	bool can_change;
	bool is_sel;
	
	bool is_sliding;
	bool is_key;
	int val;		
	
	int row_next;
	int column_next;

	bool is_hit(int mx, int my);
	void restore();
	void draw();		
	
	void set(int x_, int y_, int w_, int h_, char *name_);
	
	void addchar(char ch);
};

class Menu : public Unit {	
public:
	Entry entries[256];
	int num;
	int sel;
	bool connecting;
	float acknowledging;	
	bool forceside;
	float time;
	
	float recordingflashtime;
	int recording;
			
	int netrate;
	int musicvol;
	int soundvol;
	
	int go;
	int go_internet;
	int go_fullscreen;	
	int go_out;	
	int go_story;		
	
	int slide_net;
	int slide_sound;
	int slide_music;	
	
	int rec_left1;
	int rec_right1;
	int rec_left2;
	int rec_right2;	
	
	int AI_left;
	int AI_right;
	
	int t[4];

	char highscore_names[5][40];
	int highscores[5];

	int side;
	char enter_name_str[40];
	char enter_address_str[40];
	bool windowed;

	Menu();
	
	int add_entry(int x, int y, int w, int h, char *name);		
	
	int process(float d);
	void redraw();
	void enter();
	void leave();
	
	void loadconfig();
	void saveconfig();	
};

extern Menu *menu;