#include <allegro.h>

#include "menu.h"
#include "game.h"
#include "intro.h"
#include "story.h"
#include "net.h"

volatile int ticks = 0;
static void ticker() { ticks++; } END_OF_FUNCTION(ticker);

BITMAP *background = 0;
BITMAP *page = 0;
BITMAP *video = 0;

SAMPLE *boing = 0;
SAMPLE *biong = 0;
SAMPLE *squeak = 0;
SAMPLE *bleam = 0;  
SAMPLE *vrumm = 0; 
SAMPLE *ex = 0; 

MIDI *music = 0; 
MIDI *music2 = 0; 

int fps;

DATAFILE *numberfont = 0;
DATAFILE *egyptfont = 0;

void redraw_background() {
	acquire_bitmap(page);	
	blit(background, page, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	release_bitmap(page);
}

volatile int displayswitched = 0;

static void displayswitch(void) {
	displayswitched = 1;
} END_OF_FUNCTION(displayswitch);

int setgfx(int mode) {
			
	if(numberfont) unload_datafile(numberfont);	
	numberfont = 0;		
	if(egyptfont) unload_datafile(egyptfont);
	egyptfont = 0;
				
	if(mode) {
		int cd = desktop_color_depth();
		
		if(cd <= 8) cd = 16;
		
		set_color_depth(cd);
		
		mode = GFX_AUTODETECT_WINDOWED;
	} else {
		
		int cd = desktop_color_depth();
		
		if(cd <= 8) cd = 16;
		
		set_color_depth(cd);
		                           
		mode = GFX_AUTODETECT;
	}
	         
	if(set_gfx_mode(mode, 640, 480, 0, 0) < 0) {			  
	   allegro_message("Graphics initialization error.\n");
	   return -1;
	}
	
	numberfont = load_datafile("font.dat");
	if(!numberfont) { allegro_message("Error loading numbers.\n"); exit(-1); }
	egyptfont = load_datafile("egypt.dat");
	if(!egyptfont) { allegro_message("Error loading hieroglyphs.\n"); exit(-1); }
		
	video = create_video_bitmap(SCREEN_W, SCREEN_H); // visible area
	
	page = create_video_bitmap(SCREEN_W, SCREEN_H); // backbuffer
	
	if(!page) page = create_bitmap(SCREEN_W, SCREEN_H);;
	
	if(!video) video = screen;
	if(!page) page = screen;
			
	if(set_display_switch_mode(SWITCH_BACKGROUND) < 0)
		set_display_switch_mode(SWITCH_BACKAMNESIA);
		
	LOCK_FUNCTION(displayswitch);		
	LOCK_VARIABLE(displayswitched);
	set_display_switch_callback(SWITCH_IN, displayswitch);			
									
	return 0;
}

int main(int argc, char **argv) {		
			
	if(allegro_init() < 0) {
		allegro_message("Allegro initialization error.\n");
	   return -1;
	}
	
	menu = new Menu();
		
	if(setgfx(menu->windowed) < 0) {
		return -1;
	}		
	
	install_timer();
	
	LOCK_VARIABLE(ticks);
	LOCK_FUNCTION(ticker);
	install_int(ticker, 1);
	
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);	
	
	if(install_keyboard() < 0) {
		allegro_message("Keyboard initialization error.\n");
	   return -1;
	}	
	
	if(install_mouse() < 0) {
		allegro_message("Mouse initialization error.\n");	   
	}		
			
	#ifndef NO_LIBNET			
		network = new Network();
	#endif			
					
	boing = load_sample("dat.dat#boing.wav");
	biong = load_sample("dat.dat#biong.wav");
	squeak = load_sample("dat.dat#squeak.wav");
	bleam = load_sample("dat.dat#bleam.wav");
	vrumm = load_sample("dat.dat#vrumm.wav");
	ex = load_sample("dat.dat#ex.wav"); 
	
	music = load_midi("dat.dat#beetbeat.mid");
	music2 = load_midi("dat.dat#allegro.mid");
		
	game = new Game;			
	intro = new Intro;
	story = new Story;
			
	Unit *unit = intro;	
	unit->enter();				
		
	int second;	
	int frames = 0;
		
	int t = ticks;
	second = t;
	while(true) {
		int nt = ticks;					
		float d = nt - t;
		
		if(nt - second >= 1000) {
			second += 1000;
			fps = frames;
			frames = 0;
		}
		
		d /= 1000;
		t = nt;
		
		int s = unit->process(d);
		
		if(s == 1) {					
			if(unit == menu) {
				unit->leave();								
				unit = game;	
				unit->enter();							
			} else {		
													
				unit->leave();								
				unit = menu;
				unit->enter();				
			}			
		}
		if(s == 2) break;	
		if(s == 3) {
			menu->leave();
			unit = story;
			story->enter();
		}									
				
		acquire_bitmap(page);				
		
		unit->redraw();
						
		if(page != video) {	
			acquire_bitmap(video);				
									
			blit(page, video, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		
			release_bitmap(video);	
		}
		
		release_bitmap(page);	
		
		frames++;
				
	}
		
	return 0;
} END_OF_MAIN();