#include <allegro.h>

#include "intro.h"
#include "main.h"

Intro *intro;

Intro::Intro() {
	
}

static int cursorx, cursory;
static int cursorcol;
static BITMAP *cli, *al;

static void titlebar() {
	rectfill(cli, 0, 0, SCREEN_W - 42, 9, makecol(255, 255, 255));			
	rectfill(cli, SCREEN_W - 40, 0, SCREEN_W - 22, 9, makecol(255, 255, 255));			
			
	rect(cli, SCREEN_W - 40 + 1, 1,  SCREEN_W - 40 + 1 + 13, 1 + 5,  makecol(0, 96, 192));	
	rectfill(cli, SCREEN_W - 40 + 3, 3,  SCREEN_W - 40 + 3 + 13, 3 + 5,  makecol(0, 0, 0));							
			
	rectfill(cli, SCREEN_W - 20, 0, SCREEN_W - 2, 9, makecol(255, 255, 255));			
	vline(cli, SCREEN_W - 1, 1, 9, makecol(255, 255, 255));
			
	rectfill(cli, SCREEN_W - 20 + 1, 1,  SCREEN_W - 20 + 1 + 13, 1 + 5,  makecol(0, 0, 0));	
	rectfill(cli, SCREEN_W - 20 + 3, 3,  SCREEN_W - 20 + 3 + 13, 3 + 5,  makecol(255, 255, 255));
	rect(cli, SCREEN_W - 20 + 3, 3,  SCREEN_W - 20 + 3 + 13, 3 + 5,  makecol(0, 96, 192));
			
	hline(cli, 66, 1, SCREEN_W - 42, makecol(0, 96, 192));
	hline(cli, 66, 3, SCREEN_W - 42, makecol(0, 96, 192));
	hline(cli, 66, 5, SCREEN_W - 42, makecol(0, 96, 192));
	hline(cli, 66, 7, SCREEN_W - 42, makecol(0, 96, 192));
						
	textprintf(cli, font, 2, 1, makecol(0, 96, 192), "AmigaDOS");
}

static void cursor_on() {
	rectfill(cli, cursorx, cursory, cursorx + 7, cursory + 7, makecol(255, 128, 0));		
}
static void cursor_off() {
	rectfill(cli, cursorx, cursory, cursorx + 7, cursory + 7, makecol(0, 96, 192));
}

static char str[] = "1> 5+4|2+\n\n|(|34|-|4<|< 2001 - 7|-||2|0|\\| \\/\\/|-|;+3(|00|2 3|\\|+|-|3|-|\n3|\\|+|2`/\n4|3|5 ~ |\\|3+\\/\\/0|3|\\/|\n\n1> 4|3|5\n<|24|50|=+ ||2353|\\|+5\n\n;|\\| <00|3|24+;0n \\/\\/;+|-| |0\\/|24`/ 3.5\n4|\\|(| |_;|8|\\|3+ 0.9.11\n4|\\| 31;45 |5<|-|3|2|\\|;6 64|\\/|3\n4|\\| 4|_|_36|20 4.0 ||20(|(_)+;0|\\|\n5|3<;4l +|-|4|\\||<5 60 +0 ><~\\/;;14 3|\\|+|-|3+|-|3 (|353|23|\n4|_|_36|20 |84++|_3 |;|\\||84|_|_ 5;|\\/|(_)|_4+0|2\n\n!|_3\\/;|\\|6 \\/;|2+(_)4|_;+`/ |\\|0\\/\\/..";

static int strpos;

int print(int pos) {
	int c = str[pos];
	int r = 1;
	
	cursor_off();
	if(c == '\n') {		
		cursorx = 2;
		cursory += 10;		
	}
	else if(c == 0) {				
		r = 0;
	}
	else if(c == '!') {				
		cursorcol = makecol(50, 100, 255);
	}
	else if(c == '') {				
		r = 4;
	}
	else {
		textprintf(cli, font, cursorx, cursory, cursorcol, "%c", c);
		cursorx += 8;
	}

	cursor_on();
	
	return r;
}

int Intro::process(float d) {	
	static int oldy;
	
	while(keypressed()) {
		int k = readkey();
		k >>= 8;
		if(k == KEY_ESC || k == KEY_SPACE || k == KEY_ENTER) {									
			return 1;
		}
	}
	
	if(time >= actiontime) {
		
		if(stage == 1) {
			
			clear_to_color(cli, makecol(0, 96, 192));												
			text_mode(-1);
					
			titlebar();		
						
			textprintf(cli, font, 2, 11, makecol(255, 255, 255), "Copyright (C) 1985 Commodore-Amiga, Inc.");
			textprintf(cli, font, 2, 21, makecol(255, 255, 255), "All right reserved.");
			textprintf(cli, font, 2, 31, makecol(255, 255, 255), "Version 1.0");
			
			
			cursorx = 2;
			cursory = 41;
			cursorcol = makecol(255, 255, 255);
			
			cursor_on();	
																		
			actiontime += 1.0;
			stage++;						
		}		
		else if(stage == 2) {
			strpos = 0;
			stage = 3;
		}
		else if(stage == 3) {
			int s = print(strpos);
			strpos++;
			actiontime += 0.02 * float(s);
			if(s == 0) {
				actiontime = time + 0.5;
				stage = 4;		
				
				BITMAP *tmp = create_bitmap(SCREEN_W, SCREEN_H);
			
				for(int i = 0; i < cli->h; i++) {
					blit(cli, tmp, 0, i, 0, i * 2, cli->w, 1);
					hline(tmp, 0, i * 2 + 1, cli->w - 1, makecol(256 * i / cli->h, 0, 0));
				}			
				destroy_bitmap(cli);			
				cli = tmp;
						
			}
		}
		else if(stage == 4) {
			actiontime = time;
			stage = 5;
									
			al = load_bitmap("dat.dat#allegro4.bmp", NULL);																					
			
			play_sample(ex, 255, 128, 1000, 0);
			play_sample(ex, 255, 128, 200, 0);
		}
		else if(stage == 5) {
																	
			float t = time - actiontime;
			for(int y = 0; y < cli->h; y++) {
				for(int x = 0; x < cli->w; x++) {
					
					int dx = cursorx - x;
					
					int dy = cursory * 2 - y;
					
					float fx = float(dx) / float(SCREEN_W);
					
					float fy = float(dy) / float(SCREEN_H);
										
					float q = fx * fx + fy * fy;										
					
					float a = atan2(fy, fx);
					
					float d = sqrt(q);
					
					float a2 = a + sin(d);
					
					float s = d * (0.8 + 0.1 + 0.1 * sin(a2 * 7 * 7) * sin(a2 * 7));
					
					float v = t - s;
						
					int r;
					int g;
					int b;
											
					if(v > 1)
						putpixel(cli, x, y, getpixel(al, x, y));
					else if(v > 0) {	
						if(v > 0.1) {					
							float v1 = (1.1 - v);
							float v2 = v1 * v1;
												
							r = int(v1 * 255.0);
							g = int(v2 * 255.0);
							b = int(v2 * v2 * 255.0);
								
						} else {
							r = int(v/0.1 * 255.0);
							g = int(v/0.1 * 255.0);
							b = int(v/0.1 * 255.0);
						}			
						putpixel(cli, x, y, makecol(r, g, b));		
					}
																
				}
			}
			if(t > 4) {
				play_midi(music2, 0);
				stage++;
				oldy = 0;
				actiontime = time;
				
				destroy_bitmap(al);
				al = load_bitmap("dat.dat#main.bmp", NULL);
			}
		}
		else if(stage == 6) {			
			int y = int(25 * (time - actiontime) * (time - actiontime));
			blit(cli, cli, 0, oldy, 0, y, cli->w, cli->h - y);			
			
			blit(al, cli, 0, oldy, 0, oldy, cli->w, 1 + y - oldy);
			oldy = y;
			
			if(y >= cli->h) {
				return 1;
			}
		}
						
	}		
	
	time += d;
	
	return 0;
}

void Intro::redraw() {
	int i;			
	
	if(stage < 4) {
		for(i = 0; i < cli->h; i++) {
			blit(cli, page, 0, i, 0, i * 2, cli->w, 1);
		}		
	} else {
		blit(cli, page, 0, 0, 0, 0, cli->w, cli->h);
	}			
	
}

void Intro::enter() {
		
	time = 0;	
		
	cli = create_bitmap(SCREEN_W, SCREEN_H / 2);	
	al = 0;
	clear_to_color(cli, makecol(255, 255, 255));
	
	BITMAP *bmp = load_bitmap("dat.dat#amiga.bmp", NULL);
	
	blit(bmp, cli, 0, 0, (cli->w - bmp->w) / 2, (cli->h - bmp->h) / 2,
		bmp->w, bmp->h);
		
	destroy_bitmap(bmp);
	
	stage = 1;
	actiontime = time + 2;
		
	clear_to_color(page, makecol(0, 0, 0));				
}

void Intro::leave() {
	if(cli) destroy_bitmap(cli);
	if(al) destroy_bitmap(al);
}	
	
