#include <allegro.h>

#include "main.h"

#include "game.h"
#include "plate.h"

#include "ball.h"

#include "ferret.h"

BITMAP *Ferret::ferret = 0;

Ferret::Ferret(float _xp, float _yp, float _rp, float _R, float _flip) : Target(_xp, _yp, _rp, _R) {
	owncol = true;
	type = 0;
	
	flip = _flip;
	
	drx1 = -35;
	dry1 = -35;
	drx2 = 35;
	dry2 = 35;
}

bool Ferret::collide(Ball *b) {
	if(b->who == -1) {
		game->leftpoints += 10;
				
		lefttopplate->rest = lefttopplate->redraw = true;									
						
		if(flip) rp -= M_PI / 16;
		else rp += M_PI / 16;			
		
		rest = redraw = true;
	}
	if(b->who == 1) {
		game->rightpoints += 10;
						
		righttopplate->rest = righttopplate->redraw = true;
		
		if(flip) rp -= M_PI / 16;
		else rp += M_PI / 16;				
		
		rest = redraw = true;
	}
	
	if(rp >= M_PI * 2 || rp <= -M_PI * 2) {
		
		play_sample(ex, 255, 128, 1000, 0);
		
		rp = 0;
		
		if(xp > SCREEN_W / 2) {
			game->rightballs++;
			game->rightpoints += 100;
			rightbottomplate->rest = rightbottomplate->redraw = true;
		} else {
			game->leftballs++;
			game->leftpoints += 100;
			leftbottomplate->rest = leftbottomplate->redraw = true;	
		}
		
	}
	
	return true;
}

void Ferret::draw2() {
	if(redraw) {
		old = true;
		redraw = false;
		
		if(flip)
			rotate_sprite_v_flip(page, ferret, int(xp) - 35, int(yp) - 35, itofix(128 + int(rp * 128.0 / M_PI)));
		else
			rotate_sprite(page, ferret, int(xp) - 35, int(yp) - 35, itofix(int(rp * 128.0 / M_PI)));
			
		xo = xp;
		yo = yp;
		ro = rp;	
	}
}