
/* Arrrgggg, wave-mixing directsound code was so hard to find, but the
   resulting header file is less than 200 lines. */

#ifndef _win32sound_h
#define _win32sound_h

/*
#define install_sound(a, b, c)
class SAMPLE { public: };
#define play_sample(a, b, c, d, e)
#define stop_sample(x)
SAMPLE *load_wave(char *fname) { return 0; }
*/

#define DIGI_AUTODETECT 0
#define MIDI_AUTODETECT 0

#include <dsound.h>
#include <mmsystem.h>
#include <math.h>

int _sound_volume=255;
void set_volume(int fxvol, int midivol) {
  if (fxvol > 255) { fxvol = 255; }
  if (fxvol < 0) { fxvol = 0; }
  _sound_volume = fxvol;
}

class directsound_type { public:
  LPDIRECTSOUND dsound;
  directsound_type() { dsound = 0; }
  ~directsound_type() { if (dsound) { dsound->Release(); } }
} _dsound;

#define MAX_SAMPLES 8    // how many times 1 sample can be playing at once

class SAMPLE { public:
  int current;
  DWORD freq;
  LPDIRECTSOUNDBUFFER buffer[MAX_SAMPLES];
};

SAMPLE *load_wav(char *fname) {
  if (!_dsound.dsound) { return 0; }

  LPDIRECTSOUNDBUFFER buffer;

  HMMIO wavefile = mmioOpen(fname, 0, MMIO_READ|MMIO_ALLOCBUF);
  if (!wavefile) { return 0; }

  //find wave data
  MMCKINFO parent;
  memset(&parent,0,sizeof(MMCKINFO));
  parent.fccType = mmioFOURCC('W','A','V','E');
  mmioDescend(wavefile, &parent,0,MMIO_FINDRIFF);

  //find fmt data
  MMCKINFO child;
  memset(&child,0,sizeof(MMCKINFO));
  child.fccType = mmioFOURCC('f','m','t',' ');
  mmioDescend(wavefile,&child,&parent,0);

  //read the format
  WAVEFORMATEX wavefmt;
  mmioRead(wavefile,(char*)&wavefmt,sizeof(wavefmt));
  if(wavefmt.wFormatTag != WAVE_FORMAT_PCM) { return 0; }

  //find the wave data chunk
  mmioAscend(wavefile,&child,0);
  child.ckid = mmioFOURCC('d','a','t','a');
  mmioDescend(wavefile,&child,&parent,MMIO_FINDCHUNK);

  //create a directsound buffer to hold wave data
  DSBUFFERDESC bufdesc;
  memset(&bufdesc,0,sizeof(DSBUFFERDESC));
  bufdesc.dwSize = sizeof(DSBUFFERDESC);
  bufdesc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY;
  bufdesc.dwBufferBytes = child.cksize;
  bufdesc.lpwfxFormat = &wavefmt;
  if(DS_OK != (_dsound.dsound->CreateSoundBuffer(&bufdesc,&buffer,NULL))) {
    return 0;
  }

  //write wave data to directsound buffer you just created
  void *write1=0,*write2=0;
  unsigned long length1,length2;
  buffer->Lock(0,child.cksize,&write1,&length1,&write2,&length2,0);
  if(write1>0)
	  mmioRead(wavefile,(char*)write1,length1);
  if(write2>0)
	  mmioRead(wavefile,(char*)write2,length2);
  buffer->Unlock(write1,length1,write2,length2);

  //close the wavefile, don't need it anymore, it's in the directsound buffer now
  mmioClose(wavefile,0);

  SAMPLE *result = new SAMPLE;
  buffer->GetFrequency(&result->freq);
  result->current = 0;
  result->buffer[0] = buffer;
  for (int i = 1; i < MAX_SAMPLES; i++) {
    result->buffer[i] = 0;
    _dsound.dsound->DuplicateSoundBuffer(buffer, &result->buffer[i]);
  }

  return result;
}

int volume_table[256] = { 0 };

void install_sound(int ignore1, int ignore2, char *ignore3) {
  if (DirectSoundCreate(0, &_dsound.dsound, 0) != DS_OK) { return; }
  if (_dsound.dsound->SetCooperativeLevel(_window.hWnd, DSSCL_NORMAL) != DS_OK) {
    _dsound.dsound->Release();
    _dsound.dsound = 0;
  }
  volume_table[0] = 0;
  for (int v = 1; v < 256; v++) {
    volume_table[v] = (unsigned char)(106.0 * log10(v));
  }
}

void play_sample(SAMPLE *sample, int volume, int pan, int freq, int loop) {
  if (!_dsound.dsound || !sample) { return; }

  int i = sample->current;
  if (!sample->buffer[i]) { return; }
  sample->buffer[i]->SetCurrentPosition(0);
  freq = sample->freq * freq / 1000;
  if (freq > DSBFREQUENCY_MAX) { freq = DSBFREQUENCY_MAX; }
  if (freq < DSBFREQUENCY_MIN) { freq = DSBFREQUENCY_MIN; }

  sample->buffer[i]->SetFrequency(freq);

  if (volume < 0) { volume = 0; }
  if (volume > 255) { volume = 255; }
  volume = volume_table[volume * _sound_volume / 255];
  int ds_vol = DSBVOLUME_MIN + volume * (DSBVOLUME_MAX - DSBVOLUME_MIN) / 255;
  sample->buffer[i]->SetVolume(ds_vol);

  // pan = 64 means multiply right by .5
  // pan = 32 means multiply right by .25
  if (pan > 127) {
    pan = 255 - pan;
    if (pan != 0) {
      double mul = pan / 128.0;
      pan = -log10(mul) * 1000;
      if (pan > DSBPAN_RIGHT) { pan = DSBPAN_RIGHT; }
    } else {
      pan = DSBPAN_RIGHT;
    }
  } else {
    if (pan != 0) {
      double mul = pan / 128.0;
      pan = log10(mul) * 1000;
      if (pan < DSBPAN_LEFT) { pan = DSBPAN_LEFT; }
    } else {
      pan = DSBPAN_LEFT;
    }
  }
  sample->buffer[i]->SetPan(pan);

  sample->buffer[i]->Play(0, 0, loop ? DSBPLAY_LOOPING: 0);
  sample->current++;
  if (sample->current >= MAX_SAMPLES) { sample->current = 0; }
}

void stop_sample(SAMPLE *sample) {
  if (!sample) { return; }
  for (int i = 0; i < MAX_SAMPLES; i++) {
    sample->buffer[i]->Stop();
  }
}

void destroy_sample(SAMPLE *sample) {
  if (!sample) { return; }
  for (int i = 0; i < MAX_SAMPLES; i++) {
    sample->buffer[i]->Release();
  }
}

#endif
