#ifndef _win32_midi_h
#define _win32_midi_h

#include <string.h>
#include "mmsystem.h"

class MIDI { public: char *fname; };
MIDI *load_midi(char *fname) { MIDI *result = new MIDI; result->fname = new char[strlen(fname)+1]; strcpy(result->fname, fname); return result; }
void destroy_midi(MIDI *m) { if (m) { delete[] m->fname; } delete m; }

UINT wDeviceID;

void close_midi() {
  if (wDeviceID) {
    mciSendCommand(wDeviceID, MCI_STOP, 0, 0);
    mciSendCommand(wDeviceID, MCI_CLOSE, 0, 0);
    wDeviceID = 0;
  }
}

// Plays a specified MIDI file by using MCI_OPEN and MCI_PLAY. Returns
// as soon as playback begins. The window procedure function for the
// specified window will be notified when playback is complete.
// Returns 0L on success; otherwise, it returns an MCI error code.
DWORD playMIDIFile(HWND hWndNotify, char *lpszMIDIFileName) {
DWORD dwReturn;
MCI_OPEN_PARMS mciOpenParms;
MCI_PLAY_PARMS mciPlayParms;
MCI_STATUS_PARMS mciStatusParms;
MCI_SEQ_SET_PARMS mciSeqSetParms;

// Open the device by specifying the device and filename.
// MCI will attempt to choose the MIDI mapper as the output port.
mciOpenParms.lpstrDeviceType = "sequencer";
mciOpenParms.lpstrElementName = lpszMIDIFileName;
if (dwReturn = mciSendCommand(NULL, MCI_OPEN,
    MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,        // Continued if statement
    (DWORD)(LPVOID) &mciOpenParms))          // Continued if statement
     {
     // Failed to open device. Don't close it; just return error.
     return (dwReturn);
     }

// The device opened successfully; get the device ID.
wDeviceID = mciOpenParms.wDeviceID;

// Check if the output port is the MIDI mapper.
mciStatusParms.dwItem = MCI_SEQ_STATUS_PORT;
if (dwReturn = mciSendCommand(wDeviceID, MCI_STATUS, 
    MCI_STATUS_ITEM, (DWORD)(LPVOID) &mciStatusParms)) // Continued if
     {
     mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
     return (dwReturn);
     }

// Begin playback. The window procedure function for the parent 
// window will be notified with an MM_MCINOTIFY message when 
// playback is complete. At this time, the window procedure closes 
// the device.
mciPlayParms.dwCallback = (DWORD) hWndNotify;
if (dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, MCI_NOTIFY,
    (DWORD)(LPVOID) &mciPlayParms))        // Continued if statement
     {
     mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
     return (dwReturn);
     }

mciSeqSetParms;
return (0L);
}

void play_midi(MIDI *m, int loop) {
  if (m) {
    playMIDIFile(_window.hWnd, m->fname);
    _active_midi = loop ? m: 0;
  } else {
    _active_midi = 0;
    close_midi();
  }
}

void _replay_midi() {
  if (_active_midi) {
    MIDI *m = _active_midi;
    _active_midi = 0;
    play_midi(0, 0);

    play_midi(m, 1);
    _active_midi = m;
  }
}
#endif
